/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.code;

import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.VariableDeclaration;

public class TempAssignmentFinder
extends ASTVisitor {
    private ASTNode fFirstAssignment;
    private IVariableBinding fTempBinding;

    TempAssignmentFinder(VariableDeclaration tempDeclaration) {
        this.fTempBinding = tempDeclaration.resolveBinding();
    }

    private boolean isNameReferenceToTemp(Name name) {
        return this.fTempBinding == name.resolveBinding();
    }

    private boolean isAssignmentToTemp(Assignment assignment) {
        if (this.fTempBinding == null) {
            return false;
        }
        if (!(assignment.getLeftHandSide() instanceof Name)) {
            return false;
        }
        Name ref = (Name)assignment.getLeftHandSide();
        return this.isNameReferenceToTemp(ref);
    }

    boolean hasAssignments() {
        return this.fFirstAssignment != null;
    }

    ASTNode getFirstAssignment() {
        return this.fFirstAssignment;
    }

    @Override
    public boolean visit(Assignment assignment) {
        if (!this.isAssignmentToTemp(assignment)) {
            return true;
        }
        this.fFirstAssignment = assignment;
        return false;
    }

    @Override
    public boolean visit(PostfixExpression postfixExpression) {
        if (postfixExpression.getOperand() == null) {
            return true;
        }
        if (!(postfixExpression.getOperand() instanceof SimpleName)) {
            return true;
        }
        SimpleName simpleName = (SimpleName)postfixExpression.getOperand();
        if (!this.isNameReferenceToTemp(simpleName)) {
            return true;
        }
        this.fFirstAssignment = postfixExpression;
        return false;
    }

    @Override
    public boolean visit(PrefixExpression prefixExpression) {
        if (prefixExpression.getOperand() == null) {
            return true;
        }
        if (!(prefixExpression.getOperand() instanceof SimpleName)) {
            return true;
        }
        if (!prefixExpression.getOperator().equals(PrefixExpression.Operator.DECREMENT) && !prefixExpression.getOperator().equals(PrefixExpression.Operator.INCREMENT)) {
            return true;
        }
        SimpleName simpleName = (SimpleName)prefixExpression.getOperand();
        if (!this.isNameReferenceToTemp(simpleName)) {
            return true;
        }
        this.fFirstAssignment = prefixExpression;
        return false;
    }
}

