/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.AttrChangeContext;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.DefaultCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSAttr;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSCharsetRule;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.css.core.internal.util.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class CharsetRuleFormatter
extends DefaultCSSSourceFormatter {
    public static final String CHARSET = "@charset";
    private static CharsetRuleFormatter instance;

    CharsetRuleFormatter() {
    }

    @Override
    public StringBuffer formatAttrChanged(ICSSNode node, ICSSAttr attr, boolean insert, AttrChangeContext context) {
        StringBuffer buf = new StringBuffer();
        if (node == null || attr == null) {
            return buf;
        }
        if (!"encoding".equalsIgnoreCase(attr.getName())) {
            return buf;
        }
        if (context != null && ((IndexedRegion)((Object)node)).getEndOffset() > 0) {
            if (attr != null && ((IndexedRegion)((Object)attr)).getEndOffset() > 0) {
                ITextRegion prev;
                IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(((IndexedRegion)((Object)attr)).getStartOffset());
                ITextRegion region = flatNode.getRegionAtCharacterOffset(((IndexedRegion)((Object)attr)).getStartOffset());
                RegionIterator it = new RegionIterator(flatNode, region);
                it.prev();
                context.start = it.hasPrev() ? ((prev = it.prev()).getType() == "S" ? it.getStructuredDocumentRegion().getStartOffset(prev) : it.getStructuredDocumentRegion().getStartOffset(region)) : it.getStructuredDocumentRegion().getStartOffset(region);
                context.end = it.getStructuredDocumentRegion().getEndOffset(region);
            } else {
                IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(((IndexedRegion)((Object)node)).getEndOffset() - 1);
                ITextRegion region = flatNode.getRegionAtCharacterOffset(((IndexedRegion)((Object)node)).getEndOffset() - 1);
                if (region.getType() == "S") {
                    context.start = flatNode.getStartOffset(region);
                    context.end = flatNode.getStartOffset(region);
                } else {
                    context.start = flatNode.getEndOffset() + 1;
                    context.end = flatNode.getEndOffset();
                }
            }
        }
        if (insert) {
            this.appendSpaceBefore(node, attr.getValue(), buf);
            buf.append(attr.getValue());
        }
        return buf;
    }

    @Override
    protected void formatPre(ICSSNode node, StringBuffer source) {
        int end = ((IndexedRegion)((Object)node)).getEndOffset();
        if (end > 0) {
            int start = ((IndexedRegion)((Object)node)).getStartOffset();
            this.formatPre(node, new FormatRegion(start, end - start), source);
        } else {
            Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
            String quote = preferences.getString("quote");
            String str = CHARSET;
            if (preferences.getInt("identifierCase") == 2) {
                str = CHARSET.toUpperCase();
            }
            source.append(str);
            String enc = ((ICSSCharsetRule)node).getEncoding();
            quote = CSSUtil.detectQuote(enc, quote);
            str = String.valueOf(quote) + (enc != null ? enc : "") + quote + ";";
            this.appendSpaceBefore(node, str, source);
            source.append(str);
        }
    }

    @Override
    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if ((i != 0 || CharsetRuleFormatter.needS(outside[0])) && !regions[i].getType().equals("DELIMITER")) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedIdentRegion(regions[i], stgy));
            ++i;
        }
        if (CharsetRuleFormatter.needS(outside[1]) && !this.isIncludesPreEnd(node, region)) {
            this.appendSpaceBefore(node, outside[1], source);
        }
    }

    @Override
    public int getAttrInsertPos(ICSSNode node, String attrName) {
        if (node == null || attrName == null || attrName.length() == 0) {
            return -1;
        }
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        if (!"encoding".equalsIgnoreCase(attrName)) {
            return -1;
        }
        ICSSAttr attr = (ICSSAttr)node.getAttributes().getNamedItem("encoding");
        if (attr != null && ((IndexedRegion)((Object)attr)).getEndOffset() > 0) {
            return ((IndexedRegion)((Object)attr)).getStartOffset();
        }
        IndexedRegion iNode = (IndexedRegion)((Object)node);
        if (iNode.getEndOffset() <= 0) {
            return -1;
        }
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(node.getOwnerDocument().getModel().getStructuredDocument(), new FormatRegion(iNode.getStartOffset(), iNode.getEndOffset() - iNode.getStartOffset()), stgy);
        int i = regions.length - 1;
        while (i >= 0) {
            if (regions[i].getType() != "COMMENT") {
                return regions[i].getStartOffset();
            }
            --i;
        }
        return iNode.getEndOffset();
    }

    @Override
    public int getChildInsertPos(ICSSNode node) {
        int n = ((IndexedRegion)((Object)node)).getEndOffset();
        if (n > 0) {
            IStructuredDocumentRegion flatNode = node.getOwnerDocument().getModel().getStructuredDocument().getRegionAtCharacterOffset(n - 1);
            if (flatNode.getRegionAtCharacterOffset(n - 1).getType() == "DELIMITER") {
                return n - 1;
            }
            return n;
        }
        return -1;
    }

    public static synchronized CharsetRuleFormatter getInstance() {
        if (instance == null) {
            instance = new CharsetRuleFormatter();
        }
        return instance;
    }
}

