/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.DeclContainerFormatter;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class FontFaceRuleFormatter
extends DeclContainerFormatter {
    public static final String FONT_FACE = "@font-face";
    private static FontFaceRuleFormatter instance;

    FontFaceRuleFormatter() {
    }

    @Override
    protected void formatPre(ICSSNode node, StringBuffer source) {
        int end;
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        int start = ((IndexedRegion)((Object)node)).getStartOffset();
        int n = end = node.getFirstChild() != null && ((IndexedRegion)((Object)node.getFirstChild())).getEndOffset() > 0 ? ((IndexedRegion)((Object)node.getFirstChild())).getStartOffset() : this.getChildInsertPos(node);
        if (end > 0) {
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            int i = 0;
            while (i < regions.length) {
                if (i != 0) {
                    this.appendSpaceBefore(node, regions[i], source);
                }
                source.append(this.decoratedIdentRegion(regions[i], stgy));
                ++i;
            }
        } else {
            String str = FONT_FACE;
            if (CSSCorePlugin.getDefault().getPluginPreferences().getInt("identifierCase") == 2) {
                str = FONT_FACE.toUpperCase();
            }
            source.append(str);
            this.appendSpaceBefore(node, "{", source);
            source.append("{");
        }
        this.appendDelimBefore(node, null, source);
    }

    @Override
    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || FontFaceRuleFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedIdentRegion(regions[i], stgy));
            ++i;
        }
        if (FontFaceRuleFormatter.needS(outside[1])) {
            if (this.isIncludesPreEnd(node, region)) {
                this.appendDelimBefore(node, null, source);
            } else {
                this.appendSpaceBefore(node, outside[1], source);
            }
        }
    }

    public static synchronized FontFaceRuleFormatter getInstance() {
        if (instance == null) {
            instance = new FontFaceRuleFormatter();
        }
        return instance;
    }
}

