/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.document;

import java.io.File;
import java.util.Vector;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.core.internal.NodeList;
import org.eclipse.wst.dtd.core.internal.event.IDTDFileListener;
import org.eclipse.wst.dtd.core.internal.event.NodesEvent;
import org.eclipse.wst.dtd.core.internal.provisional.document.DTDModel;
import org.eclipse.wst.dtd.core.internal.util.DTDReferenceUpdater;
import org.eclipse.wst.dtd.core.internal.util.LabelValuePair;
import org.eclipse.wst.sse.core.internal.model.AbstractStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.events.IStructuredDocumentListener;
import org.eclipse.wst.sse.core.internal.provisional.events.NewDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.NoChangeEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.RegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentRegionsReplacedEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public final class DTDModelImpl
extends AbstractStructuredModel
implements IStructuredDocumentListener,
DTDModel {
    private DTDFile document;
    private Vector ignoredEntityRefs;
    private boolean refreshRequired = false;
    protected DTDReferenceUpdater refUpdater = new DTDReferenceUpdater();

    public static boolean deleteFile(String fileName) {
        boolean result = false;
        File file = new File(fileName);
        if (file.exists()) {
            result = file.delete();
        }
        return result;
    }

    public DTDModelImpl() {
        this.document = new DTDFile(this);
        this.document.addDTDFileListener(new IDTDFileListener(){

            @Override
            public void nodeChanged(DTDNode node) {
                Entity entity;
                if (node instanceof Entity && (entity = (Entity)node).isParameterEntity() && entity.isExternalEntity()) {
                    DTDModelImpl.this.setReferencedModelsChanged();
                }
            }

            @Override
            public void nodesAdded(NodesEvent event) {
                DTDModelImpl.this.checkIfExternalReferencesChanged(event);
            }

            @Override
            public void nodesRemoved(NodesEvent event) {
                DTDModelImpl.this.checkIfExternalReferencesChanged(event);
            }
        });
    }

    @Override
    public void beginRecording(Object requester, String label) {
        super.beginRecording(requester, label);
        this.getReferenceUpdater().clearCache();
    }

    void checkIfExternalReferencesChanged(NodesEvent event) {
        for (DTDNode node : event.getNodes()) {
            Entity entity;
            if (!(node instanceof Entity) || !(entity = (Entity)node).isParameterEntity() || !entity.isExternalEntity()) continue;
            this.setReferencedModelsChanged();
        }
    }

    public LabelValuePair[] createParmEntityContentItems(Entity entity) {
        NodeList entities = this.getDTDFile().getEntities();
        Vector<LabelValuePair> items = new Vector<LabelValuePair>();
        if (entity != null) {
            String name = "%" + entity.getName() + ";";
            items.addElement(new LabelValuePair(name, name));
        }
        for (Entity entityAt : entities.getNodes()) {
            if (!entityAt.isParameterEntity() || !entityAt.isExternalEntity()) continue;
            String name = "%" + entityAt.getName() + ";";
            items.addElement(new LabelValuePair(name, name));
        }
        Object[] comboArray = new LabelValuePair[items.size()];
        items.copyInto(comboArray);
        return comboArray;
    }

    @Override
    public void endRecording(Object requester) {
        super.endRecording(requester);
        this.getReferenceUpdater().clearCache();
    }

    public DTDFile getDTDFile() {
        return this.document;
    }

    public Vector getIgnoredEntityRefs() {
        if (this.ignoredEntityRefs == null) {
            this.ignoredEntityRefs = new Vector();
        }
        return this.ignoredEntityRefs;
    }

    @Override
    public IndexedRegion getIndexedRegion(int offset) {
        if (this.document == null) {
            return null;
        }
        return this.document.getNodeAt(offset);
    }

    public DTDReferenceUpdater getReferenceUpdater() {
        return this.refUpdater;
    }

    public boolean isReferencedModelsChanged() {
        return this.refreshRequired;
    }

    public boolean isRefreshRequired() {
        return this.refreshRequired;
    }

    @Override
    public void newModel(NewDocumentEvent flatModelEvent) {
        this.document.newModel(flatModelEvent);
        this.outputStructuredDocument(flatModelEvent);
    }

    @Override
    public void noChange(NoChangeEvent flatModelEvent) {
        this.outputStructuredDocument(flatModelEvent);
    }

    @Override
    public void nodesReplaced(StructuredDocumentRegionsReplacedEvent flatModelEvent) {
        this.document.nodesReplaced(flatModelEvent);
        this.outputStructuredDocument(flatModelEvent);
    }

    public void outputStructuredDocument(StructuredDocumentEvent flatModelEvent) {
    }

    public void outputStructuredDocumentRegion(IStructuredDocumentRegion flatNode) {
    }

    @Override
    public void regionChanged(RegionChangedEvent flatModelEvent) {
        this.document.regionChanged(flatModelEvent);
        this.outputStructuredDocument(flatModelEvent);
    }

    @Override
    public void regionsReplaced(RegionsReplacedEvent flatModelEvent) {
        this.document.regionsReplaced(flatModelEvent);
        this.outputStructuredDocument(flatModelEvent);
    }

    public void setReferencedModelsChanged() {
        this.refreshRequired = true;
    }

    public void setRefreshRequired(boolean value) {
        this.refreshRequired = value;
    }

    @Override
    public void setStructuredDocument(IStructuredDocument newStructuredDocument) {
        IStructuredDocument oldStructuredDocument = super.getStructuredDocument();
        if (newStructuredDocument == oldStructuredDocument) {
            return;
        }
        if (oldStructuredDocument != null) {
            oldStructuredDocument.removeDocumentChangingListener(this);
        }
        super.setStructuredDocument(newStructuredDocument);
        if (newStructuredDocument != null) {
            if (newStructuredDocument.getLength() > 0) {
                this.newModel(new NewDocumentEvent(newStructuredDocument, this));
            }
            newStructuredDocument.addDocumentChangingListener(this);
        }
    }
}

