/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.util;

import java.util.List;
import org.eclipse.wst.dtd.core.internal.Attribute;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.CMGroupNode;
import org.eclipse.wst.dtd.core.internal.CMNode;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.ParameterEntityReference;

public class DTDVisitor {
    public boolean isParameterEntityRef(String reference) {
        if (reference.length() > 0) {
            return reference.charAt(0) == '%' && reference.charAt(reference.length() - 1) == ';';
        }
        return false;
    }

    public void visit(DTDFile file) {
        List nodes = file.getNodes();
        int i = 0;
        while (i < nodes.size()) {
            DTDNode currentNode = (DTDNode)nodes.get(i);
            if (currentNode instanceof Element) {
                this.visitElement((Element)currentNode);
            } else if (currentNode instanceof AttributeList) {
                this.visitAttributeList((AttributeList)currentNode);
            } else if (currentNode instanceof ParameterEntityReference) {
                this.visitExternalParameterEntityReference((ParameterEntityReference)currentNode);
            }
            ++i;
        }
    }

    public void visitAttribute(Attribute attr) {
    }

    public void visitAttributeList(AttributeList attList) {
    }

    public void visitAttributes(List attributes) {
        int size = attributes.size();
        int i = 0;
        while (i < size) {
            Attribute attr = (Attribute)attributes.get(i);
            this.visitAttribute(attr);
            ++i;
        }
    }

    public void visitContentNode(CMNode content) {
        if (content instanceof CMBasicNode) {
            CMBasicNode basicNode = (CMBasicNode)content;
            if (basicNode.isReference()) {
                this.visitReference(basicNode);
            }
        } else if (content instanceof CMGroupNode) {
            this.visitGroupNode((CMGroupNode)content);
        }
    }

    public void visitElement(Element element) {
        CMNode content = element.getContentModel();
        this.visitContentNode(content);
        this.visitAttributes(element.getElementAttributes());
    }

    public void visitExternalParameterEntityReference(ParameterEntityReference parmEntityRef) {
    }

    public void visitGroupNode(CMGroupNode group) {
        List children = group.getChildrenList();
        int size = children.size();
        int i = 0;
        while (i < size) {
            this.visitContentNode((CMNode)children.get(i));
            ++i;
        }
    }

    public void visitReference(CMBasicNode node) {
    }
}

