/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.cleanup;

import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatterFactory;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.html.core.internal.cleanup.AbstractNodeCleanupHandler;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Node;

public class CSSTextNodeCleanupHandler
extends AbstractNodeCleanupHandler {
    @Override
    public Node cleanup(Node node) {
        if (node == null) {
            return node;
        }
        IDOMModel model = ((IDOMNode)node).getModel();
        if (model == null) {
            return node;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return node;
        }
        if (!this.getCleanupPreferences().getFormatSource()) {
            return node;
        }
        String content = this.getCSSContent(node);
        if (content == null) {
            return node;
        }
        int offset = ((IDOMNode)node).getStartOffset();
        int length = ((IDOMNode)node).getEndOffset() - offset;
        CSSTextNodeCleanupHandler.replaceSource(model, this, offset, length, content);
        return (IDOMNode)model.getIndexedRegion(offset);
    }

    private String getCSSContent(Node text) {
        ICSSModel model = this.getCSSModel(text);
        if (model == null) {
            return null;
        }
        ICSSDocument document = model.getDocument();
        if (document == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)((Object)document);
        CSSSourceFormatter formatter = (CSSSourceFormatter)((Object)notifier.getAdapterFor(CSSSourceFormatter.class));
        if (formatter == null) {
            formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter(notifier);
        }
        if (formatter == null) {
            return null;
        }
        StringBuffer buffer = formatter.cleanup(document);
        if (buffer == null) {
            return null;
        }
        return buffer.toString();
    }

    private ICSSModel getCSSModel(Node text) {
        if (text == null) {
            return null;
        }
        INodeNotifier notifier = (INodeNotifier)((Object)text.getParentNode());
        if (notifier == null) {
            return null;
        }
        INodeAdapter adapter = notifier.getAdapterFor(IStyleSheetAdapter.class);
        if (adapter == null) {
            return null;
        }
        if (!(adapter instanceof IStyleSheetAdapter)) {
            return null;
        }
        IStyleSheetAdapter styleAdapter = (IStyleSheetAdapter)adapter;
        return styleAdapter.getModel();
    }
}

