/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.ImportReferencesCollector;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;

public class ImportRemover {
    private Set fAddedImports = new HashSet();
    private Set fAddedStaticImports = new HashSet();
    private final IJavaScriptProject fProject;
    private List fRemovedNodes = new ArrayList();
    private final JavaScriptUnit fRoot;

    public ImportRemover(IJavaScriptProject project, JavaScriptUnit root) {
        this.fProject = project;
        this.fRoot = root;
    }

    private void divideTypeRefs(List importNames, List staticNames, List removedRefs, List unremovedRefs) {
        int[] removedStartsEnds = new int[2 * this.fRemovedNodes.size()];
        int index = 0;
        while (index < this.fRemovedNodes.size()) {
            int start;
            ASTNode node = (ASTNode)this.fRemovedNodes.get(index);
            removedStartsEnds[2 * index] = start = node.getStartPosition();
            removedStartsEnds[2 * index + 1] = start + node.getLength();
            ++index;
        }
        for (SimpleName name : importNames) {
            if (this.isInRemoved(name, removedStartsEnds)) {
                removedRefs.add(name);
                continue;
            }
            unremovedRefs.add(name);
        }
        for (SimpleName name : staticNames) {
            if (this.isInRemoved(name, removedStartsEnds)) {
                removedRefs.add(name);
                continue;
            }
            unremovedRefs.add(name);
        }
    }

    public IBinding[] getImportsToRemove() {
        ArrayList importNames = new ArrayList();
        ArrayList staticNames = new ArrayList();
        this.fRoot.accept(new ImportReferencesCollector(this.fProject, null, importNames, staticNames));
        ArrayList removedRefs = new ArrayList();
        ArrayList unremovedRefs = new ArrayList();
        this.divideTypeRefs(importNames, staticNames, removedRefs, unremovedRefs);
        if (removedRefs.size() == 0) {
            return new IBinding[0];
        }
        HashMap potentialRemoves = this.getPotentialRemoves(removedRefs);
        for (SimpleName name : unremovedRefs) {
            potentialRemoves.remove(name.getIdentifier());
        }
        Collection importsToRemove = potentialRemoves.values();
        return importsToRemove.toArray(new IBinding[importsToRemove.size()]);
    }

    private HashMap getPotentialRemoves(List removedRefs) {
        HashMap<String, IBinding> potentialRemoves = new HashMap<String, IBinding>();
        for (SimpleName name : removedRefs) {
            IBinding binding;
            if (this.fAddedImports.contains(name.getIdentifier()) || this.hasAddedStaticImport(name) || (binding = name.resolveBinding()) == null) continue;
            potentialRemoves.put(name.getIdentifier(), binding);
        }
        return potentialRemoves;
    }

    private boolean hasAddedStaticImport(SimpleName name) {
        IBinding binding = name.resolveBinding();
        if (binding instanceof IVariableBinding) {
            IVariableBinding variable = (IVariableBinding)binding;
            return this.hasAddedStaticImport(variable.getDeclaringClass().getQualifiedName(), variable.getName(), true);
        }
        if (binding instanceof IFunctionBinding) {
            IFunctionBinding method = (IFunctionBinding)binding;
            return this.hasAddedStaticImport(method.getDeclaringClass().getQualifiedName(), method.getName(), false);
        }
        return false;
    }

    private boolean hasAddedStaticImport(String qualifier, String member, boolean field) {
        StaticImportData data2 = null;
        for (StaticImportData data2 : this.fAddedStaticImports) {
            if (!data2.fQualifier.equals(qualifier) || !data2.fMember.equals(member) || data2.fField != field) continue;
            return true;
        }
        return false;
    }

    public boolean hasRemovedNodes() {
        return this.fRemovedNodes.size() != 0;
    }

    private boolean isInRemoved(SimpleName ref, int[] removedStartsEnds) {
        int start = ref.getStartPosition();
        int end = start + ref.getLength();
        int index = 0;
        while (index < removedStartsEnds.length) {
            if (start >= removedStartsEnds[index] && end <= removedStartsEnds[index + 1]) {
                return true;
            }
            index += 2;
        }
        return false;
    }

    public void registerAddedImport(String typeName) {
        int dot = typeName.lastIndexOf(46);
        if (dot == -1) {
            this.fAddedImports.add(typeName);
        } else {
            this.fAddedImports.add(typeName.substring(dot + 1));
        }
    }

    public void registerAddedImports(Type newTypeNode) {
        newTypeNode.accept(new ASTVisitor(true){

            private void addName(SimpleName name) {
                ImportRemover.this.fAddedImports.add(name.getIdentifier());
            }

            @Override
            public boolean visit(QualifiedName node) {
                this.addName(node.getName());
                return false;
            }

            @Override
            public boolean visit(QualifiedType node) {
                this.addName(node.getName());
                return false;
            }

            @Override
            public boolean visit(SimpleName node) {
                this.addName(node);
                return false;
            }
        });
    }

    public void registerAddedStaticImport(String qualifier, String member, boolean field) {
        this.fAddedStaticImports.add(new StaticImportData(qualifier, member, field));
    }

    public void registerAddedStaticImport(IBinding binding) {
        if (binding instanceof IVariableBinding) {
            ITypeBinding declaringType = ((IVariableBinding)binding).getDeclaringClass();
            this.fAddedStaticImports.add(new StaticImportData(Bindings.getRawQualifiedName(declaringType), binding.getName(), true));
        } else if (binding instanceof IFunctionBinding) {
            ITypeBinding declaringType = ((IFunctionBinding)binding).getDeclaringClass();
            this.fAddedStaticImports.add(new StaticImportData(Bindings.getRawQualifiedName(declaringType), binding.getName(), false));
        } else {
            throw new IllegalArgumentException(binding.toString());
        }
    }

    public void registerRemovedNode(ASTNode removed) {
        this.fRemovedNodes.add(removed);
    }

    public void applyRemoves(ImportRewrite importRewrite) {
        IBinding[] bindings = this.getImportsToRemove();
        int i = 0;
        while (i < bindings.length) {
            IBinding binding;
            if (bindings[i] instanceof ITypeBinding) {
                ITypeBinding typeBinding = (ITypeBinding)bindings[i];
                importRewrite.removeImport(typeBinding.getTypeDeclaration().getQualifiedName());
            } else if (bindings[i] instanceof IFunctionBinding) {
                binding = (IFunctionBinding)bindings[i];
                importRewrite.removeStaticImport(String.valueOf(binding.getDeclaringClass().getQualifiedName()) + '.' + binding.getName());
            } else if (bindings[i] instanceof IVariableBinding) {
                binding = (IVariableBinding)bindings[i];
                importRewrite.removeStaticImport(String.valueOf(binding.getDeclaringClass().getQualifiedName()) + '.' + binding.getName());
            }
            ++i;
        }
    }

    private static class StaticImportData {
        private boolean fField;
        private String fMember;
        private String fQualifier;

        private StaticImportData(String qualifier, String member, boolean field) {
            this.fQualifier = qualifier;
            this.fMember = member;
            this.fField = field;
        }
    }
}

