/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.util;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.search.SearchEngine;
import org.eclipse.wst.jsdt.core.search.TypeNameMatch;
import org.eclipse.wst.jsdt.internal.corext.CorextMessages;
import org.eclipse.wst.jsdt.internal.corext.util.History;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.TypeFilter;
import org.eclipse.wst.jsdt.internal.corext.util.TypeInfoFilter;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.w3c.dom.Element;

public class OpenTypeHistory
extends History {
    private volatile boolean fNeedsConsistencyCheck = true;
    private Map fTimestampMapping = new HashMap();
    private final IElementChangedListener fDeltaListener;
    private final UpdateJob fUpdateJob;
    private static final String FILENAME = "OpenTypeHistory.xml";
    private static final String NODE_ROOT = "typeInfoHistroy";
    private static final String NODE_TYPE_INFO = "typeInfo";
    private static final String NODE_HANDLE = "handle";
    private static final String NODE_MODIFIERS = "modifiers";
    private static final String NODE_TIMESTAMP = "timestamp";
    private static OpenTypeHistory fgInstance;

    public static synchronized OpenTypeHistory getInstance() {
        if (fgInstance == null) {
            fgInstance = new OpenTypeHistory();
        }
        return fgInstance;
    }

    public static synchronized void shutdown() {
        if (fgInstance == null) {
            return;
        }
        fgInstance.doShutdown();
    }

    private OpenTypeHistory() {
        super(FILENAME, NODE_ROOT, NODE_TYPE_INFO);
        this.load();
        this.fDeltaListener = new TypeHistoryDeltaListener();
        JavaScriptCore.addElementChangedListener(this.fDeltaListener);
        this.fUpdateJob = new UpdateJob();
        this.fUpdateJob.setPriority(20);
    }

    public void markAsInconsistent() {
        this.fNeedsConsistencyCheck = true;
        this.fUpdateJob.cancel();
        this.fUpdateJob.schedule();
    }

    public boolean needConsistencyCheck() {
        return this.fNeedsConsistencyCheck;
    }

    public void checkConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        if (!this.fNeedsConsistencyCheck) {
            return;
        }
        if (this.fUpdateJob.getState() == 4) {
            try {
                Job.getJobManager().join((Object)UpdateJob.FAMILY, monitor);
            }
            catch (OperationCanceledException operationCanceledException) {
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!this.fNeedsConsistencyCheck) {
            return;
        }
        this.internalCheckConsistency(monitor);
    }

    public synchronized boolean contains(TypeNameMatch type) {
        return super.contains(type);
    }

    public synchronized void accessed(TypeNameMatch info) {
        if (!this.fTimestampMapping.containsKey(info)) {
            this.fTimestampMapping.put(info, this.getContainerTimestamp(info));
        }
        super.accessed(info);
    }

    public synchronized TypeNameMatch remove(TypeNameMatch info) {
        this.fTimestampMapping.remove(info);
        return (TypeNameMatch)super.remove(info);
    }

    public synchronized void replace(TypeNameMatch old, TypeNameMatch newMatch) {
        this.fTimestampMapping.remove(old);
        this.fTimestampMapping.put(newMatch, this.getContainerTimestamp(newMatch));
        super.remove(old);
        super.accessed(newMatch);
    }

    public synchronized TypeNameMatch[] getTypeInfos() {
        Collection values = this.getValues();
        int size = values.size();
        TypeNameMatch[] result = new TypeNameMatch[size];
        int i = size - 1;
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            result[i] = (TypeNameMatch)iter.next();
            --i;
        }
        return result;
    }

    public synchronized TypeNameMatch[] getFilteredTypeInfos(TypeInfoFilter filter) {
        Collection values = this.getValues();
        ArrayList<TypeNameMatch> result = new ArrayList<TypeNameMatch>();
        for (TypeNameMatch type : values) {
            if (filter != null && !filter.matchesHistoryElement(type) || TypeFilter.isFiltered(type.getFullyQualifiedName())) continue;
            result.add(type);
        }
        Collections.reverse(result);
        return result.toArray(new TypeNameMatch[result.size()]);
    }

    @Override
    protected Object getKey(Object object) {
        return object;
    }

    private synchronized void internalCheckConsistency(IProgressMonitor monitor) throws OperationCanceledException {
        this.fNeedsConsistencyCheck = true;
        ArrayList typesToCheck = new ArrayList(this.getKeys());
        monitor.beginTask(CorextMessages.TypeInfoHistory_consistency_check, typesToCheck.size());
        monitor.setTaskName(CorextMessages.TypeInfoHistory_consistency_check);
        for (TypeNameMatch type : typesToCheck) {
            long currentTimestamp = this.getContainerTimestamp(type);
            Long lastTested = (Long)this.fTimestampMapping.get(type);
            if (lastTested != null && currentTimestamp != -1L && currentTimestamp == lastTested && !this.isContainerDirty(type)) continue;
            try {
                IType jType = type.getType();
                if (jType == null || !jType.exists()) {
                    this.remove(type);
                } else {
                    int modifiers = jType.getFlags();
                    if (modifiers != type.getModifiers()) {
                        this.replace(type, SearchEngine.createTypeNameMatch(jType, modifiers));
                    } else {
                        this.fTimestampMapping.put(type, currentTimestamp);
                    }
                }
            }
            catch (JavaScriptModelException javaScriptModelException) {
                this.remove(type);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            monitor.worked(1);
        }
        monitor.done();
        this.fNeedsConsistencyCheck = false;
    }

    private long getContainerTimestamp(TypeNameMatch match) {
        try {
            IType type = match.getType();
            IResource resource = type.getResource();
            if (resource != null) {
                IJavaScriptElement element;
                IFileInfo info;
                URI location = resource.getLocationURI();
                if (location != null && (info = EFS.getStore((URI)location).fetchInfo()).exists() && (element = JavaScriptCore.create(resource)) != null && element.exists()) {
                    return info.getLastModified();
                }
            } else {
                IFileInfo info;
                IPackageFragmentRoot root = match.getPackageFragmentRoot();
                if (root.exists() && (info = EFS.getLocalFileSystem().getStore(root.getPath()).fetchInfo()).exists()) {
                    return info.getLastModified();
                }
            }
        }
        catch (CoreException coreException) {}
        return -1L;
    }

    public boolean isContainerDirty(TypeNameMatch match) {
        IJavaScriptUnit cu = match.getType().getJavaScriptUnit();
        if (cu == null) {
            return false;
        }
        IResource resource = cu.getResource();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        ITextFileBuffer textFileBuffer = manager.getTextFileBuffer(resource.getFullPath(), LocationKind.IFILE);
        if (textFileBuffer != null) {
            return textFileBuffer.isDirty();
        }
        return false;
    }

    private void doShutdown() {
        JavaScriptCore.removeElementChangedListener(this.fDeltaListener);
        this.save();
    }

    @Override
    protected Object createFromElement(Element type) {
        String handle = type.getAttribute(NODE_HANDLE);
        if (handle == null) {
            return null;
        }
        IJavaScriptElement element = JavaScriptCore.create(handle);
        if (!(element instanceof IType)) {
            return null;
        }
        int modifiers = 0;
        try {
            modifiers = Integer.parseInt(type.getAttribute(NODE_MODIFIERS));
        }
        catch (NumberFormatException numberFormatException) {}
        TypeNameMatch info = SearchEngine.createTypeNameMatch((IType)element, modifiers);
        long timestamp = -1L;
        String timestampValue = type.getAttribute(NODE_TIMESTAMP);
        if (timestampValue != null && timestampValue.length() > 0) {
            try {
                timestamp = Long.parseLong(timestampValue);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if (timestamp != -1L) {
            this.fTimestampMapping.put(info, timestamp);
        }
        return info;
    }

    @Override
    protected void setAttributes(Object object, Element typeElement) {
        TypeNameMatch type = (TypeNameMatch)object;
        String handleId = type.getType().getHandleIdentifier();
        typeElement.setAttribute(NODE_HANDLE, handleId);
        typeElement.setAttribute(NODE_MODIFIERS, Integer.toString(type.getModifiers()));
        Long timestamp = (Long)this.fTimestampMapping.get(type);
        if (timestamp == null) {
            typeElement.setAttribute(NODE_TIMESTAMP, Long.toString(-1L));
        } else {
            typeElement.setAttribute(NODE_TIMESTAMP, timestamp.toString());
        }
    }

    private static class TypeHistoryDeltaListener
    implements IElementChangedListener {
        private TypeHistoryDeltaListener() {
        }

        @Override
        public void elementChanged(ElementChangedEvent event) {
            if (this.processDelta(event.getDelta())) {
                OpenTypeHistory.getInstance().markAsInconsistent();
            }
        }

        private boolean processDelta(IJavaScriptElementDelta delta) {
            IJavaScriptElement elem = delta.getElement();
            boolean isChanged = delta.getKind() == 4;
            boolean isRemoved = delta.getKind() == 2;
            switch (elem.getElementType()) {
                case 2: {
                    if (isRemoved || isChanged && (delta.getFlags() & 0x400) != 0) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 3: {
                    if (isRemoved || isChanged && ((delta.getFlags() & 0x8000) != 0 || (delta.getFlags() & 0x80) != 0)) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 7: {
                    if (isChanged && (delta.getFlags() & 2) != 0) {
                        return true;
                    }
                }
                case 1: 
                case 4: 
                case 6: {
                    if (isRemoved) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
                case 5: {
                    if (!JavaModelUtil.isPrimary((IJavaScriptUnit)elem)) {
                        return false;
                    }
                    if (isRemoved || isChanged && this.isUnknownStructuralChange(delta.getFlags())) {
                        return true;
                    }
                    return this.processChildrenDelta(delta);
                }
            }
            return false;
        }

        private boolean isUnknownStructuralChange(int flags) {
            if ((flags & 1) == 0) {
                return false;
            }
            return (flags & 0x4000) == 0;
        }

        private boolean processChildrenDelta(IJavaScriptElementDelta delta) {
            IJavaScriptElementDelta[] children = delta.getAffectedChildren();
            int i = 0;
            while (i < children.length) {
                if (this.processDelta(children[i])) {
                    return true;
                }
                ++i;
            }
            return false;
        }
    }

    private static class UpdateJob
    extends Job {
        public static final String FAMILY = UpdateJob.class.getName();

        public UpdateJob() {
            super(CorextMessages.TypeInfoHistory_consistency_check);
        }

        protected IStatus run(IProgressMonitor monitor) {
            OpenTypeHistory history = OpenTypeHistory.getInstance();
            history.internalCheckConsistency(monitor);
            return new Status(0, JavaScriptPlugin.getPluginId(), 0, "", null);
        }

        public boolean belongsTo(Object family) {
            return FAMILY.equals(family);
        }
    }
}

