/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ClassFileDocumentProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ExternalClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.SemanticHighlightingReconciler;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.PixelConverter;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.SourceAttachmentBlock;
import org.eclipse.wst.jsdt.ui.actions.RefactorActionGroup;

public class ClassFileEditor
extends JavaEditor
implements ClassFileDocumentProvider.InputChangeListener {
    private StackLayout fStackLayout;
    private Composite fParent;
    private Composite fViewerComposite;
    private Control fSourceAttachmentForm;
    private CompositeActionGroup fContextMenuGroup;
    private InputUpdater fInputUpdater = new InputUpdater();
    private IAction fSourceCopyAction;
    private IAction fSelectAllAction;
    private StyledText fNoSourceTextWidget;

    public ClassFileEditor() {
        this.setDocumentProvider((IDocumentProvider)JavaScriptPlugin.getDefault().getClassFileDocumentProvider());
        this.setEditorContextMenuId("#ClassFileEditorContext");
        this.setRulerContextMenuId("#ReadOnlyJavaScriptRulerContext");
        this.setOutlinerContextMenuId("#ClassFileOutlinerContext");
    }

    @Override
    protected void createActions() {
        super.createActions();
        this.setAction(ITextEditorActionConstants.SAVE, null);
        this.setAction(ITextEditorActionConstants.REVERT_TO_SAVED, null);
        this.fSourceCopyAction = this.getAction(ITextEditorActionConstants.COPY);
        this.fSelectAllAction = this.getAction(ITextEditorActionConstants.SELECT_ALL);
        RefactorActionGroup group = new RefactorActionGroup(this, "group.edit", true);
        this.fActionGroups.addGroup(group);
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{group});
    }

    @Override
    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fContextMenuGroup.setContext(context);
        this.fContextMenuGroup.fillContextMenu(menu);
        this.fContextMenuGroup.setContext(null);
    }

    @Override
    protected IJavaScriptElement getElementAt(int offset) {
        if (this.getEditorInput() instanceof IClassFileEditorInput) {
            try {
                IClassFileEditorInput input = (IClassFileEditorInput)this.getEditorInput();
                return input.getClassFile().getElementAt(offset);
            }
            catch (JavaScriptModelException javaScriptModelException) {}
        }
        return null;
    }

    @Override
    protected IJavaScriptElement getCorrespondingElement(IJavaScriptElement element) {
        if (this.getEditorInput() instanceof IClassFileEditorInput) {
            IClassFileEditorInput input = (IClassFileEditorInput)this.getEditorInput();
            IJavaScriptElement parent = element.getAncestor(6);
            if (input.getClassFile().equals(parent)) {
                return element;
            }
        }
        return null;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isEditorInputReadOnly() {
        return true;
    }

    protected IEditorInput transformEditorInput(IEditorInput input) {
        IFile file;
        ExternalClassFileEditorInput classFileInput;
        if (input instanceof IFileEditorInput && (classFileInput = new ExternalClassFileEditorInput(file = ((IFileEditorInput)input).getFile())).getClassFile() != null) {
            input = classFileInput;
        }
        return input;
    }

    @Override
    protected void doSetInput(IEditorInput input) throws CoreException {
        this.uninstallOccurrencesFinder();
        input = this.transformEditorInput(input);
        if (!(input instanceof IClassFileEditorInput)) {
            throw new CoreException(JavaUIStatus.createError(996, JavaEditorMessages.ClassFileEditor_error_invalid_input_message, null));
        }
        JavaScriptModelException e = this.probeInputForSource(input);
        if (e != null) {
            IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)input;
            IClassFile file = classFileEditorInput.getClassFile();
            IJavaScriptProject javaProject = file.getJavaScriptProject();
            if (!javaProject.exists() || !javaProject.isOnIncludepath(file)) {
                throw new CoreException(JavaUIStatus.createError(995, JavaEditorMessages.ClassFileEditor_error_classfile_not_on_classpath, null));
            }
            throw e;
        }
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ClassFileDocumentProvider) {
            ((ClassFileDocumentProvider)documentProvider).removeInputChangeListener(this);
        }
        super.doSetInput(input);
        documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ClassFileDocumentProvider) {
            ((ClassFileDocumentProvider)documentProvider).addInputChangeListener(this);
        }
        this.verifyInput(this.getEditorInput());
        final IJavaScriptElement inputElement = this.getInputJavaElement();
        Job job = new Job(JavaEditorMessages.OverrideIndicatorManager_intallJob){

            protected IStatus run(IProgressMonitor monitor) {
                SemanticHighlightingReconciler reconciler;
                JavaScriptUnit ast = JavaScriptPlugin.getDefault().getASTProvider().getAST(inputElement, ASTProvider.WAIT_YES, null);
                if (ClassFileEditor.this.fOverrideIndicatorManager != null) {
                    ClassFileEditor.this.fOverrideIndicatorManager.reconciled(ast, true, monitor);
                }
                if (ClassFileEditor.this.fSemanticManager != null && (reconciler = ClassFileEditor.this.fSemanticManager.getReconciler()) != null) {
                    reconciler.reconciled(ast, false, monitor);
                }
                if (ClassFileEditor.this.isMarkingOccurrences()) {
                    ClassFileEditor.this.installOccurrencesFinder(false);
                }
                return Status.OK_STATUS;
            }
        };
        job.setPriority(50);
        job.setSystem(true);
        job.schedule();
    }

    @Override
    public void createPartControl(Composite parent) {
        this.fParent = new Composite(parent, 0);
        this.fStackLayout = new StackLayout();
        this.fParent.setLayout((Layout)this.fStackLayout);
        this.fViewerComposite = new Composite(this.fParent, 0);
        this.fViewerComposite.setLayout((Layout)new FillLayout());
        super.createPartControl(this.fViewerComposite);
        this.fStackLayout.topControl = this.fViewerComposite;
        this.fParent.layout();
        try {
            this.verifyInput(this.getEditorInput());
        }
        catch (CoreException e) {
            String title = JavaEditorMessages.ClassFileEditor_error_title;
            String message = JavaEditorMessages.ClassFileEditor_error_message;
            ExceptionHandler.handle(e, this.fParent.getShell(), title, message);
        }
    }

    private JavaScriptModelException probeInputForSource(IEditorInput input) {
        if (input == null) {
            return null;
        }
        IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)input;
        IClassFile file = classFileEditorInput.getClassFile();
        try {
            file.getSourceRange();
        }
        catch (JavaScriptModelException e) {
            return e;
        }
        return null;
    }

    private void verifyInput(IEditorInput input) throws JavaScriptModelException {
        IAction currentCopyAction;
        boolean isUsingSourceCopyAction;
        boolean wasUsingSourceCopyAction;
        if (this.fParent == null || input == null) {
            return;
        }
        IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)input;
        IClassFile file = classFileEditorInput.getClassFile();
        IAction copyQualifiedName = this.getAction("copyQualifiedName");
        boolean bl = wasUsingSourceCopyAction = this.fSourceCopyAction == this.getAction(ITextEditorActionConstants.COPY);
        if (file.getSourceRange() == null) {
            if (this.fSourceAttachmentForm != null) {
                this.fSourceAttachmentForm.dispose();
            }
            SourceAttachmentForm form = new SourceAttachmentForm(file);
            this.fStackLayout.topControl = this.fSourceAttachmentForm = form.createControl(this.fParent);
            this.fParent.layout();
            if (this.fNoSourceTextWidget != null) {
                Action copyAction = new Action(){

                    public void run() {
                        ClassFileEditor.this.fNoSourceTextWidget.copy();
                    }
                };
                copyAction.setActionDefinitionId("org.eclipse.ui.edit.copy");
                this.setAction(ITextEditorActionConstants.COPY, (IAction)copyAction);
                copyAction.setEnabled(this.fNoSourceTextWidget.getSelectionText().length() > 0);
                this.fNoSourceTextWidget.addSelectionListener(new SelectionListener((IAction)copyAction){
                    private final /* synthetic */ IAction val$copyAction;
                    {
                        this.val$copyAction = iAction;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.val$copyAction.setEnabled(ClassFileEditor.this.fNoSourceTextWidget.getSelectionText().length() > 0);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                });
                Action selectAllAction = new Action((IAction)copyAction){
                    private final /* synthetic */ IAction val$copyAction;
                    {
                        this.val$copyAction = iAction;
                    }

                    public void run() {
                        ClassFileEditor.this.fNoSourceTextWidget.selectAll();
                        this.val$copyAction.setEnabled(true);
                    }
                };
                selectAllAction.setActionDefinitionId("org.eclipse.ui.edit.selectAll");
                this.setAction(ITextEditorActionConstants.SELECT_ALL, (IAction)selectAllAction);
                copyAction.setEnabled(this.fNoSourceTextWidget.getSelectionText().length() > 0);
                copyQualifiedName.setEnabled(false);
            }
        } else {
            if (this.fSourceAttachmentForm != null) {
                this.fSourceAttachmentForm.dispose();
                this.fSourceAttachmentForm = null;
                this.fStackLayout.topControl = this.fViewerComposite;
                this.fParent.layout();
            }
            this.setAction(ITextEditorActionConstants.COPY, this.fSourceCopyAction);
            this.setAction(ITextEditorActionConstants.SELECT_ALL, this.fSelectAllAction);
            copyQualifiedName.setEnabled(true);
        }
        boolean bl2 = isUsingSourceCopyAction = this.fSourceCopyAction == (currentCopyAction = this.getAction(ITextEditorActionConstants.COPY));
        if (wasUsingSourceCopyAction != isUsingSourceCopyAction) {
            IActionBars actionBars = this.getEditorSite().getActionBars();
            if (isUsingSourceCopyAction) {
                this.createNavigationActions();
            } else {
                int i = 0;
                while (i < ACTION_MAP.length) {
                    AbstractTextEditor.IdMapEntry entry = ACTION_MAP[i];
                    actionBars.setGlobalActionHandler(entry.getActionId(), null);
                    this.setAction(entry.getActionId(), null);
                    ++i;
                }
            }
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.COPY, currentCopyAction);
            actionBars.setGlobalActionHandler(ITextEditorActionConstants.SELECT_ALL, this.getAction(ITextEditorActionConstants.SELECT_ALL));
            actionBars.updateActionBars();
        }
    }

    @Override
    public void inputChanged(IClassFileEditorInput input) {
        this.fInputUpdater.post(input);
    }

    protected ISourceViewer createJavaSourceViewer(Composite parent, IVerticalRuler ruler, int styles, IPreferenceStore store) {
        return new JavaSourceViewer(parent, ruler, null, false, styles, store){

            public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
                if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                    return false;
                }
                return super.requestWidgetToken(requester);
            }

            public boolean requestWidgetToken(IWidgetTokenKeeper requester, int priority) {
                if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                    return false;
                }
                return super.requestWidgetToken(requester, priority);
            }
        };
    }

    @Override
    public void dispose() {
        IDocumentProvider documentProvider = this.getDocumentProvider();
        if (documentProvider instanceof ClassFileDocumentProvider) {
            ((ClassFileDocumentProvider)documentProvider).removeInputChangeListener(this);
        }
        super.dispose();
    }

    public void setFocus() {
        super.setFocus();
        if (this.fSourceAttachmentForm != null && !this.fSourceAttachmentForm.isDisposed()) {
            this.fSourceAttachmentForm.setFocus();
        }
    }

    private class InputUpdater
    implements Runnable {
        private boolean fPosted = false;
        private IClassFileEditorInput fClassFileEditorInput;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            IClassFileEditorInput input;
            InputUpdater inputUpdater = this;
            synchronized (inputUpdater) {
                input = this.fClassFileEditorInput;
            }
            try {
                if (ClassFileEditor.this.getSourceViewer() != null) {
                    ClassFileEditor.this.setInput(input);
                }
            }
            catch (Throwable throwable) {
                InputUpdater inputUpdater2 = this;
                synchronized (inputUpdater2) {
                    this.fPosted = false;
                }
                throw throwable;
            }
            InputUpdater inputUpdater3 = this;
            synchronized (inputUpdater3) {
                this.fPosted = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void post(IClassFileEditorInput input) {
            StyledText textWidget;
            ISourceViewer viewer;
            InputUpdater inputUpdater = this;
            synchronized (inputUpdater) {
                if (this.fPosted) {
                    if (input != null && input.equals(this.fClassFileEditorInput)) {
                        this.fClassFileEditorInput = input;
                    }
                    return;
                }
            }
            if (input != null && input.equals(ClassFileEditor.this.getEditorInput()) && (viewer = ClassFileEditor.this.getSourceViewer()) != null && (textWidget = viewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                InputUpdater inputUpdater2 = this;
                synchronized (inputUpdater2) {
                    this.fPosted = true;
                    this.fClassFileEditorInput = input;
                }
                textWidget.getDisplay().asyncExec((Runnable)this);
            }
        }
    }

    private class SourceAttachmentForm
    implements IPropertyChangeListener {
        private final IClassFile fFile;
        private Composite fComposite;
        private Color fBackgroundColor;
        private Color fForegroundColor;
        private Color fSeparatorColor;
        private List fBannerLabels = new ArrayList();
        private List fHeaderLabels = new ArrayList();
        private Font fFont;

        public SourceAttachmentForm(IClassFile file) {
            this.fFile = file;
        }

        private IPackageFragmentRoot getPackageFragmentRoot(IClassFile file) {
            IJavaScriptElement element = file.getParent();
            while (element != null && element.getElementType() != 3) {
                element = element.getParent();
            }
            return (IPackageFragmentRoot)element;
        }

        public Control createControl(Composite parent) {
            Display display = parent.getDisplay();
            this.fBackgroundColor = display.getSystemColor(25);
            this.fForegroundColor = display.getSystemColor(24);
            this.fSeparatorColor = new Color((Device)display, 152, 170, 203);
            JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
            this.fComposite = this.createComposite(parent);
            this.fComposite.setLayout((Layout)new GridLayout());
            this.fComposite.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)SourceAttachmentForm.this);
                    SourceAttachmentForm.this.fComposite = null;
                    SourceAttachmentForm.this.fSeparatorColor.dispose();
                    SourceAttachmentForm.this.fSeparatorColor = null;
                    SourceAttachmentForm.this.fBannerLabels.clear();
                    SourceAttachmentForm.this.fHeaderLabels.clear();
                    if (SourceAttachmentForm.this.fFont != null) {
                        SourceAttachmentForm.this.fFont.dispose();
                        SourceAttachmentForm.this.fFont = null;
                    }
                }
            });
            this.createTitleLabel(this.fComposite, JavaEditorMessages.SourceAttachmentForm_title);
            this.createLabel(this.fComposite, null);
            this.createLabel(this.fComposite, null);
            this.createHeadingLabel(this.fComposite, JavaEditorMessages.SourceAttachmentForm_heading);
            Composite separator = this.createCompositeSeparator(this.fComposite);
            GridData data = new GridData(768);
            data.heightHint = 2;
            separator.setLayoutData((Object)data);
            separator = this.createCompositeSeparator(this.fComposite);
            data = new GridData(768);
            data.heightHint = 2;
            separator.setLayoutData((Object)data);
            ClassFileEditor.this.fNoSourceTextWidget = this.createCodeView(this.fComposite);
            data = new GridData(1808);
            ClassFileEditor.this.fNoSourceTextWidget.setLayoutData((Object)data);
            return this.fComposite;
        }

        protected void applySourceAttachment(Shell shell, IIncludePathEntry newEntry, IJavaScriptProject project, IPath containerPath) {
            try {
                IRunnableWithProgress runnable = SourceAttachmentBlock.getRunnable(shell, newEntry, project, containerPath);
                PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                String title = JavaEditorMessages.SourceAttachmentForm_attach_error_title;
                String message = JavaEditorMessages.SourceAttachmentForm_attach_error_message;
                ExceptionHandler.handle(e, shell, title, message);
            }
            catch (InterruptedException interruptedException) {}
        }

        public void propertyChange(PropertyChangeEvent event) {
            for (Label label : this.fBannerLabels) {
                label.setFont(JFaceResources.getBannerFont());
            }
            for (Label label : this.fHeaderLabels) {
                label.setFont(JFaceResources.getHeaderFont());
            }
            this.fComposite.layout(true);
            this.fComposite.redraw();
        }

        private Composite createComposite(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(this.fBackgroundColor);
            return composite;
        }

        private Composite createCompositeSeparator(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setBackground(this.fSeparatorColor);
            return composite;
        }

        private StyledText createCodeView(Composite parent) {
            int styles = 66306;
            StyledText styledText = new StyledText(parent, styles);
            styledText.setBackground(this.fBackgroundColor);
            styledText.setForeground(this.fForegroundColor);
            styledText.setEditable(false);
            return styledText;
        }

        private Label createLabel(Composite parent, String text) {
            Label label = new Label(parent, 64);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            GridData gd = new GridData();
            gd.widthHint = new PixelConverter((Control)label).convertWidthInCharsToPixels(80);
            label.setLayoutData((Object)gd);
            return label;
        }

        private Label createTitleLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            label.setFont(JFaceResources.getHeaderFont());
            this.fHeaderLabels.add(label);
            return label;
        }

        private Label createHeadingLabel(Composite parent, String text) {
            Label label = new Label(parent, 0);
            if (text != null) {
                label.setText(text);
            }
            label.setBackground(this.fBackgroundColor);
            label.setForeground(this.fForegroundColor);
            label.setFont(JFaceResources.getBannerFont());
            this.fBannerLabels.add(label);
            return label;
        }

        private Button createButton(Composite parent, String text) {
            Button button = new Button(parent, 0x800000);
            button.setBackground(this.fBackgroundColor);
            button.setForeground(this.fForegroundColor);
            if (text != null) {
                button.setText(text);
            }
            return button;
        }
    }
}

