/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import java.util.HashMap;
import java.util.Stack;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.DocumentCommand;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.ITextViewerExtension7;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.IWidgetTokenKeeper;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TabsToSpacesConverter;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.IOverviewRuler;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.IVerticalRuler;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.texteditor.ContentAssistAction;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.IStatusField;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.TextNavigationAction;
import org.eclipse.ui.texteditor.TextOperationAction;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.actions.AddBlockCommentAction;
import org.eclipse.wst.jsdt.internal.ui.actions.CompositeActionGroup;
import org.eclipse.wst.jsdt.internal.ui.actions.IndentAction;
import org.eclipse.wst.jsdt.internal.ui.actions.RemoveBlockCommentAction;
import org.eclipse.wst.jsdt.internal.ui.actions.SurroundWithActionGroup;
import org.eclipse.wst.jsdt.internal.ui.compare.LocalHistoryActionGroup;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ICompilationUnitDocumentProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ISavePolicy;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorErrorTickUpdater;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaMoveLinesAction;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ToggleCommentAction;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.WorkingCopyManager;
import org.eclipse.wst.jsdt.internal.ui.text.ContentAssistPreference;
import org.eclipse.wst.jsdt.internal.ui.text.JavaHeuristicScanner;
import org.eclipse.wst.jsdt.internal.ui.text.SmartBackspaceManager;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionCommandInstaller;
import org.eclipse.wst.jsdt.internal.ui.text.java.IJavaReconcilingListener;
import org.eclipse.wst.jsdt.ui.actions.GenerateActionGroup;
import org.eclipse.wst.jsdt.ui.actions.RefactorActionGroup;

public class CompilationUnitEditor
extends JavaEditor
implements IJavaReconcilingListener {
    private static final boolean CODE_ASSIST_DEBUG = "true".equalsIgnoreCase(Platform.getDebugOption((String)"org.eclipse.wst.jsdt.ui/debug/ResultCollector"));
    public static final int CONTENTASSIST_COMPLETE_PREFIX = 60;
    private static final String CODE_FORMATTER_TAB_SIZE = "org.eclipse.wst.jsdt.core.formatter.tabulation.size";
    private static final String SPACES_FOR_TABS = "org.eclipse.wst.jsdt.core.formatter.tabulation.char";
    private static final String CLOSE_STRINGS = "closeStrings";
    private static final String CLOSE_BRACKETS = "closeBrackets";
    protected ISavePolicy fSavePolicy;
    private JavaEditorErrorTickUpdater fJavaEditorErrorTickUpdater;
    private RememberedSelection fRememberedSelection = new RememberedSelection();
    private BracketInserter fBracketInserter = new BracketInserter();
    private GenerateActionGroup fGenerateActionGroup;
    private CompositeActionGroup fContextMenuGroup;
    private CorrectionCommandInstaller fCorrectionCommands;
    private ListenerList fReconcilingListeners = new ListenerList(1);
    private final Object fReconcilerLock = new Object();

    public CompilationUnitEditor() {
        this.setDocumentProvider(JavaScriptPlugin.getDefault().getCompilationUnitDocumentProvider());
        this.setEditorContextMenuId("#JavaScriptEditorContext");
        this.setRulerContextMenuId("#JavaScriptRulerContext");
        this.setOutlinerContextMenuId("#JavaScriptOutlinerContext");
        this.fSavePolicy = null;
        this.fJavaEditorErrorTickUpdater = new JavaEditorErrorTickUpdater(this);
        this.fCorrectionCommands = null;
    }

    @Override
    protected void createActions() {
        super.createActions();
        Object action = new ContentAssistAction(JavaEditorMessages.getBundleForConstructedKeys(), "ContentAssistProposal.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        this.setAction("ContentAssistProposal", (IAction)action);
        this.markAsStateDependentAction("ContentAssistProposal", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.wst.jsdt.ui.content_assist_action");
        action = new TextOperationAction(JavaEditorMessages.getBundleForConstructedKeys(), "ContentAssistContextInformation.", (ITextEditor)this, 14);
        action.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.contextInformation");
        this.setAction("ContentAssistContextInformation", (IAction)action);
        this.markAsStateDependentAction("ContentAssistContextInformation", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.wst.jsdt.ui.parameter_hints_action");
        action = new TextOperationAction(JavaEditorMessages.getBundleForConstructedKeys(), "Comment.", (ITextEditor)this, 11);
        action.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.comment");
        this.setAction("Comment", (IAction)action);
        this.markAsStateDependentAction("Comment", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.wst.jsdt.ui.comment_action");
        action = new TextOperationAction(JavaEditorMessages.getBundleForConstructedKeys(), "Uncomment.", (ITextEditor)this, 12);
        action.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.uncomment");
        this.setAction("Uncomment", (IAction)action);
        this.markAsStateDependentAction("Uncomment", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.wst.jsdt.ui.uncomment_action");
        action = new ToggleCommentAction(JavaEditorMessages.getBundleForConstructedKeys(), "ToggleComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.toggle.comment");
        this.setAction("ToggleComment", (IAction)action);
        this.markAsStateDependentAction("ToggleComment", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.wst.jsdt.ui.toggle_comment_action");
        this.configureToggleCommentAction();
        action = new TextOperationAction(JavaEditorMessages.getBundleForConstructedKeys(), "Format.", (ITextEditor)this, 15);
        action.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.format");
        this.setAction("Format", (IAction)action);
        this.markAsStateDependentAction("Format", true);
        this.markAsSelectionDependentAction("Format", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.wst.jsdt.ui.format_action");
        action = new AddBlockCommentAction(JavaEditorMessages.getBundleForConstructedKeys(), "AddBlockComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.add.block.comment");
        this.setAction("AddBlockComment", (IAction)action);
        this.markAsStateDependentAction("AddBlockComment", true);
        this.markAsSelectionDependentAction("AddBlockComment", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.wst.jsdt.ui.add_block_comment_action");
        action = new RemoveBlockCommentAction(JavaEditorMessages.getBundleForConstructedKeys(), "RemoveBlockComment.", (ITextEditor)this);
        action.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.remove.block.comment");
        this.setAction("RemoveBlockComment", (IAction)action);
        this.markAsStateDependentAction("RemoveBlockComment", true);
        this.markAsSelectionDependentAction("RemoveBlockComment", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.wst.jsdt.ui.remove_block_comment_action");
        action = new IndentAction(JavaEditorMessages.getBundleForConstructedKeys(), "Indent.", (ITextEditor)this, false);
        action.setActionDefinitionId("org.eclipse.wst.jsdt.ui.edit.text.java.indent");
        this.setAction("Indent", (IAction)action);
        this.markAsStateDependentAction("Indent", true);
        this.markAsSelectionDependentAction("Indent", true);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)action, "org.eclipse.wst.jsdt.ui.indent_action");
        action = new IndentAction(JavaEditorMessages.getBundleForConstructedKeys(), "Indent.", (ITextEditor)this, true);
        this.setAction("IndentOnTab", (IAction)action);
        this.markAsStateDependentAction("IndentOnTab", true);
        this.markAsSelectionDependentAction("IndentOnTab", true);
        JavaMoveLinesAction[] moveLinesActions = JavaMoveLinesAction.createMoveCopyActionSet(JavaEditorMessages.getBundleForConstructedKeys(), this);
        JavaMoveLinesAction rAction = moveLinesActions[0];
        rAction.setHelpContextId("org.eclipse.ui.move_lines_action_context");
        rAction.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineUp");
        this.setAction("MoveLineUp", (IAction)rAction);
        rAction = moveLinesActions[1];
        rAction.setHelpContextId("org.eclipse.ui.move_lines_action_context");
        rAction.setActionDefinitionId("org.eclipse.ui.edit.text.moveLineDown");
        this.setAction("MoveLineDown", (IAction)rAction);
        rAction = moveLinesActions[2];
        rAction.setHelpContextId("org.eclipse.ui.copy_lines_action_context");
        rAction.setActionDefinitionId("org.eclipse.ui.edit.text.copyLineUp");
        this.setAction("CopyLineUp", (IAction)rAction);
        rAction = moveLinesActions[3];
        rAction.setHelpContextId("org.eclipse.ui.copy_lines_action_context");
        rAction.setActionDefinitionId("org.eclipse.ui.edit.text.copyLineDown");
        this.setAction("CopyLineDown", (IAction)rAction);
        if (this.getPreferenceStore().getBoolean("smart_tab")) {
            this.setActionActivationCode("IndentOnTab", '\t', -1, 0);
        }
        this.fGenerateActionGroup = new GenerateActionGroup(this, "group.edit");
        RefactorActionGroup rg = new RefactorActionGroup(this, "group.edit", false);
        SurroundWithActionGroup surroundWith = new SurroundWithActionGroup(this, "group.edit");
        this.fActionGroups.addGroup(surroundWith);
        this.fActionGroups.addGroup(rg);
        this.fActionGroups.addGroup(this.fGenerateActionGroup);
        this.fContextMenuGroup = new CompositeActionGroup(new ActionGroup[]{this.fGenerateActionGroup, rg, surroundWith, new LocalHistoryActionGroup(this, "group.edit")});
        this.fCorrectionCommands = new CorrectionCommandInstaller();
        this.fCorrectionCommands.registerCommands(this);
    }

    @Override
    protected IJavaScriptElement getElementAt(int offset) {
        return this.getElementAt(offset, true);
    }

    @Override
    protected IJavaScriptElement getElementAt(int offset, boolean reconcile) {
        block5: {
            IJavaScriptUnit unit = (IJavaScriptUnit)this.getInputJavaElement();
            if (unit != null) {
                try {
                    if (reconcile) {
                        JavaModelUtil.reconcile(unit);
                        return unit.getElementAt(offset);
                    }
                    if (unit.isConsistent()) {
                        return unit.getElementAt(offset);
                    }
                }
                catch (JavaScriptModelException x) {
                    if (x.isDoesNotExist()) break block5;
                    JavaScriptPlugin.log(x.getStatus());
                }
            }
        }
        return null;
    }

    @Override
    protected IJavaScriptElement getCorrespondingElement(IJavaScriptElement element) {
        return element;
    }

    @Override
    public void editorContextMenuAboutToShow(IMenuManager menu) {
        super.editorContextMenuAboutToShow(menu);
        ActionContext context = new ActionContext(this.getSelectionProvider().getSelection());
        this.fContextMenuGroup.setContext(context);
        this.fContextMenuGroup.fillContextMenu(menu);
        this.fContextMenuGroup.setContext(null);
    }

    protected void performSave(boolean overwrite, IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p instanceof ICompilationUnitDocumentProvider) {
            ICompilationUnitDocumentProvider cp = (ICompilationUnitDocumentProvider)p;
            cp.setSavePolicy(this.fSavePolicy);
        }
        try {
            super.performSave(overwrite, progressMonitor);
        }
        finally {
            if (p instanceof ICompilationUnitDocumentProvider) {
                ICompilationUnitDocumentProvider cp = (ICompilationUnitDocumentProvider)p;
                cp.setSavePolicy(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(IProgressMonitor progressMonitor) {
        IDocumentProvider p = this.getDocumentProvider();
        if (p == null) {
            return;
        }
        if (p.isDeleted((Object)this.getEditorInput())) {
            if (this.isSaveAsAllowed()) {
                this.performSaveAs(progressMonitor);
            } else {
                Shell shell = this.getSite().getShell();
                MessageDialog.openError((Shell)shell, (String)JavaEditorMessages.CompilationUnitEditor_error_saving_title1, (String)JavaEditorMessages.CompilationUnitEditor_error_saving_message1);
            }
        } else {
            this.setStatusLineErrorMessage(null);
            this.updateState(this.getEditorInput());
            this.validateState(this.getEditorInput());
            WorkingCopyManager manager = JavaScriptPlugin.getDefault().getWorkingCopyManager();
            IJavaScriptUnit unit = manager.getWorkingCopy(this.getEditorInput());
            if (unit != null) {
                IJavaScriptUnit iJavaScriptUnit = unit;
                synchronized (iJavaScriptUnit) {
                    this.performSave(false, progressMonitor);
                }
            } else {
                this.performSave(false, progressMonitor);
            }
        }
    }

    protected void openSaveErrorDialog(String title, String message, CoreException exception) {
        IStatus status = exception.getStatus();
        if ("org.eclipse.wst.jsdt.ui".equals(status.getPlugin()) && status.getCode() == 10006) {
            int mask = 7;
            ErrorDialog dialog = new ErrorDialog(this.getSite().getShell(), title, message, status, mask){

                protected Control createDialogArea(Composite parent) {
                    parent = (Composite)super.createDialogArea(parent);
                    Link link = new Link(parent, 0);
                    link.setText(JavaEditorMessages.CompilationUnitEditor_error_saving_saveParticipant);
                    link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)"org.eclipse.wst.jsdt.ui.preferences.SaveParticipantPreferencePage", null, null).open();
                        }
                    });
                    GridData gridData = new GridData(4, 1, true, false);
                    link.setLayoutData((Object)gridData);
                    return parent;
                }
            };
            dialog.open();
        } else {
            super.openSaveErrorDialog(title, message, exception);
        }
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    @Override
    protected void doSetInput(IEditorInput input) throws CoreException {
        super.doSetInput(input);
        this.configureToggleCommentAction();
        if (this.fJavaEditorErrorTickUpdater != null) {
            this.fJavaEditorErrorTickUpdater.updateEditorImage(this.getInputJavaElement());
        }
    }

    @Override
    protected void installOverrideIndicator(boolean provideAST) {
        super.installOverrideIndicator(provideAST);
        if (this.fOverrideIndicatorManager == null) {
            return;
        }
        this.addReconcileListener(this.fOverrideIndicatorManager);
    }

    @Override
    protected void uninstallOverrideIndicator() {
        if (this.fOverrideIndicatorManager != null) {
            this.removeReconcileListener(this.fOverrideIndicatorManager);
        }
        super.uninstallOverrideIndicator();
    }

    private void configureToggleCommentAction() {
        IAction action = this.getAction("ToggleComment");
        if (action instanceof ToggleCommentAction) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            SourceViewerConfiguration configuration = this.getSourceViewerConfiguration();
            ((ToggleCommentAction)action).configure(sourceViewer, configuration);
        }
    }

    protected void installTabsToSpacesConverter() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        SourceViewerConfiguration config = this.getSourceViewerConfiguration();
        if (config != null && sourceViewer instanceof ITextViewerExtension7) {
            int tabWidth = config.getTabWidth(sourceViewer);
            TabsToSpacesConverter tabToSpacesConverter = new TabsToSpacesConverter();
            tabToSpacesConverter.setNumberOfSpacesPerTab(tabWidth);
            IDocumentProvider provider = this.getDocumentProvider();
            if (provider instanceof ICompilationUnitDocumentProvider) {
                ICompilationUnitDocumentProvider cup = (ICompilationUnitDocumentProvider)provider;
                tabToSpacesConverter.setLineTracker(cup.createLineTracker(this.getEditorInput()));
            } else {
                tabToSpacesConverter.setLineTracker((ILineTracker)new DefaultLineTracker());
            }
            ((ITextViewerExtension7)sourceViewer).setTabsToSpacesConverter((IAutoEditStrategy)tabToSpacesConverter);
            this.updateIndentPrefixes();
        }
    }

    protected boolean isTabsToSpacesConversionEnabled() {
        IJavaScriptElement element = this.getInputJavaElement();
        IJavaScriptProject project = element == null ? null : element.getJavaScriptProject();
        String option = project == null ? JavaScriptCore.getOption(SPACES_FOR_TABS) : project.getOption(SPACES_FOR_TABS, true);
        return "space".equals(option);
    }

    @Override
    public void dispose() {
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).removeVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        if (this.fJavaEditorErrorTickUpdater != null) {
            this.fJavaEditorErrorTickUpdater.dispose();
            this.fJavaEditorErrorTickUpdater = null;
        }
        if (this.fCorrectionCommands != null) {
            this.fCorrectionCommands.deregisterCommands();
            this.fCorrectionCommands = null;
        }
        super.dispose();
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        IPreferenceStore preferenceStore = this.getPreferenceStore();
        boolean closeBrackets = preferenceStore.getBoolean(CLOSE_BRACKETS);
        boolean closeStrings = preferenceStore.getBoolean(CLOSE_STRINGS);
        boolean closeAngularBrackets = "1.5".compareTo(preferenceStore.getString("org.eclipse.wst.jsdt.core.compiler.source")) <= 0;
        this.fBracketInserter.setCloseBracketsEnabled(closeBrackets);
        this.fBracketInserter.setCloseStringsEnabled(closeStrings);
        this.fBracketInserter.setCloseAngularBracketsEnabled(closeAngularBrackets);
        ISourceViewer sourceViewer = this.getSourceViewer();
        if (sourceViewer instanceof ITextViewerExtension) {
            ((ITextViewerExtension)sourceViewer).prependVerifyKeyListener((VerifyKeyListener)this.fBracketInserter);
        }
        if (this.isMarkingOccurrences()) {
            this.installOccurrencesFinder(false);
        }
    }

    private static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    private static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '<': {
                return '>';
            }
            case '>': {
                return '<';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void handlePreferenceStoreChanged(PropertyChangeEvent event) {
        try {
            AdaptedSourceViewer asv = (AdaptedSourceViewer)this.getSourceViewer();
            if (asv != null) {
                IContentAssistant c;
                String p = event.getProperty();
                if (CLOSE_BRACKETS.equals(p)) {
                    this.fBracketInserter.setCloseBracketsEnabled(this.getPreferenceStore().getBoolean(p));
                    return;
                }
                if (CLOSE_STRINGS.equals(p)) {
                    this.fBracketInserter.setCloseStringsEnabled(this.getPreferenceStore().getBoolean(p));
                    return;
                }
                if ("org.eclipse.wst.jsdt.core.compiler.source".equals(p)) {
                    boolean closeAngularBrackets = "1.5".compareTo(this.getPreferenceStore().getString(p)) <= 0;
                    this.fBracketInserter.setCloseAngularBracketsEnabled(closeAngularBrackets);
                }
                if (SPACES_FOR_TABS.equals(p)) {
                    if (this.isTabsToSpacesConversionEnabled()) {
                        this.installTabsToSpacesConverter();
                    } else {
                        this.uninstallTabsToSpacesConverter();
                    }
                    return;
                }
                if ("smart_tab".equals(p)) {
                    if (this.getPreferenceStore().getBoolean("smart_tab")) {
                        this.setActionActivationCode("IndentOnTab", '\t', -1, 0);
                    } else {
                        this.removeActionActivationCode("IndentOnTab");
                    }
                }
                if ((c = asv.getContentAssistant()) instanceof ContentAssistant) {
                    ContentAssistPreference.changeConfiguration((ContentAssistant)c, this.getPreferenceStore(), event);
                }
                if (CODE_FORMATTER_TAB_SIZE.equals(p) && this.isTabsToSpacesConversionEnabled()) {
                    this.uninstallTabsToSpacesConverter();
                    this.installTabsToSpacesConverter();
                }
            }
        }
        finally {
            super.handlePreferenceStoreChanged(event);
        }
    }

    @Override
    protected ISourceViewer createJavaSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean isOverviewRulerVisible, int styles, IPreferenceStore store) {
        return new AdaptedSourceViewer(parent, verticalRuler, overviewRuler, isOverviewRulerVisible, styles, store);
    }

    @Override
    public void aboutToBeReconciled() {
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((IJavaReconcilingListener)listeners[i]).aboutToBeReconciled();
            ++i;
        }
    }

    @Override
    public void reconciled(JavaScriptUnit ast, boolean forced, IProgressMonitor progressMonitor) {
        Shell shell;
        JavaScriptPlugin javaPlugin = JavaScriptPlugin.getDefault();
        if (javaPlugin == null) {
            return;
        }
        Object[] listeners = this.fReconcilingListeners.getListeners();
        int i = 0;
        int length = listeners.length;
        while (i < length) {
            ((IJavaReconcilingListener)listeners[i]).reconciled(ast, forced, progressMonitor);
            ++i;
        }
        if (!(forced || progressMonitor.isCanceled() || (shell = this.getSite().getShell()) == null || shell.isDisposed())) {
            shell.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    CompilationUnitEditor.this.selectionChanged();
                }
            });
        }
    }

    protected final boolean isActiveEditor() {
        IWorkbenchWindow window = this.getSite().getWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        if (page == null) {
            return false;
        }
        IEditorPart activeEditor = page.getActiveEditor();
        return activeEditor != null && activeEditor.equals(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void addReconcileListener(IJavaReconcilingListener listener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.add((Object)listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void removeReconcileListener(IJavaReconcilingListener listener) {
        ListenerList listenerList = this.fReconcilingListeners;
        synchronized (listenerList) {
            this.fReconcilingListeners.remove((Object)listener);
        }
    }

    protected void updateStateDependentActions() {
        super.updateStateDependentActions();
        this.fGenerateActionGroup.editorStateChanged();
    }

    protected void rememberSelection() {
        this.fRememberedSelection.remember();
    }

    protected void restoreSelection() {
        this.fRememberedSelection.restore();
    }

    protected boolean canHandleMove(IEditorInput originalElement, IEditorInput movedElement) {
        IFile file;
        String ext;
        IFile file2;
        String oldExtension = "";
        if (originalElement instanceof IFileEditorInput && (file2 = ((IFileEditorInput)originalElement).getFile()) != null && (ext = file2.getFileExtension()) != null) {
            oldExtension = ext;
        }
        String newExtension = "";
        if (movedElement instanceof IFileEditorInput && (file = ((IFileEditorInput)movedElement).getFile()) != null) {
            newExtension = file.getFileExtension();
        }
        return oldExtension.equals(newExtension);
    }

    @Override
    public Object getAdapter(Class required) {
        if (SmartBackspaceManager.class.equals((Object)required) && this.getSourceViewer() instanceof JavaSourceViewer) {
            return ((JavaSourceViewer)this.getSourceViewer()).getBackspaceManager();
        }
        return super.getAdapter(required);
    }

    public Object getReconcilerLock() {
        return this.fReconcilerLock;
    }

    @Override
    protected void createNavigationActions() {
        super.createNavigationActions();
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        TextNavigationAction action = new JavaEditor.DeletePreviousSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deletePreviousWord");
        this.setAction("org.eclipse.ui.edit.text.deletePreviousWord", (IAction)action);
        textWidget.setKeyBinding(262152, 0);
        this.markAsStateDependentAction("org.eclipse.ui.edit.text.deletePreviousWord", true);
        action = new JavaEditor.DeleteNextSubWordAction();
        action.setActionDefinitionId("org.eclipse.ui.edit.text.deleteNextWord");
        this.setAction("org.eclipse.ui.edit.text.deleteNextWord", (IAction)action);
        textWidget.setKeyBinding(262271, 0);
        this.markAsStateDependentAction("org.eclipse.ui.edit.text.deleteNextWord", true);
    }

    protected void updateStatusField(String category) {
        IStatusField field;
        super.updateStatusField(category);
        if ("InputPosition".equals(category) && (field = this.getStatusField("showOffset")) != null) {
            ISourceViewer sourceViewer = this.getSourceViewer();
            Point selection = sourceViewer.getTextWidget().getSelection();
            int offset1 = CompilationUnitEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.x);
            int offset2 = CompilationUnitEditor.widgetOffset2ModelOffset((ISourceViewer)sourceViewer, (int)selection.y);
            String text = null;
            text = offset1 != offset2 ? "[" + offset1 + "-" + offset2 + "]" : "[ " + offset1 + " ]";
            field.setText(text);
        }
    }

    class AdaptedSourceViewer
    extends JavaSourceViewer {
        public AdaptedSourceViewer(Composite parent, IVerticalRuler verticalRuler, IOverviewRuler overviewRuler, boolean showAnnotationsOverview, int styles, IPreferenceStore store) {
            super(parent, verticalRuler, overviewRuler, showAnnotationsOverview, styles, store);
        }

        public IContentAssistant getContentAssistant() {
            return this.fContentAssistant;
        }

        @Override
        public void doOperation(int operation) {
            if (this.getTextWidget() == null) {
                return;
            }
            switch (operation) {
                case 13: {
                    long time = CODE_ASSIST_DEBUG ? System.currentTimeMillis() : 0L;
                    String msg = this.fContentAssistant.showPossibleCompletions();
                    if (CODE_ASSIST_DEBUG) {
                        long delta = System.currentTimeMillis() - time;
                        System.err.println("Code Assist (total): " + delta);
                    }
                    CompilationUnitEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
                case 22: {
                    String msg = this.fQuickAssistAssistant.showPossibleQuickAssists();
                    CompilationUnitEditor.this.setStatusLineErrorMessage(msg);
                    return;
                }
            }
            super.doOperation(operation);
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester) {
            if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester);
        }

        public boolean requestWidgetToken(IWidgetTokenKeeper requester, int priority) {
            if (PlatformUI.getWorkbench().getHelpSystem().isContextHelpDisplayed()) {
                return false;
            }
            return super.requestWidgetToken(requester, priority);
        }

        @Override
        public IFormattingContext createFormattingContext() {
            CommentFormattingContext context = new CommentFormattingContext();
            IJavaScriptElement inputJavaElement = CompilationUnitEditor.this.getInputJavaElement();
            IJavaScriptProject javaProject = inputJavaElement != null ? inputJavaElement.getJavaScriptProject() : null;
            HashMap preferences = javaProject == null ? new HashMap(JavaScriptCore.getOptions()) : new HashMap(javaProject.getOptions(true));
            context.setProperty("formatting.context.preferences", preferences);
            return context;
        }
    }

    private class BracketInserter
    implements VerifyKeyListener,
    ILinkedModeListener {
        private boolean fCloseBrackets = true;
        private boolean fCloseStrings = true;
        private boolean fCloseAngularBrackets = true;
        private final String CATEGORY = this.toString();
        private IPositionUpdater fUpdater = new ExclusivePositionUpdater(this.CATEGORY);
        private Stack fBracketLevelStack = new Stack();

        private BracketInserter() {
        }

        public void setCloseBracketsEnabled(boolean enabled) {
            this.fCloseBrackets = enabled;
        }

        public void setCloseStringsEnabled(boolean enabled) {
            this.fCloseStrings = enabled;
        }

        public void setCloseAngularBracketsEnabled(boolean enabled) {
            this.fCloseAngularBrackets = enabled;
        }

        private boolean isAngularIntroducer(String identifier) {
            return identifier.length() > 0 && (Character.isUpperCase(identifier.charAt(0)) || identifier.startsWith("final") || identifier.startsWith("public") || identifier.startsWith("public") || identifier.startsWith("protected") || identifier.startsWith("private"));
        }

        public void verifyKey(VerifyEvent event) {
            if (!event.doit || CompilationUnitEditor.this.getInsertMode() != SMART_INSERT) {
                return;
            }
            switch (event.character) {
                case '\"': 
                case '\'': 
                case '(': 
                case '<': 
                case '[': 
                case '{': {
                    break;
                }
                default: {
                    return;
                }
            }
            ISourceViewer sourceViewer = CompilationUnitEditor.this.getSourceViewer();
            IDocument document = sourceViewer.getDocument();
            Point selection = sourceViewer.getSelectedRange();
            int offset = selection.x;
            int length = selection.y;
            try {
                ITypedRegion partition;
                IRegion startLine = document.getLineInformationOfOffset(offset);
                IRegion endLine = document.getLineInformationOfOffset(offset + length);
                JavaHeuristicScanner scanner = new JavaHeuristicScanner(document);
                int nextToken = scanner.nextToken(offset + length, endLine.getOffset() + endLine.getLength());
                String next = nextToken == -1 ? null : document.get(offset, scanner.getPosition() - offset).trim();
                int prevToken = scanner.previousToken(offset - 1, startLine.getOffset());
                int prevTokenOffset = scanner.getPosition() + 1;
                String previous = prevToken == -1 ? null : document.get(prevTokenOffset, offset - prevTokenOffset).trim();
                switch (event.character) {
                    case '(': {
                        if (this.fCloseBrackets && nextToken != 5 && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '<': {
                        if (this.fCloseAngularBrackets && this.fCloseBrackets && nextToken != 13 && (prevToken == 1 || prevToken == 2 || prevToken == 7 || prevToken == 1022 || prevToken == 1019 || prevToken == 2000 && this.isAngularIntroducer(previous) || prevToken == -1)) break;
                        return;
                    }
                    case '[': 
                    case '{': {
                        if (this.fCloseBrackets && nextToken != 2000 && (next == null || next.length() <= 1)) break;
                        return;
                    }
                    case '\"': 
                    case '\'': {
                        if (this.fCloseStrings && nextToken != 2000 && prevToken != 2000 && (next == null || next.length() <= 1) && (previous == null || previous.length() <= 1)) break;
                        return;
                    }
                    default: {
                        return;
                    }
                }
                if (!"__dftl_partition_content_type".equals((partition = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)offset, (boolean)true)).getType())) {
                    return;
                }
                if (!CompilationUnitEditor.this.validateEditorInputState()) {
                    return;
                }
                char character = event.character;
                char closingCharacter = CompilationUnitEditor.getPeerCharacter(character);
                StringBuffer buffer = new StringBuffer();
                buffer.append(character);
                buffer.append(closingCharacter);
                document.replace(offset, length, buffer.toString());
                BracketLevel level = new BracketLevel();
                this.fBracketLevelStack.push(level);
                LinkedPositionGroup group = new LinkedPositionGroup();
                group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
                LinkedModeModel model = new LinkedModeModel();
                model.addLinkingListener((ILinkedModeListener)this);
                model.addGroup(group);
                model.forceInstall();
                level.fOffset = offset;
                level.fLength = 2;
                if (this.fBracketLevelStack.size() == 1) {
                    document.addPositionCategory(this.CATEGORY);
                    document.addPositionUpdater(this.fUpdater);
                }
                level.fFirstPosition = new Position(offset, 1);
                level.fSecondPosition = new Position(offset + 1, 1);
                document.addPosition(this.CATEGORY, level.fFirstPosition);
                document.addPosition(this.CATEGORY, level.fSecondPosition);
                level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
                level.fUI.setSimpleMode(true);
                level.fUI.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(closingCharacter, CompilationUnitEditor.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
                level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
                level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
                level.fUI.enter();
                IRegion newSelection = level.fUI.getSelectedRegion();
                sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
                event.doit = false;
            }
            catch (BadLocationException e) {
                JavaScriptPlugin.log(e);
            }
            catch (BadPositionCategoryException e) {
                JavaScriptPlugin.log(e);
            }
        }

        public void left(LinkedModeModel environment, int flags) {
            final BracketLevel level = (BracketLevel)this.fBracketLevelStack.pop();
            if (flags != 8) {
                return;
            }
            ISourceViewer sourceViewer = CompilationUnitEditor.this.getSourceViewer();
            final IDocument document = sourceViewer.getDocument();
            if (document instanceof IDocumentExtension) {
                IDocumentExtension extension = (IDocumentExtension)document;
                extension.registerPostNotificationReplace(null, new IDocumentExtension.IReplace(){

                    public void perform(IDocument d, IDocumentListener owner) {
                        if ((level.fFirstPosition.isDeleted || level.fFirstPosition.length == 0) && !level.fSecondPosition.isDeleted && level.fSecondPosition.offset == level.fFirstPosition.offset) {
                            try {
                                document.replace(level.fSecondPosition.offset, level.fSecondPosition.length, "");
                            }
                            catch (BadLocationException e) {
                                JavaScriptPlugin.log(e);
                            }
                        }
                        if (BracketInserter.this.fBracketLevelStack.size() == 0) {
                            document.removePositionUpdater(BracketInserter.this.fUpdater);
                            try {
                                document.removePositionCategory(BracketInserter.this.CATEGORY);
                            }
                            catch (BadPositionCategoryException e) {
                                JavaScriptPlugin.log(e);
                            }
                        }
                    }
                });
            }
        }

        public void suspend(LinkedModeModel environment) {
        }

        public void resume(LinkedModeModel environment, int flags) {
        }
    }

    private static class BracketLevel {
        int fOffset;
        int fLength;
        LinkedModeUI fUI;
        Position fFirstPosition;
        Position fSecondPosition;

        private BracketLevel() {
        }
    }

    private static class ExclusivePositionUpdater
    implements IPositionUpdater {
        private final String fCategory;

        public ExclusivePositionUpdater(String category) {
            this.fCategory = category;
        }

        public void update(DocumentEvent event) {
            int eventOffset = event.getOffset();
            int eventOldLength = event.getLength();
            int eventNewLength = event.getText() == null ? 0 : event.getText().length();
            int deltaLength = eventNewLength - eventOldLength;
            try {
                Position[] positions = event.getDocument().getPositions(this.fCategory);
                int i = 0;
                while (i != positions.length) {
                    Position position = positions[i];
                    if (!position.isDeleted()) {
                        int offset = position.getOffset();
                        int length = position.getLength();
                        int end = offset + length;
                        if (offset >= eventOffset + eventOldLength) {
                            position.setOffset(offset + deltaLength);
                        } else if (end > eventOffset) {
                            if (offset <= eventOffset && end >= eventOffset + eventOldLength) {
                                position.setLength(length + deltaLength);
                            } else if (offset < eventOffset) {
                                int newEnd = eventOffset;
                                position.setLength(newEnd - offset);
                            } else if (end > eventOffset + eventOldLength) {
                                int newOffset = eventOffset + eventNewLength;
                                position.setOffset(newOffset);
                                position.setLength(end - newOffset);
                            } else {
                                position.delete();
                            }
                        }
                    }
                    ++i;
                }
            }
            catch (BadPositionCategoryException badPositionCategoryException) {}
        }

        public String getCategory() {
            return this.fCategory;
        }
    }

    private class ExitPolicy
    implements LinkedModeUI.IExitPolicy {
        final char fExitCharacter;
        final char fEscapeCharacter;
        final Stack fStack;
        final int fSize;

        public ExitPolicy(char exitCharacter, char escapeCharacter, Stack stack) {
            this.fExitCharacter = exitCharacter;
            this.fEscapeCharacter = escapeCharacter;
            this.fStack = stack;
            this.fSize = this.fStack.size();
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            if (this.fSize == this.fStack.size() && !this.isMasked(offset)) {
                if (event.character == this.fExitCharacter) {
                    BracketLevel level = (BracketLevel)this.fStack.peek();
                    if (level.fFirstPosition.offset > offset || level.fSecondPosition.offset < offset) {
                        return null;
                    }
                    if (level.fSecondPosition.offset == offset && length == 0) {
                        return new LinkedModeUI.ExitFlags(2, false);
                    }
                }
                if (event.character == '\r' && offset > 0) {
                    IDocument document = CompilationUnitEditor.this.getSourceViewer().getDocument();
                    try {
                        if (document.getChar(offset - 1) == '{' || document.getChar(offset - 1) == '[') {
                            return new LinkedModeUI.ExitFlags(1, true);
                        }
                    }
                    catch (BadLocationException badLocationException) {}
                }
            }
            return null;
        }

        private boolean isMasked(int offset) {
            IDocument document = CompilationUnitEditor.this.getSourceViewer().getDocument();
            try {
                return this.fEscapeCharacter == document.getChar(offset - 1);
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
    }

    static interface ITextConverter {
        public void customizeDocumentCommand(IDocument var1, DocumentCommand var2);
    }

    private class RememberedOffset {
        private int fLine;
        private int fColumn;
        private IJavaScriptElement fElement;
        private int fElementLine;

        private RememberedOffset() {
        }

        public void setOffset(int offset) {
            try {
                IDocument document = CompilationUnitEditor.this.getSourceViewer().getDocument();
                this.fLine = document.getLineOfOffset(offset);
                this.fColumn = offset - document.getLineOffset(this.fLine);
                this.fElement = CompilationUnitEditor.this.getElementAt(offset, true);
                this.fElementLine = this.getElementLine(document, this.fElement);
            }
            catch (BadLocationException e) {
                JavaScriptPlugin.log(e);
                this.clear();
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e.getStatus());
                this.clear();
            }
        }

        private int getElementLine(IDocument document, IJavaScriptElement element) throws BadLocationException, JavaScriptModelException {
            ISourceRange range;
            if (element instanceof IMember && (range = ((IMember)element).getNameRange()) != null) {
                return document.getLineOfOffset(range.getOffset());
            }
            int elementOffset = this.getOffset(element);
            if (elementOffset != -1) {
                return document.getLineOfOffset(elementOffset);
            }
            return -1;
        }

        public int getOffset() {
            IJavaScriptElement newElement = this.getElement();
            int offset = this.getRememberedOffset(newElement);
            if (offset == -1 || newElement != null && !this.containsOffset(newElement, offset) && (offset == 0 || !this.containsOffset(newElement, offset - 1))) {
                return -1;
            }
            return offset;
        }

        public int getRememberedOffset(IJavaScriptElement newElement) {
            int newLine;
            IDocument document;
            block6: {
                document = CompilationUnitEditor.this.getSourceViewer().getDocument();
                int newElementLine = this.getElementLine(document, newElement);
                newLine = this.fLine;
                if (newElementLine != -1 && this.fElementLine != -1) {
                    newLine += newElementLine - this.fElementLine;
                }
                if (newLine >= 0 && newLine < document.getNumberOfLines()) break block6;
                return -1;
            }
            try {
                int maxColumn = document.getLineLength(newLine);
                String lineDelimiter = document.getLineDelimiter(newLine);
                if (lineDelimiter != null) {
                    maxColumn -= lineDelimiter.length();
                }
                int offset = this.fColumn > maxColumn ? document.getLineOffset(newLine) + maxColumn : document.getLineOffset(newLine) + this.fColumn;
                return offset;
            }
            catch (BadLocationException e) {
                JavaScriptPlugin.log(e);
                return -1;
            }
            catch (JavaScriptModelException e) {
                JavaScriptPlugin.log(e.getStatus());
                return -1;
            }
        }

        public int getRevealOffset(IJavaScriptElement element, int offset) {
            if (element == null || offset == -1) {
                return -1;
            }
            if (this.containsOffset(element, offset)) {
                if (offset > 0) {
                    IJavaScriptElement alternateElement = CompilationUnitEditor.this.getElementAt(offset, false);
                    if (element.getHandleIdentifier().equals(alternateElement.getParent().getHandleIdentifier())) {
                        return offset - 1;
                    }
                }
                return offset;
            }
            if (offset > 0 && this.containsOffset(element, offset - 1)) {
                return offset - 1;
            }
            return -1;
        }

        public IJavaScriptElement getElement() {
            if (this.fElement == null) {
                return null;
            }
            return this.findElement(this.fElement);
        }

        public void clear() {
            this.fLine = -1;
            this.fColumn = -1;
            this.fElement = null;
            this.fElementLine = -1;
        }

        private boolean containsOffset(IJavaScriptElement element, int offset) {
            int elementOffset = this.getOffset(element);
            int elementLength = this.getLength(element);
            return elementOffset > -1 && elementLength > -1 ? offset >= elementOffset && offset < elementOffset + elementLength : false;
        }

        private int getOffset(IJavaScriptElement element) {
            if (element instanceof ISourceReference) {
                ISourceReference sr = (ISourceReference)((Object)element);
                try {
                    ISourceRange srcRange = sr.getSourceRange();
                    if (srcRange != null) {
                        return srcRange.getOffset();
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            return -1;
        }

        private int getLength(IJavaScriptElement element) {
            if (element instanceof ISourceReference) {
                ISourceReference sr = (ISourceReference)((Object)element);
                try {
                    ISourceRange srcRange = sr.getSourceRange();
                    if (srcRange != null) {
                        return srcRange.getLength();
                    }
                }
                catch (JavaScriptModelException javaScriptModelException) {}
            }
            return -1;
        }

        private IJavaScriptElement findElement(IJavaScriptElement element) {
            if (element == null) {
                return null;
            }
            WorkingCopyManager manager = JavaScriptPlugin.getDefault().getWorkingCopyManager();
            IJavaScriptUnit unit = manager.getWorkingCopy(CompilationUnitEditor.this.getEditorInput());
            if (unit != null) {
                try {
                    JavaModelUtil.reconcile(unit);
                    IJavaScriptElement[] findings = unit.findElements(element);
                    if (findings != null && findings.length > 0) {
                        return findings[0];
                    }
                }
                catch (JavaScriptModelException x) {
                    JavaScriptPlugin.log(x.getStatus());
                }
            }
            return null;
        }
    }

    private class RememberedSelection {
        private RememberedOffset fStartOffset;
        private RememberedOffset fEndOffset;

        private RememberedSelection() {
            this.fStartOffset = new RememberedOffset();
            this.fEndOffset = new RememberedOffset();
        }

        public void remember() {
            ISourceViewer viewer = CompilationUnitEditor.this.getSourceViewer();
            if (viewer != null) {
                Point selection = viewer.getSelectedRange();
                int startOffset = selection.x;
                int endOffset = startOffset + selection.y;
                this.fStartOffset.setOffset(startOffset);
                this.fEndOffset.setOffset(endOffset);
            }
        }

        public void restore() {
            if (CompilationUnitEditor.this.getSourceViewer() == null) {
                return;
            }
            try {
                int endOffset;
                int revealEndOffset;
                int revealStartOffset;
                int startOffset;
                if (CompilationUnitEditor.this.showsHighlightRangeOnly()) {
                    IJavaScriptElement newEndElement;
                    IJavaScriptElement newStartElement = this.fStartOffset.getElement();
                    revealStartOffset = this.fStartOffset.getRevealOffset(newStartElement, startOffset = this.fStartOffset.getRememberedOffset(newStartElement));
                    if (revealStartOffset == -1) {
                        startOffset = -1;
                    }
                    if ((revealEndOffset = this.fEndOffset.getRevealOffset(newEndElement = this.fEndOffset.getElement(), endOffset = this.fEndOffset.getRememberedOffset(newEndElement))) == -1) {
                        endOffset = -1;
                    }
                } else {
                    revealStartOffset = startOffset = this.fStartOffset.getOffset();
                    revealEndOffset = endOffset = this.fEndOffset.getOffset();
                }
                if (startOffset == -1) {
                    startOffset = endOffset;
                    revealStartOffset = revealEndOffset;
                }
                if (endOffset == -1) {
                    endOffset = startOffset;
                    revealEndOffset = revealStartOffset;
                }
                if (endOffset == -1) {
                    IJavaScriptElement element = this.fEndOffset.getElement();
                    if (element == null) {
                        element = this.fStartOffset.getElement();
                    }
                    if (element != null) {
                        CompilationUnitEditor.this.setSelection(element);
                    }
                    return;
                }
                if (this.isValidSelection(revealStartOffset, revealEndOffset - revealStartOffset) && this.isValidSelection(startOffset, endOffset - startOffset)) {
                    CompilationUnitEditor.this.selectAndReveal(startOffset, endOffset - startOffset, revealStartOffset, revealEndOffset - revealStartOffset);
                }
            }
            finally {
                this.fStartOffset.clear();
                this.fEndOffset.clear();
            }
        }

        private boolean isValidSelection(int offset, int length) {
            IDocument document;
            IDocumentProvider provider = CompilationUnitEditor.this.getDocumentProvider();
            if (provider != null && (document = provider.getDocument((Object)CompilationUnitEditor.this.getEditorInput())) != null) {
                int end = offset + length;
                int documentLength = document.getLength();
                return offset >= 0 && offset <= documentLength && end >= 0 && end <= documentLength && length >= 0;
            }
            return false;
        }
    }
}

