/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.stream.Collectors;
import org.eclipse.wst.jsdt.core.CompletionProposal;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.CatchClause;
import org.eclipse.wst.jsdt.core.dom.DefaultASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.ForInStatement;
import org.eclipse.wst.jsdt.core.dom.ForStatement;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.ObjectLiteralField;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.internal.ui.text.java.IdentifierProposal;
import org.eclipse.wst.jsdt.internal.ui.text.java.IdentifierType;

public class ScopedCodeAssistVisitor
extends DefaultASTVisitor {
    IdentifierProposal currentIdentifier;
    IdentifierProposal objectLiteralFieldParent;
    int filePosition;
    boolean global;
    public Stack<Scope> scopes = new Stack();
    List<IdentifierProposal> identifiers = new ArrayList<IdentifierProposal>();

    public List<IdentifierProposal> getIdentifiers() {
        return this.identifiers;
    }

    public List<IdentifierProposal> getIdentifiers(String key) {
        List<IdentifierProposal> relevantProposals = this.getIdentifiers();
        return this.getIdentifiers(key, relevantProposals);
    }

    public void clearIdentifierProposals() {
        this.scopes.clear();
    }

    public ScopedCodeAssistVisitor(int position) {
        this.filePosition = position;
    }

    private boolean isInside(ASTNode node) {
        int start = node.getStartPosition();
        int end = start + node.getLength();
        return start <= this.filePosition && this.filePosition < end;
    }

    @Override
    public boolean visit(JavaScriptUnit node) {
        this.scopes.push(new Scope());
        return true;
    }

    @Override
    public boolean visit(Assignment node) {
        Assignment.Operator operator = node.getOperator();
        if (operator.equals(Assignment.Operator.ASSIGN)) {
            String leftHandSide = node.toString().split("=")[0];
            String name = leftHandSide.contains(".") ? node.toString().split("\\.")[0] : leftHandSide;
            IdentifierProposal previouslyDeclaredProposal = this.identifierPreviouslyDeclared(name);
            if (previouslyDeclaredProposal == null) {
                IdentifierProposal proposal = new IdentifierProposal(name);
                proposal.setIsGlobal(true);
                this.addIdentifier(proposal, ((Scope)this.scopes.get((int)0)).proposals);
                this.currentIdentifier = proposal;
            } else {
                this.currentIdentifier = previouslyDeclaredProposal;
            }
        }
        return true;
    }

    @Override
    public void endVisit(Assignment node) {
        this.currentIdentifier = null;
    }

    public IdentifierProposal addParent(String expression) {
        String[] splitExpression = expression.split("\\.");
        IdentifierProposal parent = null;
        IdentifierProposal root = null;
        String[] stringArray = splitExpression;
        int n = splitExpression.length;
        int n2 = 0;
        while (n2 < n) {
            String identifier = stringArray[n2];
            if (parent == null) {
                parent = new IdentifierProposal(identifier);
                parent.updateScope(this.scopes);
                root = parent;
                this.addIdentifier(parent, this.scopes.peek().proposals);
            } else {
                IdentifierProposal field = new IdentifierProposal(identifier);
                parent.addField(field);
                parent = field;
            }
            ++n2;
        }
        return root;
    }

    @Override
    public void endVisit(FieldAccess node) {
        IdentifierProposal field = new IdentifierProposal(node.getName().toString());
        IdentifierProposal parent = this.findLastFieldFromExpression(node.getExpression());
        if (parent == null) {
            parent = this.addParent(node.getExpression().toString());
        }
        if (parent != null && !this.identifierExists(field.getName(), parent.getFields())) {
            this.addIdentifier(field, parent.getFields());
            field.addParent(parent);
            this.currentIdentifier = field;
        }
    }

    @Override
    public void endVisit(FunctionInvocation node) {
        String nodeName = node.toString().substring(0, node.toString().length() - 2);
        IdentifierProposal identifier = this.getIdentifier(nodeName);
        if (identifier != null) {
            identifier.setType(IdentifierType.FUNCTION);
        }
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        IdentifierProposal proposal = new IdentifierProposal(node.getName().getIdentifier());
        proposal.updateScope(this.scopes);
        this.addIdentifier(proposal, this.scopes.peek().proposals);
        this.currentIdentifier = proposal;
        return true;
    }

    @Override
    public void endVisit(VariableDeclarationFragment node) {
        this.currentIdentifier = null;
    }

    @Override
    public void endVisit(JavaScriptUnit node) {
        this.identifiers.addAll(this.scopes.peek().proposals);
        this.scopes.pop();
        super.endVisit(node);
    }

    @Override
    public boolean visit(FunctionDeclaration node) {
        Block body;
        Expression methodName = node.getMethodName();
        IdentifierProposal proposal = null;
        ArrayList<String> parameterNames = new ArrayList();
        if (this.currentIdentifier == null) {
            if (methodName != null) {
                String name = methodName.toString();
                proposal = new IdentifierProposal(name);
                proposal.updateScope(this.scopes);
                this.addIdentifier(proposal, this.scopes.peek().proposals);
            }
        } else {
            proposal = this.currentIdentifier;
        }
        if (proposal != null) {
            proposal.setType(IdentifierType.FUNCTION);
            parameterNames = node.parameters().stream().map(k -> ((SingleVariableDeclaration)k).getName().toString()).collect(Collectors.toList());
            proposal.setParameters(parameterNames);
            proposal.setJSdoc(node.getJavadoc());
        }
        if ((body = node.getBody()) != null) {
            this.scopes.push(new Scope());
            for (String parameterName : parameterNames) {
                IdentifierProposal parameterProposal = new IdentifierProposal(parameterName);
                this.addIdentifier(parameterProposal, this.scopes.peek().proposals);
            }
            body.accept(this);
        }
        this.visitBackwards(node.parameters());
        return false;
    }

    @Override
    public void endVisit(FunctionDeclaration node) {
        if (this.isInside(node)) {
            this.identifiers.addAll(this.scopes.peek().proposals);
        }
        this.scopes.pop();
    }

    @Override
    public boolean visit(Initializer node) {
        return this.isInside(node);
    }

    @Override
    public boolean visit(VariableDeclarationStatement node) {
        this.visitBackwards(node.fragments());
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationExpression node) {
        this.visitBackwards(node.fragments());
        return false;
    }

    @Override
    public boolean visit(CatchClause node) {
        if (this.isInside(node)) {
            node.getBody().accept(this);
            node.getException().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ForStatement node) {
        if (this.isInside(node)) {
            node.getBody().accept(this);
            this.visitBackwards(node.initializers());
        }
        return false;
    }

    @Override
    public boolean visit(ForInStatement node) {
        if (this.isInside(node)) {
            node.getBody().accept(this);
            node.getIterationVariable().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(ObjectLiteralField node) {
        IdentifierProposal parent;
        IdentifierProposal field = new IdentifierProposal(node.getFieldName().toString());
        this.objectLiteralFieldParent = parent = this.currentIdentifier;
        if (parent != null && !this.identifierExists(field.getName(), parent.getFields())) {
            this.addIdentifier(field, parent.getFields());
            field.addParent(parent);
            this.currentIdentifier = field;
        }
        return true;
    }

    @Override
    public void endVisit(ObjectLiteralField node) {
        this.currentIdentifier = this.objectLiteralFieldParent;
    }

    @Override
    public boolean visit(TypeDeclarationStatement node) {
        if (node.getStartPosition() + node.getLength() < this.filePosition) {
            IBinding binding = node.getDeclaration().getName().resolveBinding();
            if (binding != null) {
                CompletionProposal proposal = CompletionProposal.create(5, this.filePosition);
                proposal.setCompletion(binding.getName().toCharArray());
            }
            return false;
        }
        return this.isInside(node);
    }

    private void visitBackwards(List<ASTNode> list) {
        int i = list.size() - 1;
        while (i >= 0) {
            ASTNode curr = list.get(i);
            curr.accept(this);
            --i;
        }
    }

    private IdentifierProposal findLastFieldFromExpression(Expression fieldExpression) {
        if (fieldExpression.toString().contains(".")) {
            String[] splitExpression = fieldExpression.toString().split("\\.");
            String rootId = splitExpression[0];
            String parentId = splitExpression[splitExpression.length - 1];
            IdentifierProposal root = this.getIdentifierFromScopes(rootId);
            if (root == null) {
                return null;
            }
            return this.findField(parentId, root);
        }
        return this.getIdentifierFromScopes(fieldExpression.toString());
    }

    private IdentifierProposal getIdentifierFromScopes(String identifierName) {
        ListIterator reverseScopesIterator = this.scopes.listIterator(this.scopes.size());
        while (reverseScopesIterator.hasPrevious()) {
            Scope scope = (Scope)reverseScopesIterator.previous();
            for (IdentifierProposal proposal : scope.proposals) {
                if (!proposal.getName().equals(identifierName)) continue;
                return proposal;
            }
        }
        return null;
    }

    private IdentifierProposal findField(String fieldName, IdentifierProposal root) {
        if (root.getName().equals(fieldName)) {
            return root;
        }
        for (IdentifierProposal fieldProposal : root.getFields()) {
            IdentifierProposal found = this.findField(fieldName, fieldProposal);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private void addIdentifier(IdentifierProposal proposal, List<IdentifierProposal> siblingIdentifiers) {
        if (!this.identifierExists(proposal.getName(), siblingIdentifiers)) {
            siblingIdentifiers.add(proposal);
        }
    }

    private boolean identifierExists(String identifierName, List<IdentifierProposal> siblingIdentifiers) {
        return siblingIdentifiers.stream().filter(k -> k.getName().equals(identifierName)).collect(Collectors.toList()).size() > 0;
    }

    private IdentifierProposal identifierPreviouslyDeclared(String candidateProposalName) {
        for (Scope scope : this.scopes) {
            for (IdentifierProposal p : scope.proposals) {
                if (!candidateProposalName.equals(p.getName())) continue;
                return p;
            }
        }
        return null;
    }

    private List<IdentifierProposal> getIdentifiers(String key, List<IdentifierProposal> proposals) {
        if (key.contains(".")) {
            String[] splitString = key.split("\\.", 2);
            String firstIdentifier = splitString[0];
            String rest = splitString[1];
            for (IdentifierProposal identifier : proposals) {
                if (!identifier.getName().equals(firstIdentifier)) continue;
                return this.getIdentifiers(rest, identifier.getFields());
            }
            return Collections.emptyList();
        }
        return proposals.stream().filter(k -> k.getName().startsWith(key) || k.getCamelCaseName().startsWith(key)).collect(Collectors.toList());
    }

    private IdentifierProposal getIdentifier(String key) {
        List<IdentifierProposal> relevantProposals = this.getCurrentIdentifiers();
        return this.getIdentifier(key, relevantProposals);
    }

    private IdentifierProposal getIdentifier(String key, List<IdentifierProposal> proposals) {
        if (key.contains(".")) {
            String[] splitString = key.split("\\.", 2);
            String firstIdentifier = splitString[0];
            String rest = splitString[1];
            for (IdentifierProposal identifier : proposals) {
                if (!identifier.getName().equals(firstIdentifier)) continue;
                return this.getIdentifier(rest, identifier.getFields());
            }
        } else {
            List matches = proposals.stream().filter(k -> k.getName().equals(key)).collect(Collectors.toList());
            if (!matches.isEmpty()) {
                return (IdentifierProposal)matches.get(0);
            }
        }
        return null;
    }

    private List<IdentifierProposal> getCurrentIdentifiers() {
        ArrayList<IdentifierProposal> scopedIdentifiers = new ArrayList<IdentifierProposal>();
        for (Scope scope : this.scopes) {
            scopedIdentifiers.addAll(0, scope.proposals);
        }
        return scopedIdentifiers;
    }

    public class Scope {
        ArrayList<IdentifierProposal> proposals = new ArrayList();
    }
}

