/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.internal;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.ltk.modelhandler.IModelHandler;
import org.eclipse.wst.sse.core.internal.model.AbstractStructuredModel;
import org.eclipse.wst.sse.core.internal.modelhandler.ModelHandlerRegistry;
import org.eclipse.wst.sse.core.internal.provisional.IModelLoader;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.exceptions.ResourceInUse;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.util.URIResolver;
import org.eclipse.wst.sse.core.internal.util.URIResolverExtension;

public class FileBufferModelManager {
    private static FileBufferModelManager instance = new FileBufferModelManager();
    Map fDocumentMap = null;
    FileBufferMapper fFileBufferListener = new FileBufferMapper();

    private static String locationString(ITextFileBuffer textBuffer) {
        return textBuffer.getLocation() != null ? textBuffer.getLocation().toString() : (textBuffer.getFileStore() != null ? textBuffer.getFileStore().getName() : String.valueOf(textBuffer.getDocument().hashCode()));
    }

    public static FileBufferModelManager getInstance() {
        return instance;
    }

    static final synchronized void shutdown() {
        FileBuffers.getTextFileBufferManager().removeFileBufferListener((IFileBufferListener)FileBufferModelManager.instance.fFileBufferListener);
        if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT || Logger.DEBUG_FILEBUFFERMODELLEAKS) {
            IDocument[] danglingDocuments = FileBufferModelManager.instance.fDocumentMap.keySet().toArray(new IDocument[0]);
            int i = 0;
            while (i < danglingDocuments.length) {
                DocumentInfo info = (DocumentInfo)FileBufferModelManager.instance.fDocumentMap.get(danglingDocuments[i]);
                if (info.modelReferenceCount > 0) {
                    System.err.println("LEAKED MODEL: " + FileBufferModelManager.locationString(info.buffer) + " " + (info.model != null ? info.model.getId() : null));
                }
                if (info.bufferReferenceCount > 0) {
                    System.err.println("LEAKED BUFFER: " + FileBufferModelManager.locationString(info.buffer) + " " + info.buffer.getDocument());
                }
                ++i;
            }
        }
    }

    static final synchronized void startup() {
        FileBuffers.getTextFileBufferManager().addFileBufferListener((IFileBufferListener)FileBufferModelManager.getInstance().fFileBufferListener);
    }

    FileBufferModelManager() {
        this.fDocumentMap = new Hashtable(4);
    }

    public String calculateId(IFile file) {
        if (file == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not calculate a model ID without an IFile");
            Logger.logException(iae);
            return null;
        }
        String id = null;
        IPath path = file.getFullPath();
        if (path != null) {
            id = FileBuffers.normalizeLocation((IPath)path).toString();
        }
        return id;
    }

    public String calculateId(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not calculate a model ID without a document reference");
            Logger.logException(iae);
            return null;
        }
        String id = null;
        ITextFileBuffer buffer = this.getBuffer(document);
        if (buffer != null) {
            id = FileBufferModelManager.locationString(buffer);
        }
        return id;
    }

    public boolean connect(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not connect() without a document");
            Logger.logException(iae);
            return false;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info == null) {
            return false;
        }
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        boolean isOK = true;
        try {
            if (info.buffer.getLocation() != null) {
                bufferManager.connect(info.buffer.getLocation(), info.locationKind, null);
            } else if (info.buffer.getFileStore() != null) {
                bufferManager.connectFileStore(info.buffer.getFileStore(), null);
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
            isOK = false;
        }
        return isOK;
    }

    URIResolver createURIResolver(ITextFileBuffer buffer) {
        URIResolver resolver = null;
        IPath location = buffer.getLocation();
        if (location != null) {
            IFile workspaceFile = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
            if (workspaceFile != null) {
                IProject project = workspaceFile.getProject();
                resolver = (URIResolver)project.getAdapter(URIResolver.class);
                if (resolver == null) {
                    resolver = new CommonURIResolver(workspaceFile);
                }
                String baseLocation = null;
                if (workspaceFile.getLocation() != null) {
                    baseLocation = workspaceFile.getLocation().toString();
                }
                if (baseLocation == null && workspaceFile.getLocationURI() != null) {
                    baseLocation = workspaceFile.getLocationURI().toString();
                }
                if (baseLocation == null) {
                    baseLocation = workspaceFile.getFullPath().toString();
                }
                resolver.setFileBaseLocation(baseLocation);
            } else {
                resolver = new ExternalURIResolver(location);
            }
        } else if (buffer.getFileStore() != null) {
            resolver = new BasicURIResolver(buffer.getFileStore().toURI());
        }
        return resolver;
    }

    /*
     * Unable to fully structure code
     */
    IContentType detectContentType(IFileBuffer buffer) {
        type = null;
        location = buffer.getLocation();
        if (location != null) {
            resource = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
            if (resource != null) {
                if (resource.getType() == 1 && resource.isAccessible()) {
                    d = null;
                    try {
                        d = resource.getContentDescription();
                        if (d != null) {
                            type = d.getContentType();
                        }
                    }
                    catch (CoreException v0) {}
                    if (type == null) {
                        type = Platform.getContentTypeManager().findContentTypeFor(resource.getName());
                    }
                }
            } else {
                file = FileBuffers.getSystemFileAtLocation((IPath)location);
                if (file != null) {
                    block49: {
                        input = null;
                        try {
                            input = new FileInputStream(file);
                            type = Platform.getContentTypeManager().findContentTypeFor((InputStream)input, file.getName());
                        }
                        catch (FileNotFoundException v1) {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException v2) {}
                            }
                            break block49;
                        }
                        catch (IOException v3) {
                            try {
                                ** if (input == null) goto lbl-1000
                            }
                            catch (Throwable var7_11) {
                                if (input != null) {
                                    try {
                                        input.close();
                                    }
                                    catch (IOException v5) {}
                                }
                                throw var7_11;
                            }
lbl-1000:
                            // 1 sources

                            {
                                try {
                                    input.close();
                                }
                                catch (IOException v4) {}
                            }
lbl-1000:
                            // 2 sources

                            {
                                break block49;
                            }
                        }
                        if (input == null) break block49;
                        try {
                            input.close();
                        }
                        catch (IOException v6) {}
                    }
                    if (type == null) {
                        type = Platform.getContentTypeManager().findContentTypeFor(file.getName());
                    }
                }
            }
        } else {
            fileStore = buffer.getFileStore();
            if (fileStore != null) {
                block50: {
                    input = null;
                    try {
                        input = fileStore.openInputStream(0, null);
                        if (input != null) {
                            type = Platform.getContentTypeManager().findContentTypeFor(input, fileStore.getName());
                        }
                    }
                    catch (CoreException v7) {
                        if (input != null) {
                            try {
                                input.close();
                            }
                            catch (IOException v8) {}
                        }
                        break block50;
                    }
                    catch (IOException v9) {
                        try {
                            ** if (input == null) goto lbl-1000
                        }
                        catch (Throwable var6_10) {
                            if (input != null) {
                                try {
                                    input.close();
                                }
                                catch (IOException v11) {}
                            }
                            throw var6_10;
                        }
lbl-1000:
                        // 1 sources

                        {
                            try {
                                input.close();
                            }
                            catch (IOException v10) {}
                        }
lbl-1000:
                        // 2 sources

                        {
                            break block50;
                        }
                    }
                    if (input == null) break block50;
                    try {
                        input.close();
                    }
                    catch (IOException v12) {}
                }
                if (type == null) {
                    type = Platform.getContentTypeManager().findContentTypeFor(fileStore.getName());
                }
            }
        }
        if (type == null) {
            type = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
        }
        return type;
    }

    public boolean disconnect(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not disconnect() without a document");
            Logger.logException(iae);
            return false;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info == null) {
            return false;
        }
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        boolean isOK = true;
        try {
            if (info.buffer.getLocation() != null) {
                bufferManager.disconnect(info.buffer.getLocation(), info.locationKind, null);
            } else if (info.buffer.getFileStore() != null) {
                bufferManager.disconnectFileStore(info.buffer.getFileStore(), null);
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
            isOK = false;
        }
        return isOK;
    }

    public ITextFileBuffer getBuffer(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not get a buffer without a document reference");
            Logger.logException(iae);
            return null;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info != null) {
            return info.buffer;
        }
        return null;
    }

    String getContentTypeID(IDocument document) {
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info != null) {
            return info.contentTypeID;
        }
        return null;
    }

    IStructuredModel getModel(File file) {
        if (file == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not get/create a model without a java.io.File");
            Logger.logException(iae);
            return null;
        }
        IStructuredModel model = null;
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        try {
            Path location = new Path(file.getAbsolutePath());
            if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT) {
                Logger.log(1, "FileBufferModelManager connecting to File " + location);
            }
            bufferManager.connect((IPath)location, LocationKind.LOCATION, this.getProgressMonitor());
            ITextFileBuffer buffer = bufferManager.getTextFileBuffer((IPath)location, LocationKind.LOCATION);
            if (buffer != null) {
                IDocument bufferDocument;
                DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(buffer.getDocument());
                if (info != null) {
                    info.locationKind = LocationKind.LOCATION;
                    info.selfConnected = true;
                }
                if ((bufferDocument = buffer.getDocument()) instanceof IStructuredDocument) {
                    model = this.getModel((IStructuredDocument)bufferDocument);
                } else {
                    bufferManager.disconnect((IPath)location, LocationKind.IFILE, this.getProgressMonitor());
                }
            }
        }
        catch (CoreException e) {
            Logger.logException("Error getting model for " + file.getPath(), e);
        }
        return model;
    }

    public IStructuredModel getModel(IFile file) {
        if (file == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not get/create a model without an IFile");
            Logger.logException(iae);
            return null;
        }
        IStructuredModel model = null;
        ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
        try {
            IPath location;
            if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT) {
                Logger.log(1, "FileBufferModelManager connecting to IFile " + file.getFullPath());
            }
            if ((location = file.getFullPath()) != null) {
                bufferManager.connect(location, LocationKind.IFILE, this.getProgressMonitor());
                ITextFileBuffer buffer = bufferManager.getTextFileBuffer(location, LocationKind.IFILE);
                if (buffer != null) {
                    IDocument bufferDocument;
                    DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(buffer.getDocument());
                    if (info != null) {
                        info.selfConnected = true;
                        info.locationKind = LocationKind.IFILE;
                    }
                    if ((bufferDocument = buffer.getDocument()) instanceof IStructuredDocument) {
                        model = this.getModel((IStructuredDocument)bufferDocument);
                    } else {
                        bufferManager.disconnect(location, LocationKind.IFILE, this.getProgressMonitor());
                    }
                }
            }
        }
        catch (CoreException e) {
            Logger.logException("Error getting model for " + file.getFullPath(), e);
        }
        return model;
    }

    public IStructuredModel getModel(IStructuredDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not get/create a model without a document reference");
            Logger.logException(iae);
            return null;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info != null && info.model == null) {
            if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT) {
                Logger.log(1, "FileBufferModelManager creating model for " + FileBufferModelManager.locationString(info.buffer) + " " + info.buffer.getDocument());
            }
            ++info.modelReferenceCount;
            IStructuredModel model = null;
            IModelHandler handler = ModelHandlerRegistry.getInstance().getHandlerForContentTypeId(info.contentTypeID);
            IModelLoader loader = handler.getModelLoader();
            String id = info.buffer.getLocation() != null ? info.buffer.getLocation().toString() : String.valueOf(document.hashCode());
            model = loader.createModel(document, id, handler);
            try {
                info.model = model;
                model.setId(id);
                if (model instanceof AbstractStructuredModel) {
                    ((AbstractStructuredModel)model).setContentTypeIdentifier(info.contentTypeID);
                }
                model.setResolver(this.createURIResolver(info.buffer));
                if (info.buffer.isDirty()) {
                    model.setDirtyState(true);
                }
            }
            catch (ResourceInUse e) {
                Logger.logException("attempted to create new model with existing ID", e);
                Object var3_4 = null;
            }
        }
        if (info != null) {
            return info.model;
        }
        return null;
    }

    private IProgressMonitor getProgressMonitor() {
        return new NullProgressMonitor();
    }

    private void checkReferenceCounts(DocumentInfo info, IDocument document) {
        if (info.bufferReferenceCount == 0 && info.modelReferenceCount == 0) {
            this.fDocumentMap.remove(document);
        }
    }

    public boolean isExistingBuffer(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not check for an existing buffer without a document reference");
            Logger.logException(iae);
            return false;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        return info != null;
    }

    public void releaseModel(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not release a model without a document reference");
            Logger.logException(iae);
            return;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info != null) {
            if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT) {
                Logger.log(1, "FileBufferModelManager noticed full release of model for " + FileBufferModelManager.locationString(info.buffer) + " " + info.buffer.getDocument());
            }
            info.model = null;
            --info.modelReferenceCount;
            if (info.selfConnected) {
                if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT) {
                    Logger.log(1, "FileBufferModelManager disconnecting from " + FileBufferModelManager.locationString(info.buffer) + " " + info.buffer.getDocument());
                }
                ITextFileBufferManager bufferManager = FileBuffers.getTextFileBufferManager();
                try {
                    if (info.buffer.getLocation() != null) {
                        bufferManager.disconnect(info.buffer.getLocation(), info.locationKind, null);
                    } else if (info.buffer.getFileStore() != null) {
                        bufferManager.disconnectFileStore(info.buffer.getFileStore(), null);
                    }
                }
                catch (CoreException e) {
                    Logger.logException("Error releasing model for " + FileBufferModelManager.locationString(info.buffer), e);
                }
            }
            this.checkReferenceCounts(info, document);
        }
    }

    public void revert(IDocument document) {
        if (document == null) {
            IllegalArgumentException iae = new IllegalArgumentException("can not revert a model without a document reference");
            Logger.logException(iae);
            return;
        }
        DocumentInfo info = (DocumentInfo)this.fDocumentMap.get(document);
        if (info == null) {
            Logger.log(4, "FileBufferModelManager was asked to revert a document that was not being managed");
        } else {
            try {
                info.buffer.revert(this.getProgressMonitor());
            }
            catch (CoreException e) {
                Logger.logException("Error reverting model for " + FileBufferModelManager.locationString(info.buffer), e);
            }
        }
    }

    static class BasicURIResolver
    implements URIResolver,
    URIResolverExtension {
        private URI fURI;

        BasicURIResolver(URI uri) {
            this.fURI = uri;
        }

        @Override
        public URIResolver newInstance() {
            return new BasicURIResolver(this.fURI);
        }

        @Override
        public String getFileBaseLocation() {
            return this.fURI.toString();
        }

        @Override
        public String getLocationByURI(String uri) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), false);
        }

        @Override
        public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), resolveCrossProjectLinks);
        }

        @Override
        public String getLocationByURI(String uri, String baseReference) {
            return this.getLocationByURI(uri, baseReference, false);
        }

        @Override
        public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
            return URI.create(baseReference).resolve(uri).toString();
        }

        @Override
        public IProject getProject() {
            return null;
        }

        @Override
        public IContainer getRootLocation() {
            return null;
        }

        @Override
        public InputStream getURIStream(String uri) {
            return new ByteArrayInputStream(new byte[0]);
        }

        @Override
        public void setFileBaseLocation(String newLocation) {
        }

        @Override
        public void setProject(IProject newProject) {
        }
    }

    static class CommonURIResolver
    implements URIResolver,
    URIResolverExtension {
        String fLocation;
        IPath fPath;
        private IProject fProject;
        static final String SEPARATOR = "/";
        static final String FILE_PREFIX = "file://";

        CommonURIResolver(IFile workspaceFile) {
            this.fPath = workspaceFile.getFullPath();
            this.fProject = workspaceFile.getProject();
        }

        private CommonURIResolver() {
        }

        @Override
        public String getFileBaseLocation() {
            return this.fLocation;
        }

        @Override
        public String getLocationByURI(String uri) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), false);
        }

        @Override
        public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), resolveCrossProjectLinks);
        }

        @Override
        public String getLocationByURI(String uri, String baseReference) {
            return this.getLocationByURI(uri, baseReference, false);
        }

        @Override
        public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
            boolean baseHasPrefix = baseReference != null && baseReference.startsWith(FILE_PREFIX);
            String reference = null;
            reference = baseHasPrefix ? baseReference : FILE_PREFIX + baseReference;
            String result = URIResolverPlugin.createResolver().resolve(reference, null, uri);
            if (!baseHasPrefix && result.startsWith(FILE_PREFIX) && result.length() > FILE_PREFIX.length()) {
                result = result.substring(FILE_PREFIX.length());
            }
            return result;
        }

        @Override
        public IProject getProject() {
            return this.fProject;
        }

        @Override
        public IContainer getRootLocation() {
            String root = URIResolverPlugin.createResolver().resolve(FILE_PREFIX + this.getFileBaseLocation(), null, SEPARATOR);
            IFile[] files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocation((IPath)new Path(root));
            int i = 0;
            while (i < files.length) {
                if ((files[i].getType() & 2) == 2 && this.fPath.isPrefixOf(((IFolder)files[i]).getFullPath())) {
                    return (IFolder)files[i];
                }
                ++i;
            }
            return this.getProject();
        }

        @Override
        public InputStream getURIStream(String uri) {
            return null;
        }

        @Override
        public void setFileBaseLocation(String newLocation) {
            this.fLocation = newLocation;
        }

        @Override
        public void setProject(IProject newProject) {
            this.fProject = newProject;
        }

        @Override
        public URIResolver newInstance() {
            CommonURIResolver resolver = new CommonURIResolver();
            resolver.fLocation = this.fLocation;
            resolver.fPath = (IPath)this.fPath.clone();
            resolver.fProject = this.fProject;
            return resolver;
        }
    }

    static class DocumentInfo {
        ITextFileBuffer buffer = null;
        String contentTypeID = null;
        IStructuredModel model = null;
        boolean selfConnected = false;
        int bufferReferenceCount = 0;
        int modelReferenceCount = 0;
        LocationKind locationKind = LocationKind.NORMALIZE;

        DocumentInfo() {
        }
    }

    static class ExternalURIResolver
    implements URIResolver,
    URIResolverExtension {
        IPath fLocation;

        ExternalURIResolver(IPath location) {
            this.fLocation = location;
        }

        @Override
        public String getFileBaseLocation() {
            if (this.fLocation == null) {
                return null;
            }
            return this.fLocation.toString();
        }

        @Override
        public String getLocationByURI(String uri) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), false);
        }

        @Override
        public String getLocationByURI(String uri, boolean resolveCrossProjectLinks) {
            return this.getLocationByURI(uri, this.getFileBaseLocation(), resolveCrossProjectLinks);
        }

        @Override
        public String getLocationByURI(String uri, String baseReference) {
            return this.getLocationByURI(uri, baseReference, false);
        }

        @Override
        public String getLocationByURI(String uri, String baseReference, boolean resolveCrossProjectLinks) {
            if (uri == null) {
                return null;
            }
            if (uri.startsWith("file:")) {
                try {
                    URL url = new URL(uri);
                    return url.getFile();
                }
                catch (MalformedURLException malformedURLException) {}
            }
            return URIHelper.normalize(uri, baseReference, Path.ROOT.toString());
        }

        @Override
        public IProject getProject() {
            return null;
        }

        @Override
        public IContainer getRootLocation() {
            return ResourcesPlugin.getWorkspace().getRoot();
        }

        @Override
        public InputStream getURIStream(String uri) {
            return null;
        }

        @Override
        public void setFileBaseLocation(String newLocation) {
            this.fLocation = newLocation != null ? new Path(newLocation) : null;
        }

        @Override
        public void setProject(IProject newProject) {
        }

        @Override
        public URIResolver newInstance() {
            return new ExternalURIResolver(this.fLocation != null ? (IPath)this.fLocation.clone() : null);
        }
    }

    class FileBufferMapper
    implements IFileBufferListener {
        FileBufferMapper() {
        }

        public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
        }

        public void bufferContentReplaced(IFileBuffer buffer) {
        }

        public void bufferCreated(IFileBuffer buffer) {
            if (buffer instanceof ITextFileBuffer) {
                ITextFileBuffer textBuffer = (ITextFileBuffer)buffer;
                if (!(textBuffer.getDocument() instanceof IStructuredDocument)) {
                    return;
                }
                if (Logger.DEBUG_TEXTBUFFERLIFECYCLE) {
                    Logger.log(1, "Learned new buffer: " + FileBufferModelManager.locationString(textBuffer) + " " + buffer + " " + ((ITextFileBuffer)buffer).getDocument());
                }
                DocumentInfo info = new DocumentInfo();
                info.buffer = textBuffer;
                info.contentTypeID = FileBufferModelManager.this.detectContentType(buffer).getId();
                ++info.bufferReferenceCount;
                FileBufferModelManager.this.fDocumentMap.put(textBuffer.getDocument(), info);
            }
        }

        public void bufferDisposed(IFileBuffer buffer) {
            if (buffer instanceof ITextFileBuffer) {
                DocumentInfo info;
                ITextFileBuffer textBuffer = (ITextFileBuffer)buffer;
                if (!(textBuffer.getDocument() instanceof IStructuredDocument)) {
                    return;
                }
                if (Logger.DEBUG_TEXTBUFFERLIFECYCLE) {
                    Logger.log(1, "Discarded buffer: " + FileBufferModelManager.locationString(textBuffer) + " " + buffer + " " + ((ITextFileBuffer)buffer).getDocument());
                }
                if ((info = (DocumentInfo)FileBufferModelManager.this.fDocumentMap.get(textBuffer.getDocument())) != null) {
                    --info.bufferReferenceCount;
                    FileBufferModelManager.this.checkReferenceCounts(info, textBuffer.getDocument());
                }
            }
        }

        public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            if (buffer instanceof ITextFileBuffer) {
                ITextFileBuffer textBuffer = (ITextFileBuffer)buffer;
                if (Logger.DEBUG_TEXTBUFFERLIFECYCLE) {
                    Logger.log(1, "Buffer dirty state changed: (" + isDirty + ") " + FileBufferModelManager.locationString(textBuffer) + " " + buffer + " " + ((ITextFileBuffer)buffer).getDocument());
                }
                if (!(textBuffer.getDocument() instanceof IStructuredDocument)) {
                    return;
                }
                DocumentInfo info = (DocumentInfo)FileBufferModelManager.this.fDocumentMap.get(textBuffer.getDocument());
                if (info != null && info.model != null) {
                    String msg = "Updating model dirty state for" + FileBufferModelManager.locationString(textBuffer);
                    if (Logger.DEBUG_FILEBUFFERMODELMANAGEMENT || Logger.DEBUG_TEXTBUFFERLIFECYCLE) {
                        Logger.log(1, msg);
                    }
                    info.model.setDirtyState(isDirty);
                    IPath location = info.buffer.getLocation();
                    if (location != null) {
                        IFile workspaceFile = FileBuffers.getWorkspaceFileAtLocation((IPath)location);
                        if (!isDirty && workspaceFile != null) {
                            info.model.resetSynchronizationStamp((IResource)workspaceFile);
                        }
                    }
                }
            }
        }

        public void stateChangeFailed(IFileBuffer buffer) {
        }

        public void stateChanging(IFileBuffer buffer) {
        }

        public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
        }

        public void underlyingFileDeleted(IFileBuffer buffer) {
            if (buffer instanceof ITextFileBuffer && Logger.DEBUG_TEXTBUFFERLIFECYCLE) {
                Logger.log(1, "Deleted buffer: " + FileBufferModelManager.locationString((ITextFileBuffer)buffer) + " " + buffer);
            }
        }

        public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
            if (buffer instanceof ITextFileBuffer && Logger.DEBUG_TEXTBUFFERLIFECYCLE) {
                Logger.log(1, "Moved buffer from: " + FileBufferModelManager.locationString((ITextFileBuffer)buffer) + " " + buffer);
                Logger.log(1, "Moved buffer to: " + path.toString() + " " + buffer);
            }
        }
    }
}

