/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp.sse;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseFramework;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipsePluginConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseServiceConfig;
import com.diffplug.spotless.extra.eclipse.wtp.sse.ContentTypeManager;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.wst.sse.core.internal.cleanup.AbstractStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.encoding.util.CodedResourcePlugin;
import org.osgi.framework.BundleActivator;

public class CleanupStep {
    protected final ProcessorAccessor processorAccessor;

    protected CleanupStep(ProcessorAccessor processorAccessor, FrameworkConfig config) throws Exception {
        config.setProcessorTypeID(processorAccessor.getTypeId());
        SpotlessEclipseFramework.setup((SpotlessEclipseConfig)config);
        this.processorAccessor = processorAccessor;
        this.processorAccessor.refreshPreferences();
        processorAccessor.get().refreshCleanupPreferences = false;
    }

    public String format(String raw) throws Exception {
        return this.processorAccessor.get().cleanupContent(raw);
    }

    public static abstract class FrameworkConfig
    implements SpotlessEclipseConfig {
        private String processorContentTypeID = "none";

        protected FrameworkConfig() {
        }

        void setProcessorTypeID(String contentTypeID) {
            this.processorContentTypeID = contentTypeID;
        }

        public void registerServices(SpotlessEclipseServiceConfig config) {
            config.disableDebugging();
            config.hideEnvironment();
            config.useTemporaryLocations();
            config.changeSystemLineSeparator();
            config.useSlf4J(this.getClass().getPackage().getName() + "-" + this.processorContentTypeID);
            config.add(IContentTypeManager.class, (Object)new ContentTypeManager(this.processorContentTypeID));
            config.add(IPreferencesService.class, (Object)PreferencesService.getDefault());
        }

        public void activatePlugins(SpotlessEclipsePluginConfig config) {
            config.applyDefault();
            config.add((BundleActivator)new CodedResourcePlugin());
        }
    }

    public static interface ProcessorAccessor {
        public void refreshPreferences();

        public AbstractStructuredCleanupProcessor get();

        public String getTypeId();
    }
}

