/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.compare;

import java.util.Stack;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.Initializer;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.PackageDeclaration;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.ui.compare.JavaNode;

class JavaParseTreeBuilder
extends ASTVisitor {
    private char[] fBuffer;
    private Stack fStack = new Stack();
    private JavaNode fImportContainer;
    private boolean fShowCU;

    JavaParseTreeBuilder(JavaNode root, char[] buffer, boolean showCU) {
        this.fBuffer = buffer;
        this.fShowCU = showCU;
        this.fStack.clear();
        this.fStack.push(root);
    }

    @Override
    public boolean visit(PackageDeclaration node) {
        new JavaNode(this.getCurrentContainer(), 1, null, node.getStartPosition(), node.getLength());
        return false;
    }

    @Override
    public boolean visit(JavaScriptUnit node) {
        if (this.fShowCU) {
            this.push(0, null, node.getStartPosition(), node.getLength());
        }
        return true;
    }

    @Override
    public void endVisit(JavaScriptUnit node) {
        if (this.fShowCU) {
            this.pop();
        }
    }

    @Override
    public boolean visit(TypeDeclaration node) {
        this.push(5, node.getName().toString(), node.getStartPosition(), node.getLength());
        return true;
    }

    @Override
    public void endVisit(TypeDeclaration node) {
        this.pop();
    }

    @Override
    public boolean visit(FunctionDeclaration node) {
        String signature = this.getSignature(node);
        this.push(node.isConstructor() ? 10 : 11, signature, node.getStartPosition(), node.getLength());
        return false;
    }

    @Override
    public void endVisit(FunctionDeclaration node) {
        this.pop();
    }

    @Override
    public boolean visit(Initializer node) {
        this.push(9, this.getCurrentContainer().getInitializerCount(), node.getStartPosition(), node.getLength());
        return false;
    }

    @Override
    public void endVisit(Initializer node) {
        this.pop();
    }

    @Override
    public boolean visit(ImportDeclaration node) {
        int s = node.getStartPosition();
        int l = node.getLength();
        int declarationEnd = s + l;
        if (this.fImportContainer == null) {
            this.fImportContainer = new JavaNode(this.getCurrentContainer(), 2, null, s, l);
        }
        String nm = node.getName().toString();
        if (node.isOnDemand()) {
            nm = String.valueOf(nm) + ".*";
        }
        new JavaNode(this.fImportContainer, 3, nm, s, l);
        this.fImportContainer.setLength(declarationEnd - this.fImportContainer.getRange().getOffset() + 1);
        this.fImportContainer.setAppendPosition(declarationEnd + 2);
        return false;
    }

    @Override
    public boolean visit(VariableDeclarationFragment node) {
        String name = this.getFieldName(node);
        ASTNode parent = node.getParent();
        this.push(8, name, parent.getStartPosition(), parent.getLength());
        return false;
    }

    @Override
    public void endVisit(VariableDeclarationFragment node) {
        this.pop();
    }

    private void push(int type, String name, int declarationStart, int length) {
        if (declarationStart >= 0) {
            while (declarationStart > 0) {
                char c = this.fBuffer[declarationStart - 1];
                if (c != ' ' && c != '\t') break;
                --declarationStart;
                ++length;
            }
            JavaNode node = new JavaNode(this.getCurrentContainer(), type, name, declarationStart, length);
            if (type == 0) {
                node.setAppendPosition(declarationStart + length + 1);
            } else {
                node.setAppendPosition(declarationStart + length);
            }
            this.fStack.push(node);
        }
    }

    private void pop() {
        this.fStack.pop();
    }

    private JavaNode getCurrentContainer() {
        return (JavaNode)((Object)this.fStack.peek());
    }

    private String getFieldName(VariableDeclarationFragment node) {
        StringBuffer buffer = new StringBuffer();
        SimpleName name = node.getName();
        buffer.append(name != null ? node.getName().toString() : "");
        ASTNode parent = node.getParent();
        if (parent instanceof FieldDeclaration) {
            FieldDeclaration fd = (FieldDeclaration)parent;
            buffer.append(" : ");
            buffer.append(this.getType(fd.getType()));
        }
        return buffer.toString();
    }

    private String getSignature(FunctionDeclaration node) {
        StringBuffer buffer = new StringBuffer();
        SimpleName name = node.getName();
        if (name != null) {
            buffer.append(name.toString());
        }
        buffer.append('(');
        boolean first = true;
        for (Object parameterDecl : node.parameters()) {
            if (!(parameterDecl instanceof SingleVariableDeclaration)) continue;
            SingleVariableDeclaration svd = (SingleVariableDeclaration)parameterDecl;
            if (!first) {
                buffer.append(", ");
            }
            buffer.append(this.getType(svd.getType()));
            if (svd.isVarargs()) {
                buffer.append("...");
            }
            first = false;
        }
        buffer.append(')');
        return buffer.toString();
    }

    private String getType(Type type) {
        String name = type.toString();
        int pos = name.lastIndexOf(46);
        if (pos >= 0) {
            name = name.substring(pos + 1);
        }
        return name;
    }
}

