/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp;

import com.diffplug.spotless.extra.eclipse.wtp.EclipseJsFormatterStepImpl;
import com.diffplug.spotless.extra.eclipse.wtp.PreventExternalURIResolverExtension;
import com.diffplug.spotless.extra.eclipse.wtp.html.JsRegionProcessor;
import com.diffplug.spotless.extra.eclipse.wtp.html.StructuredDocumentProcessor;
import com.diffplug.spotless.extra.eclipse.wtp.sse.CleanupStep;
import com.diffplug.spotless.extra.eclipse.wtp.sse.SpotlessPreferences;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.internal.filesystem.Activator;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.preferences.CSSCorePreferenceInitializer;
import org.eclipse.wst.dtd.core.internal.DTDCorePlugin;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.cleanup.HTMLCleanupProcessorImpl;
import org.eclipse.wst.html.core.internal.encoding.HTMLDocumentLoader;
import org.eclipse.wst.html.core.internal.format.HTMLFormatProcessorImpl;
import org.eclipse.wst.html.core.internal.preferences.HTMLCorePreferenceInitializer;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.preferences.XMLCorePreferenceInitializer;

public class EclipseHtmlFormatterStepImpl
extends CleanupStep<SpotlessHtmlCleanup> {
    private final String htmlFormatterIndent;
    private final CodeFormatter jsFormatter;
    private static final Set<String> SUPPORTED_CSS_FORMAT_PREFS = new HashSet<String>(Arrays.asList("identifierCase", "selectorCase", "propNameCase", "propValueCase", "betweenValue", "postDelim", "preDelim", "quote", "quoteInURI", "spaceBetweenSelectors", "newLineOnOpenBrace", "onePropertyPerLine", "prohibitWrapOnAttr", "lineWidth", "indentationChar", "indentationSize", "quoteAttrValues", "clearAllBlankLines"));

    public EclipseHtmlFormatterStepImpl(Properties properties) throws Exception {
        super(new SpotlessHtmlCleanup(), EclipseJsFormatterStepImpl.JS_CORE_CONFIG, additionalPlugins -> {
            additionalPlugins.add(new CSSCorePlugin());
            additionalPlugins.add(new XMLCorePlugin());
            additionalPlugins.add(new URIResolverPlugin());
            additionalPlugins.add(new DTDCorePlugin());
            additionalPlugins.add(new Activator());
            additionalPlugins.add(new JavaScriptCore());
            additionalPlugins.add(new HTMLCorePlugin());
            additionalPlugins.add(new PreventExternalURIResolverExtension());
        });
        properties.setProperty("cmDocumentGlobalCacheEnabled", Boolean.toString(false));
        this.configure(EclipseHtmlFormatterStepImpl.getCSSFormattingProperties(properties), true, CSSCorePlugin.getDefault(), new CSSCorePreferenceInitializer());
        this.configure(properties, false, XMLCorePlugin.getDefault(), new XMLCorePreferenceInitializer());
        this.configure(properties, false, HTMLCorePlugin.getDefault(), new HTMLCorePreferenceInitializer());
        this.htmlFormatterIndent = ((SpotlessHtmlCleanup)this.processor).getIndent();
        Map<Object, Object> jsOptions = EclipseJsFormatterStepImpl.createFormatterOptions(properties);
        this.jsFormatter = ToolFactory.createCodeFormatter(jsOptions, 1);
        SpotlessPreferences.configurePluginPreferences(CSSCorePlugin.getDefault(), properties);
    }

    @Override
    public String format(String raw) throws Exception {
        raw = super.format(raw);
        IStructuredDocument document = (IStructuredDocument)new HTMLDocumentLoader().createNewStructuredDocument();
        document.setPreferredLineDelimiter("\n");
        document.set(raw);
        StructuredDocumentProcessor<CodeFormatter> jsProcessor = new StructuredDocumentProcessor<CodeFormatter>(document, "org.eclipse.wst.html.SCRIPT", JsRegionProcessor.createFactory(this.htmlFormatterIndent));
        jsProcessor.apply(this.jsFormatter);
        return document.get();
    }

    private static Properties getCSSFormattingProperties(Properties properties) {
        Properties filteredProperties = new Properties();
        properties.entrySet().stream().filter(entry -> SUPPORTED_CSS_FORMAT_PREFS.contains(entry.getKey())).forEach(entry -> filteredProperties.put(entry.getKey(), entry.getValue()));
        return filteredProperties;
    }

    public static class SpotlessHtmlCleanup
    extends HTMLCleanupProcessorImpl
    implements CleanupStep.ProcessorAccessor {
        private HTMLFormatProcessorImpl processor = null;

        @Override
        public String getThisContentType() {
            return this.getContentType();
        }

        @Override
        public IStructuredFormatProcessor getThisFormatProcessor() {
            return this.getFormatProcessor();
        }

        @Override
        public void refreshThisCleanupPreferences() {
            this.refreshCleanupPreferences();
        }

        @Override
        protected IStructuredFormatProcessor getFormatProcessor() {
            if (null == this.processor) {
                this.processor = new HTMLFormatProcessorImpl();
            }
            return this.processor;
        }

        String getIndent() {
            return this.processor.getFormatPreferences().getIndent();
        }
    }
}

