/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseCoreConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseFramework;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.internal.filesystem.Activator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jface.text.rules.FastPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.formatter.CodeFormatter;
import org.eclipse.wst.jsdt.core.formatter.DefaultCodeFormatterConstants;
import org.eclipse.wst.jsdt.internal.ui.text.FastJavaPartitionScanner;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingContext;
import org.eclipse.wst.jsdt.internal.ui.text.comment.CommentFormattingStrategy;
import org.osgi.framework.BundleActivator;

public class EclipseJsFormatterStepImpl {
    public static final Consumer<SpotlessEclipseCoreConfig> JS_CORE_CONFIG = core -> {
        core.add((Enum)SpotlessEclipseFramework.DefaultBundles.PLATFORM, 32);
        core.add((Enum[])new SpotlessEclipseFramework.DefaultBundles[]{SpotlessEclipseFramework.DefaultBundles.REGISTRY, SpotlessEclipseFramework.DefaultBundles.PREFERENCES, SpotlessEclipseFramework.DefaultBundles.COMMON});
    };
    private static final String[] COMMENT_TYPES = new String[]{"__java_javadoc", "__java_multiline_comment", "__java_singleline_comment", "__java_string", "__java_character"};
    private static final Map<String, String> OPTION_2_COMMENT_TYPE = Collections.unmodifiableMap(Stream.of(new AbstractMap.SimpleEntry<String, String>("org.eclipse.wst.jsdt.core.formatter.comment.format_line_comments", "__java_singleline_comment"), new AbstractMap.SimpleEntry<String, String>("org.eclipse.wst.jsdt.core.formatter.comment.format_block_comments", "__java_multiline_comment"), new AbstractMap.SimpleEntry<String, String>("org.eclipse.wst.jsdt.core.formatter.comment.format_javadoc_comments", "__java_javadoc")).collect(Collectors.toMap(e -> (String)e.getKey(), e -> (String)e.getValue())));
    private final CodeFormatter formatter;
    private final Map<Object, Object> options;
    private final Set<String> commentTypesToBeFormatted;

    public EclipseJsFormatterStepImpl(Properties properties) throws Exception {
        SpotlessEclipseFramework.setup(JS_CORE_CONFIG, config -> config.applyDefault(), plugins -> {
            plugins.applyDefault();
            plugins.add((BundleActivator)new Activator());
            plugins.add((BundleActivator)new JavaScriptCore());
        });
        this.options = EclipseJsFormatterStepImpl.createFormatterOptions(properties);
        this.commentTypesToBeFormatted = OPTION_2_COMMENT_TYPE.entrySet().stream().filter(x -> "true".equals(this.options.get(x.getKey()))).map(x -> (String)x.getValue()).collect(Collectors.toSet());
        this.formatter = ToolFactory.createCodeFormatter(this.options, 1);
    }

    static Map<Object, Object> createFormatterOptions(Properties properties) {
        Hashtable options = JavaScriptCore.getDefaultOptions();
        options.putAll(DefaultCodeFormatterConstants.getJSLintConventionsSettings());
        options.putAll(new HashMap<Object, Object>(properties));
        return options;
    }

    public String format(String raw) throws Exception {
        raw = this.formatComments(raw);
        Document doc = new Document(raw);
        TextEdit edit = this.formatter.format(8, raw, 0, raw.length(), 0, "\n");
        if (edit == null) {
            throw new IllegalArgumentException("Invalid JavaScript syntax for formatting.");
        }
        edit.apply((IDocument)doc);
        return doc.get();
    }

    private String formatComments(String raw) {
        Document doc = new Document(raw);
        FastPartitioner commentPartitioner = new FastPartitioner((IPartitionTokenScanner)new FastJavaPartitionScanner(), COMMENT_TYPES);
        doc.setDocumentPartitioner("___java_partitioning", (IDocumentPartitioner)commentPartitioner);
        commentPartitioner.connect((IDocument)doc);
        CommentFormattingStrategy commentFormatter = new CommentFormattingStrategy();
        CommentFormattingContext context = new CommentFormattingContext();
        context.setProperty("formatting.context.preferences", this.options);
        context.setProperty("formatting.context.document", Boolean.TRUE);
        context.setProperty("formatting.context.medium", doc);
        try {
            ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)doc, (String)"___java_partitioning", (int)0, (int)doc.getLength(), (boolean)false);
            MultiTextEdit resultEdit = new MultiTextEdit();
            Arrays.asList(regions).stream().filter(reg -> this.commentTypesToBeFormatted.contains(reg.getType())).forEach(arg_0 -> EclipseJsFormatterStepImpl.lambda$formatComments$8((IFormattingContext)context, commentFormatter, resultEdit, arg_0));
            resultEdit.apply((IDocument)doc);
            return doc.get();
        }
        catch (BadLocationException e) {
            return raw;
        }
    }

    private static /* synthetic */ void lambda$formatComments$8(IFormattingContext context, CommentFormattingStrategy commentFormatter, MultiTextEdit resultEdit, ITypedRegion region) {
        TypedPosition typedPosition = new TypedPosition(region.getOffset(), region.getLength(), region.getType());
        context.setProperty((Object)"formatting.context.partition", (Object)typedPosition);
        commentFormatter.formatterStarts(context);
        TextEdit edit = commentFormatter.calculateTextEdit();
        commentFormatter.formatterStops();
        if (null != edit && edit.hasChildren()) {
            resultEdit.addChild(edit);
        }
    }
}

