/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.eclipse.wtp.sse;

import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseCoreConfig;
import com.diffplug.spotless.extra.eclipse.base.SpotlessEclipseFramework;
import com.diffplug.spotless.extra.eclipse.wtp.sse.ContentTypeManager;
import com.diffplug.spotless.extra.eclipse.wtp.sse.SpotlessPreferences;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.wst.sse.core.internal.cleanup.AbstractStructuredCleanupProcessor;
import org.eclipse.wst.sse.core.internal.encoding.util.CodedResourcePlugin;
import org.eclipse.wst.sse.core.internal.format.AbstractStructuredFormatProcessor;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatProcessor;
import org.osgi.framework.BundleActivator;

public class CleanupStep<T extends AbstractStructuredCleanupProcessor> {
    private static final Properties CONFIG = new Properties();
    private static boolean FIRST_CONFIG = true;
    protected final T processor;

    protected CleanupStep(T processor, Consumer<Collection<BundleActivator>> addptionalPlugins) throws Exception {
        this(processor, core -> core.applyDefault(), addptionalPlugins);
    }

    protected CleanupStep(T processor, Consumer<SpotlessEclipseCoreConfig> core, Consumer<Collection<BundleActivator>> addptionalPlugins) throws Exception {
        SpotlessEclipseFramework.setup(core, config -> {
            config.disableDebugging();
            config.hideEnvironment();
            config.useTemporaryLocations();
            config.changeSystemLineSeparator();
            config.add(IContentTypeManager.class, (Object)new ContentTypeManager((ProcessorAccessor)((Object)processor)));
            config.add(IPreferencesService.class, (Object)PreferencesService.getDefault());
        }, plugins -> {
            plugins.applyDefault();
            LinkedList additional = new LinkedList();
            addptionalPlugins.accept(additional);
            plugins.add(additional);
            plugins.add((BundleActivator)new CodedResourcePlugin());
        });
        this.processor = processor;
        ((AbstractStructuredCleanupProcessor)this.processor).refreshCleanupPreferences = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void configure(Properties properties, boolean usesPreferenceService, Plugin plugin, AbstractPreferenceInitializer preferencesInit) {
        Properties properties2 = CONFIG;
        synchronized (properties2) {
            if (usesPreferenceService) {
                CleanupStep.assertConfigHasNotChanged(properties);
            }
            preferencesInit.initializeDefaultPreferences();
            SpotlessPreferences.configurePluginPreferences(plugin, properties);
            ((ProcessorAccessor)this.processor).refreshThisCleanupPreferences();
            IStructuredFormatProcessor formatter = ((ProcessorAccessor)this.processor).getThisFormatProcessor();
            if (formatter instanceof AbstractStructuredFormatProcessor) {
                ((AbstractStructuredFormatProcessor)formatter).refreshFormatPreferences = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void assertConfigHasNotChanged(Properties properties) {
        Properties properties2 = CONFIG;
        synchronized (properties2) {
            if (FIRST_CONFIG) {
                FIRST_CONFIG = false;
                CONFIG.putAll((Map<?, ?>)properties);
            } else if (!CONFIG.equals(properties)) {
                throw new IllegalArgumentException("The Eclipse formatter does not support multiple configurations.");
            }
        }
    }

    public String format(String raw) throws Exception {
        return ((AbstractStructuredCleanupProcessor)this.processor).cleanupContent(raw);
    }

    public static interface ProcessorAccessor {
        public String getThisContentType();

        public IStructuredFormatProcessor getThisFormatProcessor();

        public void refreshThisCleanupPreferences();
    }
}

