/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.css.core.internal.document.CSSAttrImpl;
import org.eclipse.wst.css.core.internal.document.CSSDocumentImpl;
import org.eclipse.wst.css.core.internal.document.CSSImportRuleImpl;
import org.eclipse.wst.css.core.internal.document.CSSModelImpl;
import org.eclipse.wst.css.core.internal.document.CSSNamedNodeMapImpl;
import org.eclipse.wst.css.core.internal.document.CSSNodeListImpl;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceFormatterFactory;
import org.eclipse.wst.css.core.internal.formatter.CSSSourceGenerator;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSDocument;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSModel;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNamedNodeMap;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNodeList;
import org.eclipse.wst.css.core.internal.util.ImportRuleCollector;
import org.eclipse.wst.sse.core.internal.model.FactoryRegistry;
import org.eclipse.wst.sse.core.internal.provisional.AbstractNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.w3c.dom.DOMException;

public abstract class CSSNodeImpl
extends AbstractNotifier
implements ICSSNode,
IndexedRegion,
IAdaptable {
    private CSSDocumentImpl fOwnerDocument = null;
    private CSSNodeImpl fParentNode = null;
    private CSSNodeImpl fNextSibling = null;
    private CSSNodeImpl fPreviousSibling = null;
    private CSSNodeImpl fFirstChild = null;
    private CSSNodeImpl fLastChild = null;
    protected CSSNamedNodeMapImpl fAttrs = null;

    CSSNodeImpl() {
    }

    CSSNodeImpl(CSSNodeImpl that) {
        if (that != null) {
            this.fOwnerDocument = that.fOwnerDocument;
            if (that.fAttrs != null) {
                int nAttrs = that.fAttrs.getLength();
                int i = 0;
                while (i < nAttrs) {
                    CSSAttrImpl attr = (CSSAttrImpl)that.fAttrs.item(i);
                    this.setAttribute(attr.getName(), attr.getValue());
                    ++i;
                }
            }
        }
    }

    public Object getAdapter(Class adapter) {
        ICSSModel model = this.fOwnerDocument != null ? this.fOwnerDocument.getModel() : null;
        return model != null ? Platform.getAdapterManager().getAdapter((Object)model, adapter) : null;
    }

    public CSSNodeImpl appendChild(CSSNodeImpl newChild) throws DOMException {
        return this.insertBefore(newChild, null);
    }

    protected void cloneChildNodes(ICSSNode newParent, boolean deep) {
        if (newParent == null || newParent == this) {
            return;
        }
        CSSNodeImpl container = (CSSNodeImpl)newParent;
        container.removeChildNodes();
        ICSSNode child = this.getFirstChild();
        while (child != null) {
            CSSNodeImpl cloned = (CSSNodeImpl)child.cloneNode(deep);
            if (cloned != null) {
                container.appendChild(cloned);
            }
            child = child.getNextSibling();
        }
    }

    public boolean contains(int offset) {
        return this.getStartOffset() <= offset && offset < this.getEndOffset();
    }

    protected String generateSource() {
        CSSSourceGenerator formatter = CSSSourceFormatterFactory.getInstance().getSourceFormatter(this);
        return formatter.format(this).toString();
    }

    protected String getAttribute(String name) {
        CSSAttrImpl attr = this.getAttributeNode(name);
        if (attr != null) {
            return attr.getValue();
        }
        return null;
    }

    protected CSSAttrImpl getAttributeNode(String name) {
        if (this.fAttrs == null) {
            return null;
        }
        int nAttrs = this.fAttrs.getLength();
        int i = 0;
        while (i < nAttrs) {
            CSSAttrImpl attr = (CSSAttrImpl)this.fAttrs.item(i);
            if (attr.matchName(name)) {
                return attr;
            }
            ++i;
        }
        return null;
    }

    public ICSSNamedNodeMap getAttributes() {
        if (this.fAttrs == null) {
            this.fAttrs = new CSSNamedNodeMapImpl();
        }
        return this.fAttrs;
    }

    public ICSSNodeList getChildNodes() {
        CSSNodeListImpl list = new CSSNodeListImpl();
        ICSSNode node = this.getFirstChild();
        while (node != null) {
            list.appendNode(node);
            node = node.getNextSibling();
        }
        return list;
    }

    ICSSNode getCommonAncestor(ICSSNode node) {
        if (node == null) {
            return null;
        }
        ICSSNode na = node;
        while (na != null) {
            ICSSNode ta = this;
            while (ta != null) {
                if (ta == na) {
                    return ta;
                }
                ta = ta.getParentNode();
            }
            na = na.getParentNode();
        }
        return null;
    }

    CSSDocumentImpl getContainerDocument() {
        ICSSNode node = this;
        while (node != null) {
            CSSDocumentImpl doc;
            if (node instanceof CSSDocumentImpl && (doc = (CSSDocumentImpl)node).isDocument()) {
                return doc;
            }
            node = node.getParentNode();
        }
        return null;
    }

    CSSNodeImpl getContainerNode(int offset) {
        if (!this.contains(offset)) {
            return null;
        }
        ICSSNode child = this.getFirstChild();
        while (child != null) {
            CSSNodeImpl found = ((CSSNodeImpl)child).getContainerNode(offset);
            if (found != null) {
                return found;
            }
            child = child.getNextSibling();
        }
        return this;
    }

    public FactoryRegistry getFactoryRegistry() {
        FactoryRegistry reg;
        ICSSModel model = this.getOwnerDocument().getModel();
        if (model != null && (reg = model.getFactoryRegistry()) != null) {
            return reg;
        }
        return null;
    }

    public ICSSNode getFirstChild() {
        return this.fFirstChild;
    }

    public ICSSNode getLastChild() {
        return this.fLastChild;
    }

    public ICSSNode getNextSibling() {
        return this.fNextSibling;
    }

    ICSSNode getNodeAt(int offset) {
        return this.getContainerNode(offset);
    }

    public ICSSDocument getOwnerDocument() {
        return this.fOwnerDocument;
    }

    public ICSSNode getParentNode() {
        return this.fParentNode;
    }

    public ICSSNode getPreviousSibling() {
        return this.fPreviousSibling;
    }

    ICSSNode getRootNode() {
        CSSNodeImpl parent = (CSSNodeImpl)this.getParentNode();
        if (parent == null) {
            return this;
        }
        return parent.getRootNode();
    }

    public boolean hasChildNodes() {
        return this.fFirstChild != null;
    }

    public boolean hasProperties() {
        return false;
    }

    public CSSNodeImpl insertBefore(CSSNodeImpl newChild, CSSNodeImpl refChild) throws DOMException {
        if (newChild == null) {
            return null;
        }
        CSSNodeImpl child = newChild;
        CSSNodeImpl next = refChild;
        CSSNodeImpl prev = null;
        if (next == null) {
            prev = this.fLastChild;
            this.fLastChild = child;
        } else {
            prev = (CSSNodeImpl)next.getPreviousSibling();
            next.setPreviousSibling(child);
        }
        if (prev == null) {
            this.fFirstChild = child;
        } else {
            prev.setNextSibling(child);
        }
        child.setPreviousSibling(prev);
        child.setNextSibling(next);
        child.setParentNode(this);
        this.notifyChildReplaced(child, null);
        return newChild;
    }

    protected void notifyAttrReplaced(CSSNodeImpl newAttr, CSSNodeImpl oldAttr) {
        CSSDocumentImpl doc = this.getContainerDocument();
        if (doc == null) {
            return;
        }
        CSSModelImpl model = (CSSModelImpl)doc.getModel();
        if (model == null) {
            return;
        }
        model.attrReplaced(this, newAttr, oldAttr);
        int type = 1;
        if (newAttr == null) {
            type = 3;
        } else if (oldAttr == null) {
            type = 2;
        }
        this.notify(type, oldAttr, oldAttr, newAttr, this.getStartOffset());
    }

    protected void notifyChildReplaced(CSSNodeImpl newChild, CSSNodeImpl oldChild) {
        CSSDocumentImpl doc = this.getContainerDocument();
        if (doc == null) {
            return;
        }
        CSSModelImpl model = (CSSModelImpl)doc.getModel();
        if (model == null) {
            return;
        }
        model.childReplaced(this, newChild, oldChild);
        int type = 1;
        if (newChild == null) {
            type = 3;
        } else if (oldChild == null) {
            type = 2;
        }
        this.notify(type, oldChild, oldChild, newChild, this.getStartOffset());
    }

    void removeAttributeNode(CSSNodeImpl attr) {
        int nAttrs = this.fAttrs.getLength();
        int i = 0;
        while (i < nAttrs) {
            if (this.fAttrs.item(i) == attr) {
                this.fAttrs.removeNode(i);
                this.notifyAttrReplaced(null, attr);
                return;
            }
            ++i;
        }
    }

    protected CSSNodeImpl removeChild(CSSNodeImpl oldChild) throws DOMException {
        if (oldChild == null) {
            return null;
        }
        if (oldChild.getParentNode() != this) {
            return null;
        }
        ImportRuleCollector trav = new ImportRuleCollector();
        trav.apply(oldChild);
        Iterator it = trav.getRules().iterator();
        while (it.hasNext()) {
            ((CSSImportRuleImpl)it.next()).closeStyleSheet();
        }
        CSSNodeImpl child = oldChild;
        CSSNodeImpl prev = (CSSNodeImpl)child.getPreviousSibling();
        CSSNodeImpl next = (CSSNodeImpl)child.getNextSibling();
        if (prev == null) {
            this.fFirstChild = next;
        } else {
            prev.setNextSibling(next);
        }
        if (next == null) {
            this.fLastChild = prev;
        } else {
            next.setPreviousSibling(prev);
        }
        child.setPreviousSibling(null);
        child.setNextSibling(null);
        child.setParentNode(null);
        this.notifyChildReplaced(null, child);
        return child;
    }

    void removeChildNodes() {
        ICSSNode nextChild = null;
        ICSSNode child = this.getFirstChild();
        while (child != null) {
            nextChild = child.getNextSibling();
            this.removeChild((CSSNodeImpl)child);
            child = nextChild;
        }
    }

    protected CSSNodeImpl replaceChild(CSSNodeImpl newChild, CSSNodeImpl oldChild) throws DOMException {
        if (oldChild == null) {
            return newChild;
        }
        if (newChild != null) {
            this.insertBefore(newChild, oldChild);
        }
        return this.removeChild(oldChild);
    }

    public void setAttribute(String name, String value) {
        if (name == null) {
            return;
        }
        CSSAttrImpl attr = this.getAttributeNode(name);
        if (attr != null) {
            String oldValue = attr.getValue();
            if (value != null && value.equals(oldValue)) {
                return;
            }
            if (value == null) {
                if (oldValue != null) {
                    this.removeAttributeNode(attr);
                }
                return;
            }
        } else {
            CSSDocumentImpl doc;
            if (value == null) {
                return;
            }
            if (this.fAttrs == null) {
                this.fAttrs = new CSSNamedNodeMapImpl();
            }
            if ((doc = (CSSDocumentImpl)this.getOwnerDocument()) == null) {
                return;
            }
            attr = (CSSAttrImpl)doc.createCSSAttr(name);
            attr.setOwnerCSSNode(this);
            this.fAttrs.appendNode(attr);
            this.notifyAttrReplaced(attr, null);
        }
        attr.setValue(value);
    }

    public void setCssText(String cssText) {
        throw new DOMException(13, "");
    }

    private void setNextSibling(ICSSNode nextSibling) {
        this.fNextSibling = (CSSNodeImpl)nextSibling;
    }

    public void setOwnerDocument(ICSSDocument ownerDocument) {
        this.fOwnerDocument = (CSSDocumentImpl)ownerDocument;
    }

    private void setParentNode(ICSSNode parentNode) {
        this.fParentNode = (CSSNodeImpl)parentNode;
    }

    private void setPreviousSibling(ICSSNode previousSibling) {
        this.fPreviousSibling = (CSSNodeImpl)previousSibling;
    }

    public int getLength() {
        int end;
        int result = -1;
        int start = this.getStartOffset();
        if (start >= 0 && (end = this.getEndOffset()) >= 0 && (result = end - start) < -1) {
            result = -1;
        }
        return result;
    }
}

