/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.css.core.internal.document.CSSSelectorCombinator;
import org.eclipse.wst.css.core.internal.document.CSSSelectorParser;
import org.eclipse.wst.css.core.internal.document.CSSSimpleSelector;
import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSelectorAdapter;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelector;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorCombinator;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSelectorItem;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSSimpleSelector;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.xml.core.internal.provisional.NameValidator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class CSSSelector
implements ICSSSelector {
    private int fSpecificity = -1;
    private String fCachedString = null;
    private List fTokens = null;
    private List fItems = null;
    private List fParseErrors = null;
    private List fNameErrors = null;
    static /* synthetic */ Class class$0;

    CSSSelector(List tokens) {
        this.fTokens = new ArrayList(tokens);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CSSSelector foreign = (CSSSelector)obj;
        if (this.getLength() != foreign.getLength()) {
            return false;
        }
        int i = 0;
        while (i < this.getLength()) {
            if (!this.getItem(i).equals(foreign.getItem(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public ICSSSelectorItem getItem(int index) {
        if (this.fItems == null) {
            this.fItems = this.parseSelector(this.fTokens);
        }
        if (this.fItems != null && index >= 0 && index < this.fItems.size()) {
            return (ICSSSelectorItem)this.fItems.get(index);
        }
        return null;
    }

    public Iterator getIterator() {
        if (this.fItems == null) {
            this.fItems = this.parseSelector(this.fTokens);
        }
        return this.fItems != null ? this.fItems.iterator() : null;
    }

    public int getLength() {
        if (this.fItems == null) {
            this.fItems = this.parseSelector(this.fTokens);
        }
        return this.fItems != null ? this.fItems.size() : 0;
    }

    private Element getParentElement(Element element) {
        Node node = element.getParentNode();
        if (node != null && node.getNodeType() == 1) {
            return (Element)node;
        }
        return null;
    }

    private Element getPreviousElement(Element element) {
        Element p = null;
        Node node = element.getPreviousSibling();
        while (node != null) {
            if (node.getNodeType() == 1) {
                p = (Element)node;
                break;
            }
            node = node.getPreviousSibling();
        }
        return p;
    }

    public int getSpecificity() {
        if (this.fSpecificity < 0) {
            int nIDs = 0;
            int nAttributes = 0;
            int nElements = 0;
            Iterator i = this.getIterator();
            while (i.hasNext()) {
                ICSSSelectorItem item = (ICSSSelectorItem)i.next();
                if (!(item instanceof CSSSimpleSelector)) continue;
                CSSSimpleSelector selector = (CSSSimpleSelector)item;
                nIDs += selector.getNumOfIDs();
                nAttributes += selector.getNumOfAttributes();
                nAttributes += selector.getNumOfClasses();
                nAttributes += selector.getNumOfPseudoNames();
                if (selector.isUniversal()) continue;
                ++nElements;
            }
            this.fSpecificity = nIDs * 10000 + nAttributes * 100 + nElements;
        }
        return this.fSpecificity;
    }

    public String getString() {
        if (this.fCachedString == null) {
            StringBuffer buf = new StringBuffer();
            Iterator i = this.getIterator();
            while (i.hasNext()) {
                ICSSSelectorItem item = (ICSSSelectorItem)i.next();
                if (item instanceof CSSSelectorCombinator) {
                    if (((CSSSelectorCombinator)item).getCombinatorType() != ' ') {
                        buf.append(" ");
                        buf.append(item.getString());
                    }
                    buf.append(" ");
                    continue;
                }
                buf.append(item.getString());
            }
            this.fCachedString = buf.toString();
        }
        return this.fCachedString;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public boolean match(Element element, String pseudoName) {
        Element target = element;
        int combinatorType = 63;
        Element chunkStartElement = null;
        int chunkStartItem = -1;
        int numItems = this.getLength();
        int iItem = numItems - 1;
        while (iItem >= 0) {
            block15: {
                ICSSSelectorItem item;
                block16: {
                    block14: {
                        item = this.getItem(iItem);
                        if (!(item instanceof ICSSSimpleSelector)) break block14;
                        if (target == null) {
                            return false;
                        }
                        if (this.matchExactly((ICSSSimpleSelector)item, target, pseudoName)) break block15;
                        switch (combinatorType) {
                            case 32: {
                                break block16;
                            }
                            case 43: 
                            case 62: {
                                if (chunkStartElement == null) return false;
                                if (chunkStartElement == element) return false;
                                target = this.getParentElement(chunkStartElement);
                                iItem = chunkStartItem + 1;
                                chunkStartElement = null;
                                chunkStartItem = -1;
                                break block15;
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    if (!(item instanceof ICSSSelectorCombinator)) return false;
                    if (iItem == numItems - 1) {
                        return false;
                    }
                    ICSSSelectorCombinator sc = (ICSSSelectorCombinator)item;
                    combinatorType = sc.getCombinatorType();
                    switch (combinatorType) {
                        case 32: {
                            target = this.getParentElement(target);
                            break;
                        }
                        case 43: 
                        case 62: {
                            if (chunkStartElement == null) {
                                chunkStartElement = target;
                                chunkStartItem = iItem + 1;
                            }
                            if (combinatorType == 62) {
                                target = this.getParentElement(target);
                                break;
                            }
                            target = this.getPreviousElement(target);
                        }
                    }
                    break block15;
                }
                do {
                    if ((target = this.getParentElement(target)) != null) continue;
                    return false;
                } while (!this.matchExactly((ICSSSimpleSelector)item, target, pseudoName));
            }
            --iItem;
        }
        return true;
    }

    private boolean matchExactly(ICSSSimpleSelector selector, Element element, String pseudoName) {
        StringTokenizer tokenizer;
        String key;
        IStyleSelectorAdapter adapter;
        INodeNotifier iNodeNotifier = (INodeNotifier)((Object)element);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSelectorAdapter");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((adapter = (IStyleSelectorAdapter)iNodeNotifier.getAdapterFor(clazz)) != null) {
            return adapter.match(selector, element, pseudoName);
        }
        if (element == null) {
            return false;
        }
        if (!selector.isUniversal() && !element.getNodeName().equals(selector.getName())) {
            return false;
        }
        int i = selector.getNumOfIDs();
        if (i > 0) {
            if (i > 1) {
                return false;
            }
            if (!element.hasAttribute("id") || (key = element.getAttribute("id")).length() == 0) {
                return false;
            }
            if (!selector.getID(0).equals(key)) {
                return false;
            }
        }
        if ((i = selector.getNumOfClasses()) > 0) {
            if (!element.hasAttribute("class") || (key = element.getAttribute("class")).length() == 0) {
                return false;
            }
            tokenizer = new StringTokenizer(key);
            --i;
            while (i >= 0) {
                boolean ok = false;
                while (tokenizer.hasMoreTokens()) {
                    if (!selector.getClass(i).equals(tokenizer.nextToken())) continue;
                    ok = true;
                    break;
                }
                if (!ok) {
                    return false;
                }
                --i;
            }
        }
        i = selector.getNumOfAttributes() - 1;
        while (i >= 0) {
            tokenizer = new StringTokenizer(selector.getAttribute(i), "=~| \t\r\n\f");
            int countTokens = tokenizer.countTokens();
            if (countTokens > 0) {
                String attrName = tokenizer.nextToken();
                String attrValue = null;
                if (!element.hasAttribute(attrName) || (attrValue = element.getAttribute(attrName)).length() == 0) {
                    return false;
                }
                if (countTokens > 1) {
                    String token = tokenizer.nextToken("= \t\r\n\f");
                    StringTokenizer attrValueTokenizer = null;
                    if (token.equals("~")) {
                        attrValueTokenizer = new StringTokenizer(attrValue);
                    } else if (token.equals("|")) {
                        attrValueTokenizer = new StringTokenizer(attrValue, "-");
                    }
                    if (attrValueTokenizer != null) {
                        if (tokenizer.hasMoreTokens()) {
                            token = tokenizer.nextToken();
                            boolean ok = false;
                            while (attrValueTokenizer.hasMoreTokens()) {
                                if (!token.equals(attrValueTokenizer.nextToken())) continue;
                                ok = true;
                                break;
                            }
                            if (!ok) {
                                return false;
                            }
                        }
                    } else if (!attrValue.equals(token)) {
                        return false;
                    }
                }
            }
            --i;
        }
        return true;
    }

    private List parseSelector(List tokens) {
        CSSSelectorParser parser = new CSSSelectorParser(tokens);
        List selector = parser.getSelector();
        Iterator i = parser.getErrors();
        this.fParseErrors = new ArrayList();
        while (i.hasNext()) {
            this.fParseErrors.add(i.next());
        }
        return selector;
    }

    public Iterator getErrors() {
        if (this.fNameErrors == null) {
            this.fNameErrors = new ArrayList();
            Iterator iItem = this.getIterator();
            while (iItem.hasNext()) {
                String name;
                ICSSSelectorItem item = (ICSSSelectorItem)iItem.next();
                if (!(item instanceof ICSSSimpleSelector) || ((ICSSSimpleSelector)item).isUniversal() || NameValidator.isValid(name = ((ICSSSimpleSelector)item).getName())) continue;
                this.fNameErrors.add(item);
            }
        }
        ArrayList errors = new ArrayList(this.fParseErrors);
        errors.addAll(this.fNameErrors);
        return errors.iterator();
    }

    public String toString() {
        return this.getString();
    }

    public int getErrorCount() {
        int nErrors = 0;
        Iterator i = this.getErrors();
        while (i.hasNext()) {
            ++nErrors;
            i.next();
        }
        return nErrors;
    }
}

