/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.document;

import org.eclipse.wst.css.core.internal.document.CSSNodeImpl;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;

public abstract class CSSStructuredDocumentRegionContainer
extends CSSNodeImpl {
    private IStructuredDocumentRegion firstStructuredDocumentRegion = null;
    private IStructuredDocumentRegion lastStructuredDocumentRegion = null;

    public CSSStructuredDocumentRegionContainer() {
    }

    public CSSStructuredDocumentRegionContainer(CSSStructuredDocumentRegionContainer that) {
        super(that);
    }

    public String getCssText() {
        if (this.getFirstStructuredDocumentRegion() == null) {
            return this.generateSource();
        }
        StringBuffer str = new StringBuffer(this.getFirstStructuredDocumentRegion().getText());
        IStructuredDocumentRegion node = this.getFirstStructuredDocumentRegion();
        while (node != this.getLastStructuredDocumentRegion()) {
            node = node.getNext();
            str.append(node.getText());
        }
        return str.toString();
    }

    public int getEndOffset() {
        IStructuredDocumentRegion flatNode = this.getLastStructuredDocumentRegion();
        if (flatNode != null) {
            return flatNode.getEnd();
        }
        return -1;
    }

    IStructuredDocumentRegion getFirstStructuredDocumentRegion() {
        return this.firstStructuredDocumentRegion;
    }

    IStructuredDocumentRegion getStructuredDocumentRegion(int index) {
        IStructuredDocumentRegion node = this.firstStructuredDocumentRegion;
        int i = index;
        while (i > 0) {
            if (node == null) {
                return null;
            }
            node = node.getNext();
            --i;
        }
        return node;
    }

    int getStructuredDocumentRegionCount() {
        if (this.firstStructuredDocumentRegion == null) {
            return 0;
        }
        IStructuredDocumentRegion node = this.firstStructuredDocumentRegion;
        int i = 0;
        while (node != null) {
            node = node.getNext();
            ++i;
        }
        return i;
    }

    IStructuredDocumentRegion getLastStructuredDocumentRegion() {
        return this.lastStructuredDocumentRegion;
    }

    public int getStartOffset() {
        IStructuredDocumentRegion flatNode = this.getFirstStructuredDocumentRegion();
        if (flatNode != null) {
            return flatNode.getStart();
        }
        return -1;
    }

    boolean includeRangeStructuredDocumentRegion(IStructuredDocumentRegion first, IStructuredDocumentRegion last) {
        boolean b;
        boolean bModified = false;
        if (first != null && last != null && first.getStart() > last.getStart()) {
            IStructuredDocumentRegion node = first;
            first = last;
            last = node;
        }
        boolean bl = bModified = (b = this.validateRange()) || bModified;
        if (first != null && (this.getFirstStructuredDocumentRegion() == null || this.getFirstStructuredDocumentRegion().getStart() > first.getStart())) {
            this.setFirstStructuredDocumentRegion(first);
            bModified = true;
        }
        if (last != null && (this.getLastStructuredDocumentRegion() == null || this.getLastStructuredDocumentRegion().getStart() < last.getStart())) {
            this.setLastStructuredDocumentRegion(last);
            bModified = true;
        }
        if (bModified) {
            this.validateRange();
        }
        return bModified;
    }

    public boolean propagateRangeStructuredDocumentRegion() {
        boolean bModified = false;
        CSSStructuredDocumentRegionContainer parent = (CSSStructuredDocumentRegionContainer)this.getParentNode();
        if (parent == null) {
            return bModified;
        }
        boolean b = parent.includeRangeStructuredDocumentRegion(this.getFirstStructuredDocumentRegion(), this.getLastStructuredDocumentRegion());
        boolean bl = bModified = b || bModified;
        if (b) {
            parent.propagateRangeStructuredDocumentRegion();
        }
        return bModified;
    }

    public void setCssText(String cssText) {
        if (this.firstStructuredDocumentRegion != null) {
            this.getOwnerDocument().getModel().getStructuredDocument().replaceText(this, this.getStartOffset(), this.getEndOffset() - this.getStartOffset(), cssText);
        } else {
            super.setCssText(cssText);
        }
    }

    IStructuredDocumentRegion setFirstStructuredDocumentRegion(IStructuredDocumentRegion node) {
        this.firstStructuredDocumentRegion = node;
        return node;
    }

    IStructuredDocumentRegion setLastStructuredDocumentRegion(IStructuredDocumentRegion node) {
        this.lastStructuredDocumentRegion = node;
        return node;
    }

    public void setRangeStructuredDocumentRegion(IStructuredDocumentRegion firstNode, IStructuredDocumentRegion lastNode) {
        if (firstNode != null) {
            this.setFirstStructuredDocumentRegion(firstNode);
        }
        if (lastNode != null) {
            this.setLastStructuredDocumentRegion(lastNode);
        }
        if (firstNode == null && lastNode == null) {
            this.setFirstStructuredDocumentRegion(null);
            this.setLastStructuredDocumentRegion(null);
        } else {
            this.validateRange();
        }
    }

    private boolean validateRange() {
        boolean bModified = false;
        if (this.firstStructuredDocumentRegion != null || this.lastStructuredDocumentRegion != null) {
            if (this.firstStructuredDocumentRegion == null) {
                this.firstStructuredDocumentRegion = this.lastStructuredDocumentRegion;
                bModified = true;
            } else if (this.lastStructuredDocumentRegion == null) {
                this.lastStructuredDocumentRegion = this.firstStructuredDocumentRegion;
                bModified = true;
            } else if (this.firstStructuredDocumentRegion.getStart() > this.lastStructuredDocumentRegion.getStart()) {
                IStructuredDocumentRegion node = this.firstStructuredDocumentRegion;
                this.firstStructuredDocumentRegion = this.lastStructuredDocumentRegion;
                this.lastStructuredDocumentRegion = node;
                bModified = true;
            }
        }
        return bModified;
    }
}

