/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.formatter.AbstractCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;

public class DefaultCSSSourceFormatter
extends AbstractCSSSourceFormatter {
    DefaultCSSSourceFormatter() {
    }

    protected void appendSpaceBetween(ICSSNode node, CompoundRegion prev, CompoundRegion next, StringBuffer source) {
        if (DefaultCSSSourceFormatter.isCleanup() && !this.getCleanupStrategy(node).isFormatSource()) {
            return;
        }
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        String prevType = prev.getType();
        String nextType = next.getType();
        if (prevType == "PAGE" || prevType == "CHARSET" || prevType == "ATKEYWORD" || prevType == "FONT_FACE" || prevType == "IMPORT" || prevType == "MEDIA") {
            this.appendSpaceBefore(node, next, source);
            return;
        }
        if (prevType == "UNKNOWN" && nextType != "COMMENT") {
            if (prev.getEndOffset() != next.getStartOffset()) {
                this.appendSpaceBefore(node, next, source);
            }
            return;
        }
        if (prevType == "DECLARATION_VALUE_OPERATOR" || prevType == "COMMENT" || nextType == "COMMENT" || nextType == "LBRACE" || nextType == "UNKNOWN" || prevType == "SELECTOR_SEPARATOR" && preferences.getBoolean("spaceBetweenSelectors")) {
            this.appendSpaceBefore(node, next, source);
            return;
        }
    }

    protected void formatBefore(ICSSNode node, ICSSNode child, String toAppend, StringBuffer source, IRegion exceptFor) {
    }

    protected void formatBefore(ICSSNode node, ICSSNode child, IRegion region, String toAppend, StringBuffer source) {
    }

    protected void formatPost(ICSSNode node, StringBuffer source) {
    }

    protected void formatPost(ICSSNode node, IRegion region, StringBuffer source) {
    }

    protected void formatPre(ICSSNode node, StringBuffer source) {
    }

    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
    }

    public int getChildInsertPos(ICSSNode node) {
        int n = ((IndexedRegion)((Object)node)).getEndOffset();
        if (n > 0) {
            return n;
        }
        return -1;
    }
}

