/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.css.core.internal.formatter;

import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IRegion;
import org.eclipse.wst.css.core.internal.CSSCorePlugin;
import org.eclipse.wst.css.core.internal.cleanup.CSSCleanupStrategy;
import org.eclipse.wst.css.core.internal.formatter.CompoundRegion;
import org.eclipse.wst.css.core.internal.formatter.DefaultCSSSourceFormatter;
import org.eclipse.wst.css.core.internal.formatter.FormatRegion;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSNode;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSPrimitiveValue;
import org.eclipse.wst.css.core.internal.provisional.document.ICSSStyleDeclItem;
import org.eclipse.wst.css.core.internal.util.CSSUtil;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;

public class PrimitiveValueFormatter
extends DefaultCSSSourceFormatter {
    private static PrimitiveValueFormatter instance;

    PrimitiveValueFormatter() {
    }

    protected void formatPre(ICSSNode node, StringBuffer source) {
        int start = ((IndexedRegion)((Object)node)).getStartOffset();
        int end = ((IndexedRegion)((Object)node)).getEndOffset();
        Preferences preferences = CSSCorePlugin.getDefault().getPluginPreferences();
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        if (end > 0) {
            IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
            CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, new FormatRegion(start, end - start), stgy);
            boolean appendQuote = regions.length > 1 && node.getParentNode() instanceof ICSSStyleDeclItem && PrimitiveValueFormatter.isCleanup() && this.getCleanupStrategy(node).isQuoteValues() && (((ICSSStyleDeclItem)node.getParentNode()).getPropertyName().equals("font") || ((ICSSStyleDeclItem)node.getParentNode()).getPropertyName().equals("font-family") || ((ICSSStyleDeclItem)node.getParentNode()).getPropertyName().equals("voice-family"));
            String quote = preferences.getString("quote");
            StringBuffer strBuf = new StringBuffer();
            boolean skipSpace = false;
            int i = 0;
            while (i < regions.length) {
                if (i != 0 && !skipSpace) {
                    this.appendSpaceBefore(node, regions[i], strBuf);
                }
                skipSpace = false;
                strBuf.append(this.decoratedPropValueRegion(regions[i], stgy));
                if (regions[i].getType() == "DECLARATION_VALUE_FUNCTION") {
                    skipSpace = true;
                }
                ++i;
            }
            if (appendQuote) {
                source.append(quote);
                String str = strBuf.toString();
                str = str.replace('\'', ' ');
                str = str.replace('\"', ' ');
                str = str.trim();
                source.append(str);
                source.append(quote);
            } else {
                source.append(strBuf);
            }
        } else {
            ICSSPrimitiveValue value = (ICSSPrimitiveValue)node;
            short type = value.getPrimitiveType();
            String quote = preferences.getString("quote");
            String str = null;
            switch (type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: 
                case 26: {
                    if (value.getFloatValue(type) == (float)((int)value.getFloatValue(type))) {
                        str = Integer.toString((int)value.getFloatValue(type));
                        break;
                    }
                    str = Float.toString(value.getFloatValue(type));
                    break;
                }
                case 21: 
                case 27: 
                case 33: {
                    str = value.getStringValue();
                    if (str == null) break;
                    if (preferences.getInt("propValueCase") == 2) {
                        str = str.toUpperCase();
                        break;
                    }
                    str.toLowerCase();
                    break;
                }
                case 19: 
                case 20: 
                case 22: 
                case 28: 
                case 29: 
                case 30: 
                case 31: 
                case 32: {
                    str = value.getStringValue();
                }
            }
            String preStr = null;
            String postStr = null;
            switch (type) {
                case 22: {
                    preStr = "attr(";
                    postStr = ")";
                    break;
                }
                case 6: {
                    postStr = "cm";
                    break;
                }
                case 11: {
                    postStr = "deg";
                    break;
                }
                case 3: {
                    postStr = "em";
                    break;
                }
                case 4: {
                    postStr = "ex";
                    break;
                }
                case 13: {
                    postStr = "grad";
                    break;
                }
                case 16: {
                    postStr = "Hz";
                    break;
                }
                case 8: {
                    postStr = "in";
                    break;
                }
                case 17: {
                    postStr = "kHz";
                    break;
                }
                case 7: {
                    postStr = "mm";
                    break;
                }
                case 14: {
                    postStr = "ms";
                    break;
                }
                case 10: {
                    postStr = "pc";
                    break;
                }
                case 2: {
                    postStr = "%";
                    break;
                }
                case 9: {
                    postStr = "pt";
                    break;
                }
                case 5: {
                    postStr = "px";
                    break;
                }
                case 12: {
                    postStr = "rad";
                    break;
                }
                case 15: {
                    postStr = "s";
                    break;
                }
                case 19: {
                    preStr = quote = CSSUtil.detectQuote(str, quote);
                    postStr = quote;
                    break;
                }
                case 20: {
                    quote = CSSUtil.detectQuote(str, quote);
                    preStr = "url(" + quote;
                    postStr = String.valueOf(quote) + ")";
                    break;
                }
                case 0: 
                case 1: 
                case 18: 
                case 21: 
                case 26: 
                case 27: 
                case 31: 
                case 32: 
                case 33: {
                    break;
                }
                case 28: {
                    preStr = "U+";
                    break;
                }
                case 29: {
                    quote = CSSUtil.detectQuote(str, quote);
                    preStr = "format(" + quote;
                    postStr = String.valueOf(quote) + ")";
                    break;
                }
                case 30: {
                    quote = CSSUtil.detectQuote(str, quote);
                    preStr = "local(" + quote;
                    postStr = String.valueOf(quote) + ")";
                }
            }
            if (preferences.getInt("propValueCase") == 2) {
                if (preStr != null) {
                    preStr = preStr.toUpperCase();
                }
                if (postStr != null) {
                    postStr = postStr.toUpperCase();
                }
            }
            if (preStr != null) {
                source.append(preStr);
            }
            if (str != null) {
                source.append(str);
            }
            if (postStr != null) {
                source.append(postStr);
            }
        }
    }

    protected void formatPre(ICSSNode node, IRegion region, StringBuffer source) {
        CSSCleanupStrategy stgy = this.getCleanupStrategy(node);
        IStructuredDocument structuredDocument = node.getOwnerDocument().getModel().getStructuredDocument();
        CompoundRegion[] regions = this.getRegionsWithoutWhiteSpaces(structuredDocument, region, stgy);
        CompoundRegion[] outside = this.getOutsideRegions(structuredDocument, region);
        int i = 0;
        while (i < regions.length) {
            if (i != 0 || PrimitiveValueFormatter.needS(outside[0])) {
                this.appendSpaceBefore(node, regions[i], source);
            }
            source.append(this.decoratedPropValueRegion(regions[i], stgy));
            ++i;
        }
        if (PrimitiveValueFormatter.needS(outside[1]) && !this.isIncludesPreEnd(node, region)) {
            this.appendSpaceBefore(node, outside[1], source);
        }
    }

    public static synchronized PrimitiveValueFormatter getInstance() {
        if (instance == null) {
            instance = new PrimitiveValueFormatter();
        }
        return instance;
    }
}

