/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import java.util.ArrayList;
import org.eclipse.wst.dtd.core.internal.Attribute;
import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.NamedTopLevelNode;
import org.eclipse.wst.dtd.core.internal.text.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class AttributeList
extends NamedTopLevelNode {
    public AttributeList(DTDFile file, IStructuredDocumentRegion flatNode) {
        super(file, flatNode, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ATTLIST_TAG");
    }

    public void addAttribute(String name) {
        this.beginRecording(this, DTDCoreMessages._UI_LABEL_ATTR_LIST_ADD);
        DTDNode lastAttribute = (DTDNode)this.getLastChild();
        if (lastAttribute != null) {
            this.replaceText(this, lastAttribute.getEndOffset(), 0, "\n\t" + name + " CDATA #IMPLIED");
        } else {
            ITextRegion nameRegion = this.getNameRegion();
            if (nameRegion != null) {
                this.replaceText(this, this.getStructuredDTDDocumentRegion().getEndOffset(nameRegion), 0, "\n\t" + name + " CDATA #IMPLIED");
            }
        }
        this.endRecording(this);
    }

    public String getImagePath() {
        return "icons/full/obj16/attribute_list.gif";
    }

    public void insertIntoModel(Object requestor, Attribute reference, Attribute node, boolean isAfter) {
        Attribute attr;
        int offset = 0;
        String newText = "";
        String nodeText = node.getFullNodeText();
        offset = !isAfter ? reference.getStartOffset() : ((attr = (Attribute)reference.getNextSibling()) != null ? attr.getStartOffset() : reference.getWhitespaceEndOffset());
        newText = String.valueOf(newText) + nodeText;
        if (!node.hasTrailingWhitespace()) {
            newText = String.valueOf(newText) + "\n\t";
        }
        this.replaceText(requestor, offset, 0, newText);
    }

    public void resolveRegions() {
        this.removeChildNodes();
        RegionIterator iter = this.iterator();
        if (this.getNameRegion() != null) {
            this.skipPastName(iter);
        }
        ArrayList<Attribute> children = new ArrayList<Attribute>();
        Attribute attribute = null;
        boolean trailingWhitespace = false;
        while (iter.hasNext()) {
            ITextRegion currentRegion = iter.next();
            if (currentRegion.getType().equals("org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.ATTRIBUTE_NAME")) {
                attribute = new Attribute(this.getDTDFile(), this.getStructuredDTDDocumentRegion());
                children.add(attribute);
                this.appendChild(attribute);
                trailingWhitespace = false;
            }
            if (attribute == null || currentRegion.getType() == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.END_TAG") continue;
            if (!trailingWhitespace) {
                attribute.addRegion(currentRegion);
            } else if (currentRegion.getType() == "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.WHITESPACE") {
                attribute.addWhitespaceRegion(currentRegion);
            }
            if (currentRegion.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.REQUIRED_KEYWORD" && currentRegion.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.IMPLIED_KEYWORD" && currentRegion.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.SINGLEQUOTED_LITERAL" && currentRegion.getType() != "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.DOUBLEQUOTED_LITERAL") continue;
            trailingWhitespace = true;
        }
        int numKids = children.size();
        int i = 0;
        while (i < numKids) {
            ((Attribute)children.get(i)).resolveRegions();
            ++i;
        }
    }
}

