/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal;

import org.eclipse.wst.dtd.core.internal.DTDCoreMessages;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.NamedTopLevelNode;
import org.eclipse.wst.dtd.core.internal.text.RegionIterator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;

public class Comment
extends NamedTopLevelNode {
    public Comment(DTDFile file, IStructuredDocumentRegion flatNode) {
        super(file, flatNode, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.COMMENT");
    }

    public String getImagePath() {
        return "icons/full/obj16/comment.gif";
    }

    public String getName() {
        String text = this.getText();
        if (text.length() <= 30) {
            return text;
        }
        return String.valueOf(text.substring(0, 29)) + "...";
    }

    private void getStartAndEndOffsetForText(StartEndPair pair) {
        RegionIterator iter = this.iterator();
        ITextRegion commentStartTag = this.getStartTag(iter);
        ITextRegion endCommentTag = this.getNextRegion(iter, "org.eclipse.wst.dtd.core.internal.util.parser.DTDRegionTypes.COMMENT_END");
        pair.endOffset = this.getStructuredDTDDocumentRegion().getEndOffset();
        if (commentStartTag != null) {
            pair.startOffset = this.getStructuredDTDDocumentRegion().getEndOffset(commentStartTag);
        }
        if (endCommentTag != null) {
            pair.endOffset = this.getStructuredDTDDocumentRegion().getStartOffset(endCommentTag);
        }
    }

    public String getText() {
        String text = this.getStructuredDTDDocumentRegion().getText();
        int flatNodeStart = this.getStructuredDTDDocumentRegion().getStartOffset();
        StartEndPair pair = new StartEndPair();
        this.getStartAndEndOffsetForText(pair);
        return text.substring(pair.startOffset - flatNodeStart, pair.endOffset - flatNodeStart);
    }

    public void setText(String newText) {
        this.beginRecording(this, DTDCoreMessages._UI_LABEL_COMMENT_CHG);
        StartEndPair pair = new StartEndPair();
        this.getStartAndEndOffsetForText(pair);
        this.replaceText(this, pair.startOffset, pair.endOffset - pair.startOffset, newText);
        this.endRecording(this);
    }

    public class StartEndPair {
        public int startOffset;
        public int endOffset;
    }
}

