/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.util;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.dtd.core.internal.Attribute;
import org.eclipse.wst.dtd.core.internal.AttributeList;
import org.eclipse.wst.dtd.core.internal.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.DTDNode;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.core.internal.ParameterEntityReference;
import org.eclipse.wst.dtd.core.internal.util.DTDVisitor;

public class DTDModelUpdater
extends DTDVisitor {
    protected boolean isParmEntity = false;
    protected boolean isUpdating = false;
    protected List nodesToDelete = new ArrayList();
    protected DTDNode nodeToDelete;
    protected String oldRefName = "";
    protected Object requestor;

    public synchronized void objectAboutToBeDeleted(Object requestor, DTDNode node) {
        if (this.isUpdating) {
            return;
        }
        if (!(node instanceof Entity) && !(node instanceof Element)) {
            return;
        }
        if (node instanceof Entity && !((Entity)node).isParameterEntity()) {
            return;
        }
        this.isUpdating = true;
        this.requestor = requestor;
        this.nodeToDelete = node;
        this.oldRefName = node.getName();
        this.isParmEntity = false;
        this.nodesToDelete.clear();
        if (node instanceof Entity) {
            this.isParmEntity = true;
            this.oldRefName = "%" + this.oldRefName + ";";
        }
        DTDFile dtdFile = node.getDTDFile();
        this.visit(dtdFile);
        int i = 0;
        while (i < this.nodesToDelete.size()) {
            dtdFile.deleteNode(requestor, (DTDNode)this.nodesToDelete.get(i));
            ++i;
        }
        this.isUpdating = false;
    }

    public void visitAttribute(Attribute attr) {
        super.visitAttribute(attr);
        if (this.isParmEntity) {
            if (attr.getName().equals(this.oldRefName)) {
                attr.setName(this.requestor, "TempName");
            }
            if (attr.getType().equals(this.oldRefName)) {
                attr.setType(this.requestor, Attribute.CDATA);
            }
        }
    }

    public void visitAttributeList(AttributeList attList) {
        super.visitAttributeList(attList);
        if (attList.getName().equals(this.oldRefName)) {
            if (this.isParmEntity) {
                attList.setName(this.requestor, "TempName");
            } else {
                this.nodesToDelete.add(attList);
            }
        }
    }

    public void visitElement(Element element) {
        if (this.isParmEntity && element.getName().equals(this.oldRefName)) {
            element.setName(this.requestor, "TempName");
        }
        super.visitElement(element);
    }

    public void visitExternalParameterEntityReference(ParameterEntityReference parmEntityRef) {
        super.visitExternalParameterEntityReference(parmEntityRef);
        if (this.isParmEntity && parmEntityRef.getName().equals(this.oldRefName)) {
            this.nodesToDelete.add(parmEntityRef);
        }
    }

    public void visitReference(CMBasicNode node) {
        super.visitReference(node);
        if (node.getName().equals(this.oldRefName)) {
            DTDNode parent = (DTDNode)node.getParentNode();
            parent.delete(this.requestor, node);
        }
    }
}

