/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.dtd.core.internal.util;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.wst.dtd.core.internal.Attribute;
import org.eclipse.wst.dtd.core.internal.CMBasicNode;
import org.eclipse.wst.dtd.core.internal.DTDFile;
import org.eclipse.wst.dtd.core.internal.Element;
import org.eclipse.wst.dtd.core.internal.Entity;
import org.eclipse.wst.dtd.core.internal.Notation;

public class DTDUniqueNameHelper {
    public static String getName(Object obj) {
        if (obj instanceof Element) {
            return ((Element)obj).getName();
        }
        if (obj instanceof Entity) {
            return ((Entity)obj).getName();
        }
        if (obj instanceof Notation) {
            return ((Notation)obj).getName();
        }
        if (obj instanceof Attribute) {
            return ((Attribute)obj).getName();
        }
        if (obj instanceof CMBasicNode) {
            return ((CMBasicNode)obj).getName();
        }
        return "";
    }

    public static String getUniqueAttributeName(Element element) {
        List attrs = element.getElementAttributes();
        return DTDUniqueNameHelper.getUniqueName(attrs, "NewAttribute");
    }

    public static String getUniqueElementName(DTDFile dtdFile) {
        ArrayList elements = dtdFile.getElementsAndParameterEntityReferences().getNodes();
        return DTDUniqueNameHelper.getUniqueName(elements, "NewElement");
    }

    public static String getUniqueEntityName(DTDFile dtdFile) {
        ArrayList entities = dtdFile.getEntities().getNodes();
        return DTDUniqueNameHelper.getUniqueName(entities, "NewEntity");
    }

    public static String getUniqueName(List objs, String token) {
        int counter = 1;
        boolean uniqueName = false;
        while (!uniqueName) {
            String newName = String.valueOf(token) + new Integer(counter++);
            uniqueName = true;
            Iterator iter = objs.iterator();
            while (iter.hasNext()) {
                Object obj = iter.next();
                String objName = DTDUniqueNameHelper.getName(obj);
                if (!objName.equals(newName)) continue;
                uniqueName = false;
                break;
            }
            if (!uniqueName) continue;
            return newName;
        }
        return "No Name found";
    }

    public static String getUniqueNotationName(DTDFile dtdFile) {
        ArrayList notations = dtdFile.getNotations().getNodes();
        return DTDUniqueNameHelper.getUniqueName(notations, "NewNotation");
    }
}

