/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.document;

import org.eclipse.wst.css.core.internal.provisional.adapters.IStyleSheetListAdapter;
import org.eclipse.wst.html.core.internal.document.ElementStyleImpl;
import org.eclipse.wst.html.core.internal.parser.NameValidator;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.xml.core.internal.document.DocumentImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.DocumentCSS;
import org.w3c.dom.stylesheets.StyleSheetList;

public class DocumentStyleImpl
extends DocumentImpl
implements IDOMDocument,
DocumentCSS {
    public DocumentStyleImpl() {
    }

    protected DocumentStyleImpl(DocumentImpl that) {
        super(that);
    }

    public CSSStyleDeclaration getOverrideStyle(Element element, String pseudoName) {
        INodeAdapter adapter = this.getAdapterFor(IStyleSheetListAdapter.class);
        if (adapter == null) {
            return null;
        }
        return ((IStyleSheetListAdapter)adapter).getOverrideStyle(element, pseudoName);
    }

    public StyleSheetList getStyleSheets() {
        INodeAdapter adapter = this.getAdapterFor(IStyleSheetListAdapter.class);
        if (adapter == null) {
            return null;
        }
        return ((IStyleSheetListAdapter)adapter).getStyleSheets();
    }

    protected boolean isValidName(String name) {
        if (name == null || name.length() == 0) {
            return false;
        }
        if (NameValidator.isValid(name)) {
            return true;
        }
        if (name.length() == 1 && name.charAt(0) == '!') {
            return true;
        }
        if (name.startsWith("<%")) {
            return true;
        }
        return name.indexOf(61) < 0;
    }

    protected void releaseStyleSheets() {
        INodeAdapter adapter = this.getExistingAdapter(IStyleSheetListAdapter.class);
        if (adapter == null) {
            return;
        }
        ((IStyleSheetListAdapter)adapter).releaseStyleSheets();
    }

    public Element createElement(String tagName) throws DOMException {
        this.checkTagNameValidity(tagName);
        ElementStyleImpl element = new ElementStyleImpl();
        element.setOwnerDocument(this);
        element.setTagName(tagName);
        return element;
    }

    public Node cloneNode(boolean deep) {
        DocumentStyleImpl cloned = new DocumentStyleImpl(this);
        if (deep) {
            cloned.importChildNodes(this, true);
        }
        return cloned;
    }

    protected void setModel(IDOMModel model) {
        super.setModel(model);
    }
}

