/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.document;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.html.core.internal.cleanup.HTMLCleanupProcessorImpl;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeEntry;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeRegistry;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.cleanup.IStructuredCleanupPreferences;
import org.eclipse.wst.sse.core.internal.provisional.IModelManager;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocumentType;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class HTMLConverter {
    public void cleanupModel(IDOMModel model) {
        if (model == null) {
            return;
        }
        HTMLCleanupProcessorImpl processor = new HTMLCleanupProcessorImpl();
        IStructuredCleanupPreferences pref = processor.getCleanupPreferences();
        boolean compressEmptyElementTags = pref.getCompressEmptyElementTags();
        boolean insertRequiredAttrs = pref.getInsertRequiredAttrs();
        boolean insertMissingTags = pref.getInsertMissingTags();
        boolean quoteAttrValues = pref.getQuoteAttrValues();
        boolean formatSource = pref.getFormatSource();
        int tagNameCase = pref.getTagNameCase();
        int attrNameCase = pref.getAttrNameCase();
        pref.setCompressEmptyElementTags(true);
        pref.setInsertRequiredAttrs(true);
        pref.setInsertMissingTags(true);
        pref.setQuoteAttrValues(true);
        pref.setFormatSource(false);
        if (model.getDocument().isXMLType()) {
            pref.setTagNameCase(1);
            pref.setAttrNameCase(1);
        } else {
            pref.setTagNameCase(0);
            pref.setAttrNameCase(0);
        }
        processor.cleanupModel(model);
        pref.setCompressEmptyElementTags(compressEmptyElementTags);
        pref.setInsertRequiredAttrs(insertRequiredAttrs);
        pref.setInsertMissingTags(insertMissingTags);
        pref.setQuoteAttrValues(quoteAttrValues);
        pref.setFormatSource(formatSource);
        pref.setTagNameCase(tagNameCase);
        pref.setAttrNameCase(attrNameCase);
    }

    public void convert(IDOMModel model, String declaration, String publicId) {
        if (model == null) {
            return;
        }
        this.setDeclaration(model, declaration, publicId);
        this.cleanupModel(model);
    }

    public void convert(InputStream input, OutputStream output, String declaration, String publicId) throws UnsupportedEncodingException, IOException, CoreException {
        IDOMModel model = this.readModel(input);
        if (model == null) {
            return;
        }
        try {
            this.convert(model, declaration, publicId);
            this.writeModel(model, output);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    public void convert(IFile file, String declaration, String publicId) throws IOException, CoreException {
        IDOMModel model = this.readModel(file);
        if (model == null) {
            return;
        }
        try {
            this.convert(model, declaration, publicId);
            this.writeModel(model, file);
        }
        finally {
            if (model != null) {
                model.releaseFromEdit();
            }
        }
    }

    private static void insertBreak(IDOMModel model, Node node) {
        if (model == null || node == null) {
            return;
        }
        if (node.getNodeType() == 3) {
            return;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        String delim = structuredDocument.getLineDelimiter();
        if (delim == null || delim.length() == 0) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        Document document = node.getOwnerDocument();
        if (document == null) {
            return;
        }
        Text text = document.createTextNode(delim);
        parent.insertBefore(text, node);
    }

    private IDOMModel readModel(InputStream input) throws IOException, UnsupportedEncodingException {
        if (input == null) {
            return null;
        }
        String id = String.valueOf(input.toString()) + ".html";
        IModelManager manager = StructuredModelManager.getModelManager();
        IStructuredModel model = manager.getModelForEdit(id, input, null);
        if (!(model instanceof IDOMModel)) {
            if (model != null) {
                model.releaseFromEdit();
            }
            return null;
        }
        return (IDOMModel)model;
    }

    private IDOMModel readModel(IFile file) throws IOException, CoreException {
        if (file == null) {
            return null;
        }
        IModelManager manager = StructuredModelManager.getModelManager();
        IStructuredModel model = manager.getModelForEdit(file);
        if (!(model instanceof IDOMModel)) {
            if (model != null) {
                model.releaseFromEdit();
            }
            return null;
        }
        return (IDOMModel)model;
    }

    public void setDeclaration(IDOMModel model, String declaration, String publicId) {
        if (model == null) {
            return;
        }
        IDOMDocument document = model.getDocument();
        if (document == null) {
            return;
        }
        try {
            String target;
            model.aboutToChangeModel();
            ProcessingInstruction pi = null;
            Node child = document.getFirstChild();
            if (child != null && child.getNodeType() == 7 && (target = child.getNodeName()) != null && target.equals("xml")) {
                pi = (ProcessingInstruction)child;
                child = child.getNextSibling();
            }
            IDOMDocumentType docType = (IDOMDocumentType)document.getDoctype();
            if (declaration != null) {
                if (pi != null) {
                    pi.setData(declaration);
                } else {
                    pi = document.createProcessingInstruction("xml", declaration);
                    document.insertBefore(pi, child);
                    HTMLConverter.insertBreak(model, child);
                }
            }
            if (publicId != null) {
                String name;
                HTMLDocumentTypeEntry entry = HTMLDocumentTypeRegistry.getInstance().getEntry(publicId);
                String string = name = entry != null ? entry.getName() : null;
                if (name == null || name.length() == 0) {
                    name = "HTML";
                }
                if (docType != null) {
                    if (!name.equals(docType.getName())) {
                        Node parent = docType.getParentNode();
                        child = docType;
                        docType = (IDOMDocumentType)document.createDoctype(name);
                        parent.insertBefore(docType, child);
                        parent.removeChild(child);
                    }
                } else {
                    docType = (IDOMDocumentType)document.createDoctype(name);
                    document.insertBefore(docType, child);
                    HTMLConverter.insertBreak(model, child);
                }
                docType.setPublicId(publicId);
                if (entry != null) {
                    Element element;
                    String namespaceURI;
                    String systemId = entry.getSystemId();
                    if (systemId != null) {
                        docType.setSystemId(systemId);
                    }
                    if ((namespaceURI = entry.getNamespaceURI()) != null && (element = document.getDocumentElement()) != null) {
                        element.setAttribute("xmlns", namespaceURI);
                    }
                }
            }
        }
        finally {
            model.changedModel();
        }
    }

    private void writeModel(IDOMModel model, OutputStream output) throws UnsupportedEncodingException, IOException, CoreException {
        if (model == null || output == null) {
            return;
        }
        model.save();
    }

    private void writeModel(IDOMModel model, IFile file) throws IOException, CoreException {
        if (model == null || file == null) {
            return;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        ByteArrayInputStream input = null;
        try {
            model.save();
        }
        finally {
            if (input != null) {
                input.close();
            }
        }
    }
}

