/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.document;

import java.util.Iterator;
import org.eclipse.wst.html.core.internal.document.MetaData;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionList;
import org.eclipse.wst.xml.core.internal.document.TagAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class MetaDataAdapter
implements TagAdapter,
MetaData {
    private IDOMElement element = null;
    private String type = null;
    private String data = null;
    private String endData = null;

    public MetaDataAdapter(String type) {
        if (type != null) {
            this.type = type.equals("Annotation") ? "Annotation" : (type.equals("AuthorTimeVisual") ? "AuthorTimeVisual" : type);
        }
    }

    private String getData(IStructuredDocumentRegion flatNode) {
        char c;
        if (flatNode == null) {
            return null;
        }
        ITextRegionList regions = flatNode.getRegions();
        if (regions == null) {
            return null;
        }
        String data = null;
        Iterator e = regions.iterator();
        while (e.hasNext()) {
            ITextRegion region = (ITextRegion)e.next();
            String regionType = region.getType();
            if (!this.isCommentText(regionType)) continue;
            data = flatNode.getText(region);
            break;
        }
        if (data == null) {
            return null;
        }
        int length = data.length();
        int offset = 0;
        while (offset < length) {
            c = data.charAt(offset);
            if (c == '\r' || c == '\n') {
                ++offset;
                break;
            }
            ++offset;
        }
        while (offset < length) {
            c = data.charAt(offset);
            if (c != '\r' && c != '\n') break;
            ++offset;
        }
        return data.substring(offset);
    }

    private boolean isCommentText(String regionType) {
        boolean result = false;
        result = this.isDOMComment(regionType) || this.isNestedContentComment(regionType);
        return result;
    }

    private boolean isNestedContentComment(String regionType) {
        return regionType.equals("JSP_COMMENT_TEXT");
    }

    private boolean isDOMComment(String regionType) {
        return regionType == "XML_COMMENT_TEXT";
    }

    public String getData() {
        if (this.element == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = this.element.getStartStructuredDocumentRegion();
        if (flatNode == null) {
            return null;
        }
        if (this.data != null) {
            return this.data;
        }
        return this.getData(flatNode);
    }

    private String getDelimiter(IDOMModel model) {
        IStructuredDocument structuredDocument;
        String delim = null;
        if (model != null && (structuredDocument = model.getStructuredDocument()) != null) {
            delim = structuredDocument.getLineDelimiter();
        }
        if (delim == null) {
            delim = "\r\n";
        }
        return delim;
    }

    public String getEndData() {
        if (this.element == null) {
            return null;
        }
        IStructuredDocumentRegion flatNode = this.element.getEndStructuredDocumentRegion();
        if (flatNode == null) {
            return null;
        }
        if (this.endData != null) {
            return this.endData;
        }
        return this.getData(flatNode);
    }

    public String getEndTag(IDOMElement element) {
        StringBuffer buffer = new StringBuffer();
        if (element.isJSPTag()) {
            buffer.append("<%--");
        } else {
            buffer.append("<!--");
        }
        buffer.append("METADATA");
        buffer.append(' ');
        buffer.append("type");
        buffer.append("=\"");
        buffer.append(this.type);
        buffer.append("\" ");
        buffer.append("endspan");
        String data = this.getEndData();
        if (data != null && data.length() > 0) {
            String delim = this.getDelimiter(element.getModel());
            buffer.append(delim);
            buffer.append(data);
            buffer.append(delim);
        }
        if (element.isJSPTag()) {
            buffer.append("--%>");
        } else {
            buffer.append("-->");
        }
        return buffer.toString();
    }

    public String getStartTag(IDOMElement element) {
        StringBuffer buffer = new StringBuffer();
        if (element.isJSPTag()) {
            buffer.append("<%--");
        } else {
            buffer.append("<!--");
        }
        buffer.append("METADATA");
        buffer.append(' ');
        buffer.append("type");
        buffer.append("=\"");
        buffer.append(this.type);
        buffer.append("\" ");
        buffer.append("startspan");
        String data = this.getData();
        if (data != null && data.length() > 0) {
            String delim = this.getDelimiter(element.getModel());
            buffer.append(delim);
            buffer.append(data);
            buffer.append(delim);
        }
        if (element.isJSPTag()) {
            buffer.append("--%>");
        } else {
            buffer.append("-->");
        }
        return buffer.toString();
    }

    public String getType() {
        return this.type;
    }

    public boolean isAdapterForType(Object type) {
        return type == TagAdapter.class || type == MetaDataAdapter.class;
    }

    public boolean isEndTag() {
        if (this.element == null) {
            return false;
        }
        if (this.element.hasStartTag()) {
            return false;
        }
        if (this.element.hasEndTag()) {
            return true;
        }
        if (this.data != null) {
            return false;
        }
        return this.endData != null;
    }

    public boolean isRuntimeContainer() {
        return this.type == "Annotation" || this.type == "AuthorTimeVisual";
    }

    public void notifyChanged(INodeNotifier notifier, int eventType, Object changedFeature, Object oldValue, Object newValue, int pos) {
    }

    public void setData(String data) {
        this.data = data;
        if (this.element != null) {
            this.element.notifyStartTagChanged();
        }
    }

    public void setEndData(String data) {
        this.endData = data;
        if (this.element != null) {
            this.element.notifyEndTagChanged();
        }
    }

    public void setElement(IDOMElement element) {
        this.element = element;
        if (this.element != null) {
            this.element.setCommentTag(true);
            if (this.type != "Annotation") {
                this.element.setJSPTag(true);
            }
        }
    }

    public void setRuntimeSource(String source) {
        if (source == null) {
            return;
        }
        if (this.element == null) {
            return;
        }
        if (this.isRuntimeContainer()) {
            return;
        }
        IDOMModel model = this.element.getModel();
        if (model == null) {
            return;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        int offset = this.element.getStartEndOffset();
        int end = this.element.getEndStartOffset();
        int length = end - offset;
        structuredDocument.replaceText(model, offset, length, source);
    }
}

