/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.encoding;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.wst.html.core.internal.contenttype.EncodingGuesser;
import org.eclipse.wst.html.core.internal.document.HTMLDocumentTypeAdapterFactory;
import org.eclipse.wst.html.core.internal.document.HTMLModelParserAdapterFactory;
import org.eclipse.wst.html.core.internal.encoding.HTMLDocumentCharsetDetector;
import org.eclipse.wst.html.core.internal.htmlcss.HTMLStyleSelectorAdapterFactory;
import org.eclipse.wst.html.core.internal.htmlcss.StyleAdapterFactory;
import org.eclipse.wst.html.core.internal.modelquery.ModelQueryAdapterFactoryForHTML;
import org.eclipse.wst.html.core.internal.parser.HTMLSourceParser;
import org.eclipse.wst.html.core.internal.provisional.contenttype.ContentTypeIdForHTML;
import org.eclipse.wst.html.core.internal.text.StructuredTextPartitionerForHTML;
import org.eclipse.wst.sse.core.internal.PropagatingAdapter;
import org.eclipse.wst.sse.core.internal.document.AbstractDocumentLoader;
import org.eclipse.wst.sse.core.internal.document.IDocumentCharsetDetector;
import org.eclipse.wst.sse.core.internal.document.IDocumentLoader;
import org.eclipse.wst.sse.core.internal.document.StructuredDocumentFactory;
import org.eclipse.wst.sse.core.internal.encoding.ContentTypeEncodingPreferences;
import org.eclipse.wst.sse.core.internal.ltk.parser.BlockMarker;
import org.eclipse.wst.sse.core.internal.ltk.parser.RegionParser;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapterFactory;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.document.IEncodedDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.text.BasicStructuredDocument;
import org.eclipse.wst.xml.core.internal.parser.XMLSourceParser;
import org.eclipse.wst.xml.core.internal.parser.XMLStructuredDocumentReParser;
import org.eclipse.wst.xml.core.internal.propagate.PropagatingAdapterFactoryImpl;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;

public class HTMLDocumentLoader
extends AbstractDocumentLoader {
    protected void addHTMLishTag(XMLSourceParser parser, String tagname) {
        BlockMarker bm = new BlockMarker(tagname, null, "BLOCK_TEXT", false);
        parser.addBlockMarker(bm);
    }

    protected String getSpecDefaultEncoding() {
        return null;
    }

    protected String getEncodingNameByGuess(byte[] string, int length) {
        String ianaEnc = EncodingGuesser.guessEncoding(string, length);
        return ianaEnc;
    }

    protected IEncodedDocument newEncodedDocument() {
        IStructuredDocument structuredDocument = StructuredDocumentFactory.getNewStructuredDocumentInstance(this.getParser());
        ((BasicStructuredDocument)structuredDocument).setReParser(new XMLStructuredDocumentReParser());
        return structuredDocument;
    }

    public RegionParser getParser() {
        HTMLSourceParser parser = new HTMLSourceParser();
        this.addHTMLishTag(parser, "script");
        this.addHTMLishTag(parser, "style");
        return parser;
    }

    public List getAdapterFactories() {
        ArrayList<StyleAdapterFactory> result = new ArrayList<StyleAdapterFactory>();
        INodeAdapterFactory factory = null;
        factory = StyleAdapterFactory.getInstance();
        result.add((StyleAdapterFactory)factory);
        factory = HTMLStyleSelectorAdapterFactory.getInstance();
        result.add((StyleAdapterFactory)factory);
        factory = HTMLDocumentTypeAdapterFactory.getInstance();
        result.add((StyleAdapterFactory)factory);
        factory = HTMLModelParserAdapterFactory.getInstance();
        result.add((StyleAdapterFactory)factory);
        factory = new ModelQueryAdapterFactoryForHTML();
        result.add((StyleAdapterFactory)factory);
        factory = new PropagatingAdapterFactoryImpl();
        result.add((StyleAdapterFactory)factory);
        return result;
    }

    protected String getPreferredNewLineDelimiter(IFile file) {
        String delimiter = ContentTypeEncodingPreferences.getPreferredNewLineDelimiter(ContentTypeIdForHTML.ContentTypeID_HTML);
        if (delimiter == null) {
            delimiter = super.getPreferredNewLineDelimiter(file);
        }
        return delimiter;
    }

    public IDocumentCharsetDetector getDocumentEncodingDetector() {
        if (this.fDocumentEncodingDetector == null) {
            this.fDocumentEncodingDetector = new HTMLDocumentCharsetDetector();
        }
        return this.fDocumentEncodingDetector;
    }

    protected void preLoadAdapt(IStructuredModel structuredModel) {
        IDOMModel domModel = (IDOMModel)structuredModel;
        domModel.getDocument().getAdapterFor(PropagatingAdapter.class);
    }

    public IDocumentPartitioner getDefaultDocumentPartitioner() {
        return new StructuredTextPartitionerForHTML();
    }

    public IDocumentLoader newInstance() {
        return new HTMLDocumentLoader();
    }
}

