/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.format;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.wst.html.core.internal.HTMLCorePlugin;
import org.eclipse.wst.html.core.internal.format.HTMLFormatContraintsImpl;
import org.eclipse.wst.html.core.internal.format.HTMLFormatterFactory;
import org.eclipse.wst.html.core.internal.format.HTMLFormattingUtil;
import org.eclipse.wst.html.core.internal.format.HTMLTextFormatter;
import org.eclipse.wst.html.core.internal.provisional.HTMLFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatContraints;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatPreferences;
import org.eclipse.wst.sse.core.internal.format.IStructuredFormatter;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.ModelQuery;
import org.eclipse.wst.xml.core.internal.modelquery.ModelQueryUtil;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.format.StructuredFormatPreferencesXML;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class HTMLFormatter
implements IStructuredFormatter {
    private static final String HTML_NAME = "html";
    private static final String HEAD_NAME = "head";
    private static final String BODY_NAME = "BODY";
    private static final String JSP = "jsp";
    private HTMLFormattingUtil formattingUtil = new HTMLFormattingUtil();
    protected IStructuredFormatPreferences fFormatPreferences = null;
    protected HTMLFormatContraints fFormatContraints = null;
    protected IProgressMonitor fProgressMonitor = null;

    protected void addWidth(HTMLFormatContraints contraints, int width) {
        if (contraints == null) {
            return;
        }
        if (!this.splitLines() || this.getLineWidth() < 0) {
            return;
        }
        int availableWidth = contraints.getAvailableLineWidth() - width;
        if (availableWidth < 0) {
            availableWidth = 0;
        }
        contraints.setAvailableLineWidth(availableWidth);
    }

    protected boolean canFormatChild(Node node) {
        while (node != null) {
            if (node.getNodeType() != 1) {
                return true;
            }
            CMElementDeclaration decl = this.getElementDeclaration((Element)node);
            if (decl != null) {
                boolean shouldKeepSpace;
                if (decl.getContentType() == 5) {
                    return false;
                }
                if (decl.supports("shouldKeepSpace") && (shouldKeepSpace = ((Boolean)decl.getProperty("shouldKeepSpace")).booleanValue())) {
                    return false;
                }
            }
            node = node.getParentNode();
        }
        return false;
    }

    protected boolean canInsertBreakAfter(CMElementDeclaration decl) {
        if (decl == null) {
            return false;
        }
        if (!decl.supports("lineBreakHint")) {
            return false;
        }
        String hint = (String)decl.getProperty("lineBreakHint");
        if (hint == null) {
            return false;
        }
        return hint.equals("breakBeforeStartAndAfterEnd") || hint.equals("breakAfterStart");
    }

    protected boolean canInsertBreakAfter(Node node) {
        CMElementDeclaration decl;
        IDOMElement element;
        CMElementDeclaration decl2;
        char theChar;
        String theText;
        if (node == null) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        Node next = node.getNextSibling();
        String prefix = node.getPrefix();
        if (prefix != null && JSP.equals(prefix)) {
            boolean canInsertBreakAfter = false;
            if (next != null && next.getNodeType() == 3 && (theText = ((Text)next).getData()) != null && theText.length() > 0) {
                theChar = theText.charAt(0);
                canInsertBreakAfter = Character.isWhitespace(theChar);
            }
            if (!canInsertBreakAfter) {
                return false;
            }
        }
        if (next != null && (prefix = next.getPrefix()) != null && JSP.equals(prefix)) {
            boolean canInsertBreakAfterPrevious = false;
            if (node.getNodeType() == 3 && (theText = ((Text)node).getData()) != null && theText.length() > 0) {
                theChar = theText.charAt(theText.length() - 1);
                canInsertBreakAfterPrevious = Character.isWhitespace(theChar);
            }
            if (!canInsertBreakAfterPrevious) {
                return false;
            }
        }
        if (parent.getNodeType() == 9) {
            return node.getNodeType() != 1 || ((IDOMElement)node).isClosed();
        }
        if (parent.getNodeType() == 1) {
            IDOMElement element2 = (IDOMElement)parent;
            if (next == null && element2.getEndStructuredDocumentRegion() == null) {
                return false;
            }
            if (element2.getPrefix() != null) {
                return true;
            }
            decl2 = this.getElementDeclaration(element2);
            if (decl2 != null) {
                boolean allowsText;
                if (decl2.getContentType() == 2) {
                    return true;
                }
                boolean bl = allowsText = decl2.getContentType() == 3 || decl2.getContentType() == 4;
                if (this.allowsNewlineAfter(allowsText, node, element2, decl2)) {
                    return true;
                }
                String tagName = element2.getTagName();
                if (tagName != null && tagName.equalsIgnoreCase(BODY_NAME)) {
                    return true;
                }
            }
        }
        if (node.getNodeType() == 1 && this.canInsertBreakAfter(decl2 = this.getElementDeclaration(element = (IDOMElement)node))) {
            return this.canFormatChild(parent);
        }
        return next != null && next.getNodeType() == 1 && this.canInsertBreakBefore(decl = this.getElementDeclaration((Element)next));
    }

    protected boolean canInsertBreakBefore(CMElementDeclaration decl) {
        if (decl == null) {
            return false;
        }
        if (!decl.supports("lineBreakHint")) {
            return false;
        }
        String hint = (String)decl.getProperty("lineBreakHint");
        if (hint == null) {
            return false;
        }
        return hint.equals("breakBeforeStartAndAfterEnd");
    }

    protected boolean canInsertBreakBefore(Node node) {
        CMElementDeclaration decl;
        char theChar;
        String theText;
        if (node == null) {
            return false;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return false;
        }
        Node prev = node.getPreviousSibling();
        String prefix = node.getPrefix();
        if (prefix != null && JSP.equals(prefix)) {
            boolean canInsertBreakBefore = false;
            if (prev != null && prev.getNodeType() == 3 && (theText = ((Text)prev).getData()) != null && theText.length() > 0) {
                theChar = theText.charAt(theText.length() - 1);
                canInsertBreakBefore = Character.isWhitespace(theChar);
            }
            if (!canInsertBreakBefore) {
                return false;
            }
        }
        if (prev != null && (prefix = prev.getPrefix()) != null && JSP.equals(prefix)) {
            boolean canInsertBreakBeforeNext = false;
            if (node.getNodeType() == 3 && (theText = ((Text)node).getData()) != null && theText.length() > 0) {
                theChar = theText.charAt(0);
                canInsertBreakBeforeNext = Character.isWhitespace(theChar);
            }
            if (!canInsertBreakBeforeNext) {
                return false;
            }
        }
        if (parent.getNodeType() == 9) {
            return prev != null;
        }
        if (parent.getNodeType() == 1) {
            IDOMElement element = (IDOMElement)parent;
            if (prev == null && element.getStartStructuredDocumentRegion() == null) {
                return false;
            }
            if (element.getPrefix() != null) {
                return true;
            }
            CMElementDeclaration decl2 = this.getElementDeclaration(element);
            if (decl2 != null) {
                return this.allowNewlineBefore(node, element, decl2);
            }
        }
        if (node.getNodeType() == 1) {
            return true;
        }
        if (prev != null && prev.getNodeType() == 1 && this.canInsertBreakAfter(decl = this.getElementDeclaration((Element)prev))) {
            return this.canFormatChild(parent);
        }
        return false;
    }

    public void format(Node node) {
        this.format(node, this.getFormatContraints());
    }

    public void format(Node node, IStructuredFormatContraints contraints) {
        if (node instanceof IDOMNode && contraints instanceof HTMLFormatContraints) {
            this.format((IDOMNode)node, (HTMLFormatContraints)contraints);
        }
    }

    public void format(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (node.getParentNode() == null) {
            return;
        }
        this.setWidth(contraints, node);
        if (this.canInsertBreakBefore(node)) {
            this.insertBreakBefore(node, contraints);
        }
        this.formatNode(node, contraints);
        if (this.canInsertBreakAfter(node)) {
            this.insertBreakAfter(node, contraints);
        }
    }

    protected void formatChildNodes(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (!node.hasChildNodes()) {
            return;
        }
        node.normalize();
        boolean indent = false;
        if (contraints != null) {
            indent = contraints.getFormatWithSiblingIndent();
            contraints.setFormatWithSiblingIndent(false);
        }
        boolean insertBreak = true;
        IDOMNode child = (IDOMNode)node.getFirstChild();
        while (child != null) {
            IStructuredFormatter formatter;
            if (child.getParentNode() != node) break;
            IDOMNode next = (IDOMNode)child.getNextSibling();
            if (insertBreak && this.canInsertBreakBefore(child)) {
                this.insertBreakBefore(child, contraints);
            }
            if ((formatter = HTMLFormatterFactory.getInstance().createFormatter(child, this.getFormatPreferences())) != null) {
                if (formatter instanceof HTMLFormatter) {
                    HTMLFormatter htmlFormatter = (HTMLFormatter)formatter;
                    htmlFormatter.formatNode(child, contraints);
                } else {
                    formatter.format(child);
                }
            }
            if (this.canInsertBreakAfter(child)) {
                this.insertBreakAfter(child, contraints);
                insertBreak = false;
            } else {
                insertBreak = true;
            }
            child = next;
        }
        if (contraints != null) {
            contraints.setFormatWithSiblingIndent(indent);
        }
    }

    protected void formatNode(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (node.hasChildNodes()) {
            this.formatChildNodes(node, contraints);
        } else {
            String source;
            IStructuredDocumentRegion flatNode = node.getStartStructuredDocumentRegion();
            if (flatNode != null && (source = flatNode.getText()) != null && source.length() > 0) {
                this.setWidth(contraints, source);
            }
        }
    }

    protected String getBreakSpaces(Node node) {
        String indent;
        if (node == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        String delim = ((IDOMNode)node).getModel().getStructuredDocument().getLineDelimiter();
        if (delim != null && delim.length() > 0) {
            buffer.append(delim);
        }
        if ((indent = this.getIndent()) != null && indent.length() > 0) {
            Node parent = node.getParentNode();
            while (parent != null) {
                if (parent.getNodeType() != 1) break;
                if (((IDOMNode)parent).getStartStructuredDocumentRegion() != null) {
                    String localName;
                    IDOMElement element = (IDOMElement)parent;
                    if (element.getPrefix() != null) {
                        localName = element.getLocalName();
                        if (localName != null && !localName.equals(HTML_NAME)) {
                            buffer.append(indent);
                        }
                    } else {
                        boolean shouldIndent;
                        localName = element.getLocalName();
                        if (HTML_NAME.equalsIgnoreCase(localName) || HEAD_NAME.equalsIgnoreCase(localName)) break;
                        CMElementDeclaration decl = this.getElementDeclaration(element);
                        if (decl != null && decl.supports("shouldIndentChildSource") && (shouldIndent = this.isIdentable(node, parent))) {
                            buffer.append(indent);
                        }
                    }
                }
                parent = parent.getParentNode();
            }
        }
        return buffer.toString();
    }

    protected String getIndent() {
        return this.getFormatPreferences().getIndent();
    }

    protected int getLineWidth() {
        return this.getFormatPreferences().getLineWidth();
    }

    protected CMElementDeclaration getElementDeclaration(Element element) {
        if (element == null) {
            return null;
        }
        Document document = element.getOwnerDocument();
        if (document == null) {
            return null;
        }
        ModelQuery modelQuery = ModelQueryUtil.getModelQuery(document);
        if (modelQuery == null) {
            return null;
        }
        return modelQuery.getCMElementDeclaration(element);
    }

    protected boolean isContentFormatted(Node parent) {
        Node first = parent.getFirstChild();
        if (first != null && first.getNodeType() == 3) {
            String content = first.getNodeValue();
            int length = content.length();
            int i = 0;
            while (i < length) {
                char c = content.charAt(i);
                if (c == '\r' || c == '\n') {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    protected void insertBreakAfter(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 3) {
            return;
        }
        int documentLength = node.getStructuredDocument().getLength();
        if (documentLength < 1 || node.getEndOffset() >= documentLength - 1) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        Node next = node.getNextSibling();
        String spaces = null;
        if (next == null) {
            if (this.formattingUtil.isInline(parent) && !this.isContentFormatted(parent)) {
                return;
            }
            spaces = this.getBreakSpaces(parent);
        } else {
            if (next.getNodeType() == 3) {
                if (contraints != null && contraints.getFormatWithSiblingIndent()) {
                    IDOMNode text = (IDOMNode)next;
                    IStructuredFormatter formatter = HTMLFormatterFactory.getInstance().createFormatter(text, this.getFormatPreferences());
                    if (formatter instanceof HTMLTextFormatter) {
                        HTMLTextFormatter textFormatter = (HTMLTextFormatter)formatter;
                        textFormatter.formatText(text, contraints, HTMLTextFormatter.FORMAT_HEAD);
                    }
                }
                return;
            }
            spaces = this.getBreakSpaces(node);
        }
        if (spaces == null || spaces.length() == 0) {
            return;
        }
        this.replaceSource(node.getModel(), node.getEndOffset(), 0, spaces);
        this.setWidth(contraints, spaces);
    }

    protected void insertBreakBefore(IDOMNode node, HTMLFormatContraints contraints) {
        if (node == null) {
            return;
        }
        if (node.getNodeType() == 3) {
            return;
        }
        Node parent = node.getParentNode();
        if (parent == null) {
            return;
        }
        Node prev = node.getPreviousSibling();
        String spaces = null;
        if (prev != null && prev.getNodeType() == 3) {
            if (contraints != null && contraints.getFormatWithSiblingIndent()) {
                IDOMNode text = (IDOMNode)prev;
                IStructuredFormatter formatter = HTMLFormatterFactory.getInstance().createFormatter(text, this.getFormatPreferences());
                if (formatter instanceof HTMLTextFormatter) {
                    HTMLTextFormatter textFormatter = (HTMLTextFormatter)formatter;
                    textFormatter.formatText(text, contraints, HTMLTextFormatter.FORMAT_TAIL);
                }
            }
            return;
        }
        spaces = this.getBreakSpaces(node);
        if (spaces == null || spaces.length() == 0) {
            return;
        }
        this.replaceSource(node.getModel(), node.getStartOffset(), 0, spaces);
        this.setWidth(contraints, spaces);
    }

    protected boolean isWidthAvailable(HTMLFormatContraints contraints, int width) {
        if (contraints == null) {
            return true;
        }
        if (!this.splitLines() || this.getLineWidth() < 0) {
            return true;
        }
        return contraints.getAvailableLineWidth() >= width;
    }

    protected boolean keepBlankLines(HTMLFormatContraints contraints) {
        if (contraints == null) {
            return true;
        }
        return !contraints.getClearAllBlankLines();
    }

    protected void replaceSource(IStructuredDocumentRegion flatNode, int offset, int length, String source) {
        int startOffset;
        if (flatNode == null) {
            return;
        }
        IStructuredDocument structuredDocument = flatNode.getParentDocument();
        if (structuredDocument == null) {
            return;
        }
        if (source == null) {
            source = new String();
        }
        if (structuredDocument.containsReadOnly((startOffset = flatNode.getStartOffset()) + offset, length)) {
            return;
        }
        structuredDocument.replaceText(structuredDocument, startOffset + offset, length, source);
    }

    protected void replaceSource(IDOMModel model, int offset, int length, String source) {
        if (model == null) {
            return;
        }
        IStructuredDocument structuredDocument = model.getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        if (source == null) {
            source = new String();
        }
        if (structuredDocument.containsReadOnly(offset, length)) {
            return;
        }
        structuredDocument.replaceText(structuredDocument, offset, length, source);
    }

    protected void setWidth(HTMLFormatContraints contraints, String source) {
        if (contraints == null) {
            return;
        }
        if (source == null) {
            return;
        }
        int length = source.length();
        if (length == 0) {
            return;
        }
        if (!this.splitLines()) {
            return;
        }
        int lineWidth = this.getLineWidth();
        if (lineWidth < 0) {
            return;
        }
        int offset = source.lastIndexOf(10);
        int offset2 = source.lastIndexOf(13);
        if (offset2 > offset) {
            offset = offset2;
        }
        if (offset >= 0) {
            ++offset;
        }
        int availableWidth = 0;
        availableWidth = offset >= 0 ? lineWidth - (length - offset) : contraints.getAvailableLineWidth() - length;
        if (availableWidth < 0) {
            availableWidth = 0;
        }
        contraints.setAvailableLineWidth(availableWidth);
    }

    protected void setWidth(HTMLFormatContraints contraints, Node node) {
        if (contraints == null) {
            return;
        }
        if (node == null) {
            return;
        }
        IStructuredDocument structuredDocument = ((IDOMNode)node).getStructuredDocument();
        if (structuredDocument == null) {
            return;
        }
        if (!this.splitLines()) {
            return;
        }
        int lineWidth = this.getLineWidth();
        if (lineWidth < 0) {
            return;
        }
        int offset = ((IDOMNode)node).getStartOffset();
        int line = structuredDocument.getLineOfOffset(offset);
        int lineOffset = 0;
        try {
            lineOffset = structuredDocument.getLineOffset(line);
        }
        catch (BadLocationException badLocationException) {
            return;
        }
        if (lineOffset > offset) {
            return;
        }
        int availableWidth = lineWidth - (offset - lineOffset);
        if (availableWidth < 0) {
            availableWidth = 0;
        }
        contraints.setAvailableLineWidth(availableWidth);
    }

    protected boolean splitLines() {
        return true;
    }

    public void setFormatPreferences(IStructuredFormatPreferences formatPreferences) {
        this.fFormatPreferences = formatPreferences;
    }

    public IStructuredFormatPreferences getFormatPreferences() {
        if (this.fFormatPreferences == null) {
            this.fFormatPreferences = new StructuredFormatPreferencesXML();
            Preferences preferences = HTMLCorePlugin.getDefault().getPluginPreferences();
            if (preferences != null) {
                this.fFormatPreferences.setLineWidth(preferences.getInt("lineWidth"));
                ((StructuredFormatPreferencesXML)this.fFormatPreferences).setSplitMultiAttrs(preferences.getBoolean("splitMultiAttrs"));
                ((StructuredFormatPreferencesXML)this.fFormatPreferences).setAlignEndBracket(preferences.getBoolean("alignEndBracket"));
                this.fFormatPreferences.setClearAllBlankLines(preferences.getBoolean("clearAllBlankLines"));
                char indentChar = ' ';
                String indentCharPref = preferences.getString("indentationChar");
                if ("tab".equals(indentCharPref)) {
                    indentChar = '\t';
                }
                int indentationWidth = preferences.getInt("indentationSize");
                StringBuffer indent = new StringBuffer();
                int i = 0;
                while (i < indentationWidth) {
                    indent.append(indentChar);
                    ++i;
                }
                this.fFormatPreferences.setIndent(indent.toString());
            }
        }
        return this.fFormatPreferences;
    }

    public IStructuredFormatContraints getFormatContraints() {
        if (this.fFormatContraints == null) {
            this.fFormatContraints = new HTMLFormatContraintsImpl();
            this.fFormatContraints.setAvailableLineWidth(this.getFormatPreferences().getLineWidth());
            this.fFormatContraints.setClearAllBlankLines(this.getFormatPreferences().getClearAllBlankLines());
        }
        return this.fFormatContraints;
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.fProgressMonitor = progressMonitor;
    }

    public boolean isInlinableTextNode(Node theNode, Element theParentElement) {
        return this.formattingUtil.isInline(theParentElement) && theNode.getNodeType() == 3;
    }

    public boolean allowsNewlineAfter(boolean theBool, Node theNode, Element theParentElement) {
        return this.allowsNewlineAfter(theBool, theNode, theParentElement, null);
    }

    public boolean allowsNewlineAfter(boolean theBool, Node theNode, Element theParentElement, CMElementDeclaration decl) {
        boolean result = theBool;
        if (theNode.getNodeType() == 3 && this.formattingUtil.isInline(theParentElement)) {
            if (theParentElement.getChildNodes().getLength() == 1) {
                result = false;
            } else if (theNode == theParentElement.getLastChild()) {
                if (theParentElement.getFirstChild().getNodeType() == 1) {
                    result = false;
                }
            } else {
                result = false;
            }
        } else if (theNode.getNodeType() == 1 && this.formattingUtil.isInline(theNode.getNextSibling())) {
            result = false;
        } else if (theNode.getNodeType() == 3) {
            Node next = theNode.getNextSibling();
            if (next != null && this.formattingUtil.isInline(next) || theParentElement.getChildNodes().getLength() <= 1) {
                result = false;
            }
        } else if (decl != null && decl.getContentType() == 4) {
            result = false;
        }
        return result;
    }

    public boolean allowNewlineBefore(Node theNode) {
        if (theNode.getNodeType() != 3 && theNode.getNodeType() != 1) {
            return false;
        }
        return this.formattingUtil.isInline(theNode.getParentNode()) || this.formattingUtil.isInline(theNode.getPreviousSibling());
    }

    public boolean allowNewlineBefore(Node theNode, Element theParentElement) {
        return this.allowNewlineBefore(theNode, theParentElement, null);
    }

    public boolean allowNewlineBefore(Node theNode, Element theParentElement, CMElementDeclaration decl) {
        boolean result = true;
        if (this.isInlinableTextNode(theNode, theParentElement)) {
            result = false;
        } else if (this.allowNewlineBefore(theNode)) {
            result = false;
        } else if (theNode.getNodeType() == 3 && theParentElement.getChildNodes().getLength() <= 1) {
            result = false;
        } else if (decl != null && decl.getContentType() == 4) {
            result = false;
        }
        return result;
    }

    public boolean isIdentable(Node theNode, Node theParent) {
        boolean result = true;
        if (this.formattingUtil.isInline(theNode) && this.formattingUtil.shouldSkipIndentForNode(theNode) && theParent == theNode.getParentNode()) {
            result = false;
        }
        return result;
    }
}

