/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.modelquery;

import java.util.List;
import java.util.Vector;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.html.core.internal.modelquery.HMQUtil;
import org.eclipse.wst.html.core.internal.modelquery.HTMLModelQueryAssociationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.ModelQueryImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.util.CMDocumentCache;
import org.eclipse.wst.xml.core.internal.modelquery.XMLModelQueryAssociationProvider;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.eclipse.wst.xml.core.internal.ssemodelquery.MovableModelQuery;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class HTMLModelQueryImpl
extends ModelQueryImpl
implements MovableModelQuery {
    protected CMDocumentCache fCache = null;
    protected XMLModelQueryAssociationProvider xmlAssocProv = null;

    public HTMLModelQueryImpl(CMDocumentCache cache, URIResolver idResolver) {
        super(new HTMLModelQueryAssociationProvider(cache, idResolver));
        this.fCache = cache;
        this.xmlAssocProv = new XMLModelQueryAssociationProvider(cache, idResolver);
    }

    public List getAvailableContent(Element element, CMElementDeclaration ed, int includeOptions) {
        List originalCandidates = super.getAvailableContent(element, ed, includeOptions);
        if ((includeOptions & 2) == 0) {
            return originalCandidates;
        }
        if (!ed.supports("isXHTML")) {
            return originalCandidates;
        }
        Boolean isXhtml = Boolean.FALSE;
        isXhtml = (Boolean)ed.getProperty("isXHTML");
        if (isXhtml != null && isXhtml.booleanValue()) {
            return originalCandidates;
        }
        Vector candidates = new Vector(originalCandidates);
        switch (ed.getContentType()) {
            case 0: 
            case 2: 
            case 3: {
                candidates.addAll(HMQUtil.getInclusions(element));
                break;
            }
        }
        if (element == null) {
            return candidates;
        }
        Vector<CMElementDeclaration> content = new Vector<CMElementDeclaration>(candidates.size());
        int i = 0;
        while (i < candidates.size()) {
            CMElementDeclaration candidate;
            Object eCandidate = candidates.elementAt(i);
            if (eCandidate instanceof CMElementDeclaration && (candidate = (CMElementDeclaration)eCandidate) != null && !HTMLModelQueryImpl.isExcluded(candidate, element)) {
                content.add(candidate);
            }
            ++i;
        }
        return content;
    }

    public void setIdResolver(URIResolver newIdResolver) {
        this.modelQueryAssociationProvider = new HTMLModelQueryAssociationProvider(this.fCache, newIdResolver);
    }

    private static boolean isExcluded(CMElementDeclaration candidate, Element target) {
        CMNamedNodeMap prohibited = HTMLModelQueryImpl.getProhibitedAncestors(candidate);
        if (prohibited == null) {
            return false;
        }
        Element parent = target;
        while (parent != null) {
            CMNode pdec = prohibited.getNamedItem(parent.getNodeName());
            if (pdec != null) {
                return true;
            }
            parent = HTMLModelQueryImpl.getExplicitParentElement(parent);
        }
        return false;
    }

    private static CMNamedNodeMap getProhibitedAncestors(CMElementDeclaration dec) {
        if (!dec.supports("prohibitedAncestors")) {
            return null;
        }
        return (CMNamedNodeMap)dec.getProperty("prohibitedAncestors");
    }

    private static Element getExplicitParentElement(Node child) {
        if (child == null) {
            return null;
        }
        Node p = child.getParentNode();
        while (p != null) {
            if (p.getNodeType() == 1) {
                if (p instanceof IDOMElement && ((IDOMElement)p).isImplicitTag()) {
                    p = p.getParentNode();
                    continue;
                }
                return (Element)p;
            }
            p = p.getParentNode();
        }
        return null;
    }

    public CMElementDeclaration getCMElementDeclaration(Element element) {
        CMElementDeclaration result = super.getCMElementDeclaration(element);
        if (result != null) {
            return result;
        }
        return this.xmlAssocProv.getCMElementDeclaration(element);
    }
}

