/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.eclipse.wst.html.core.internal.validate.CMUtil;
import org.eclipse.wst.html.core.internal.validate.ErrorInfoImpl;
import org.eclipse.wst.html.core.internal.validate.FMUtil;
import org.eclipse.wst.html.core.internal.validate.PrimeValidator;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.document.DocumentTypeAdapter;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMText;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HTMLDocumentContentValidator
extends PrimeValidator {
    public boolean isAdapterForType(Object type) {
        return type == HTMLDocumentContentValidator.class || super.isAdapterForType(type);
    }

    public void validate(IndexedRegion node) {
        boolean isFragment = true;
        Document target = (Document)((Object)node);
        NodeList children = target.getChildNodes();
        if (children == null) {
            return;
        }
        Division division = new Division(target, children);
        if (division.hasExplicitHtmls()) {
            isFragment = false;
            List explicits = division.getExplicitHtmls();
            if (explicits.size() > 1) {
                int i = 1;
                while (i < explicits.size()) {
                    Element html = (Element)explicits.get(i);
                    Segment errorSeg = FMUtil.getSegment((IDOMNode)((Object)html), 2);
                    if (errorSeg != null) {
                        this.reporter.report(new ErrorInfoImpl(1002, errorSeg, html));
                    }
                    ++i;
                }
            }
        }
        this.validateContent(division.getRestNodes(), isFragment);
    }

    private void validateContent(Iterator children, boolean isFragment) {
        boolean foundDoctype = false;
        block6: while (children.hasNext()) {
            Segment errorSeg;
            IDOMNode child = (IDOMNode)children.next();
            int error = 0;
            int segType = 1;
            switch (child.getNodeType()) {
                case 1: {
                    if (isFragment) break;
                    Element childElem = (Element)((Object)child);
                    CMElementDeclaration ced = CMUtil.getDeclaration(childElem);
                    if (ced == null || CMUtil.isForeign(childElem) || CMUtil.isSSI(ced)) continue block6;
                    error = 1001;
                    segType = 2;
                    break;
                }
                case 3: {
                    if (isFragment) break;
                    if (((IDOMText)child).isElementContentWhitespace()) continue block6;
                    error = 1001;
                    segType = 1;
                    break;
                }
                case 10: {
                    if (!foundDoctype) {
                        foundDoctype = true;
                        continue block6;
                    }
                    error = 1002;
                    segType = 1;
                    break;
                }
                case 7: 
                case 8: {
                    continue block6;
                }
                default: {
                    if (isFragment) break;
                    error = 1001;
                    segType = 1;
                }
            }
            if (error == 0 || (errorSeg = FMUtil.getSegment(child, segType)) == null) continue;
            this.reporter.report(new ErrorInfoImpl(error, errorSeg, child));
        }
    }

    private static final class Division {
        private Vector explicitHtmls = new Vector();
        private Vector rest = new Vector();

        public Division(Document document, NodeList children) {
            String rootTagName = Division.getRootTagName(document);
            int i = 0;
            while (i < children.getLength()) {
                Node child = children.item(i);
                if (Division.isHtmlTag(child, rootTagName)) {
                    this.explicitHtmls.add(child);
                } else {
                    this.rest.add(child);
                }
                ++i;
            }
        }

        public boolean hasExplicitHtmls() {
            return this.explicitHtmls.size() > 0;
        }

        public List getExplicitHtmls() {
            return this.explicitHtmls;
        }

        public Iterator getRestNodes() {
            return this.rest.iterator();
        }

        private static boolean isHtmlTag(Node node, String tagName) {
            if (node.getNodeType() != 1) {
                return false;
            }
            return ((Element)node).getTagName().equalsIgnoreCase(tagName);
        }

        private static String getRootTagName(Document document) {
            DocumentType docType;
            DocumentTypeAdapter adapter = (DocumentTypeAdapter)((IDOMDocument)document).getAdapterFor(DocumentTypeAdapter.class);
            if (adapter != null && (docType = adapter.getDocumentType()) != null) {
                return docType.getName();
            }
            return "HTML";
        }
    }
}

