/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import org.eclipse.wst.html.core.internal.validate.CMUtil;
import org.eclipse.wst.html.core.internal.validate.ErrorInfoImpl;
import org.eclipse.wst.html.core.internal.validate.FMUtil;
import org.eclipse.wst.html.core.internal.validate.PrimeValidator;
import org.eclipse.wst.html.core.internal.validate.SMUtil;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.w3c.dom.Element;

public class HTMLElementAncestorValidator
extends PrimeValidator {
    public boolean isAdapterForType(Object type) {
        return type == HTMLElementAncestorValidator.class || super.isAdapterForType(type);
    }

    public void validate(IndexedRegion node) {
        Element target = (Element)((Object)node);
        if (CMUtil.isForeign(target)) {
            return;
        }
        CMElementDeclaration dec = CMUtil.getDeclaration(target);
        if (dec == null) {
            return;
        }
        if (!CMUtil.isHTML(dec)) {
            return;
        }
        if (!dec.supports("prohibitedAncestors")) {
            return;
        }
        CMNamedNodeMap prohibited = (CMNamedNodeMap)dec.getProperty("prohibitedAncestors");
        if (prohibited.getLength() <= 0) {
            return;
        }
        Element parent = SMUtil.getParentElement(target);
        while (parent != null) {
            CMNode pdec = prohibited.getNamedItem(parent.getNodeName());
            if (pdec != null) {
                Segment errorSeg = FMUtil.getSegment((IDOMNode)node, 2);
                if (errorSeg == null) break;
                this.reporter.report(new ErrorInfoImpl(1001, errorSeg, target));
                break;
            }
            parent = SMUtil.getParentElement(parent);
        }
    }
}

