/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.html.core.internal.validate;

import org.eclipse.wst.html.core.internal.validate.CMUtil;
import org.eclipse.wst.html.core.internal.validate.ErrorInfoImpl;
import org.eclipse.wst.html.core.internal.validate.ErrorState;
import org.eclipse.wst.html.core.internal.validate.FMUtil;
import org.eclipse.wst.html.core.internal.validate.PrimeValidator;
import org.eclipse.wst.html.core.internal.validate.SMUtil;
import org.eclipse.wst.html.core.internal.validate.Segment;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;
import org.eclipse.wst.xml.core.internal.contentmodel.CMAttributeDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMAttr;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMElement;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class NamespaceValidator
extends PrimeValidator
implements ErrorState {
    private static final String XMLNS_PREFIX = "xmlns";
    private static final String NS_SEPARATOR = ":";

    public boolean isAdapterForType(Object type) {
        return type == NamespaceValidator.class || super.isAdapterForType(type);
    }

    public void validate(IndexedRegion node) {
        IDOMElement e;
        Element target = (Element)((Object)node);
        if (this.isXMLElement(target) && this.hasUnknownPrefix(target) && !this.isValidPrefix((e = (IDOMElement)target).getPrefix(), target) && !e.isCommentTag()) {
            Segment errorSeg = null;
            if (e.hasStartTag()) {
                errorSeg = FMUtil.getSegment(e, 2);
            } else if (e.hasEndTag()) {
                errorSeg = FMUtil.getSegment(e, 3);
            }
            if (errorSeg != null) {
                this.reporter.report(new ErrorInfoImpl(11, errorSeg, e));
            }
        }
        NamedNodeMap attrs = target.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            ITextRegion r;
            IDOMAttr a;
            String prefix;
            Node n = attrs.item(i);
            if (n instanceof IDOMAttr && !(((IDOMAttr)n).getNameRegion() instanceof ITextRegionContainer) && (prefix = (a = (IDOMAttr)n).getPrefix()) != null && this.isUnknownAttr(a, target) && !this.isValidPrefix(prefix, target) && (r = a.getNameRegion()) != null) {
                int a_offset = a.getNameRegionStartOffset();
                int a_length = a.getNameRegion().getLength();
                this.reporter.report(new ErrorInfoImpl(11, new Segment(a_offset, a_length), a));
            }
            ++i;
        }
    }

    private boolean isXMLElement(Element target) {
        return target instanceof IDOMElement;
    }

    private boolean hasUnknownPrefix(Element target) {
        return this.isUnknownElement(target) && CMUtil.isForeign(target);
    }

    private boolean isUnknownElement(Element target) {
        CMElementDeclaration dec = CMUtil.getDeclaration(target);
        return dec == null;
    }

    private boolean isUnknownAttr(IDOMAttr attr, Element target) {
        CMElementDeclaration dec = CMUtil.getDeclaration(target);
        if (dec == null) {
            return true;
        }
        CMNamedNodeMap adecls = dec.getAttributes();
        CMAttributeDeclaration adec = (CMAttributeDeclaration)adecls.getNamedItem(attr.getName());
        return adec == null;
    }

    private boolean isValidPrefix(String prefix, Element e) {
        if (prefix.equals(XMLNS_PREFIX)) {
            return true;
        }
        if (this.isValidPrefixWithinElement(prefix, e)) {
            return true;
        }
        Element parent = SMUtil.getParentElement(e);
        while (parent != null) {
            if (this.isValidPrefixWithinElement(prefix, parent)) {
                return true;
            }
            parent = SMUtil.getParentElement(parent);
        }
        return false;
    }

    private boolean isValidPrefixWithinElement(String prefix, Element e) {
        String ns = "xmlns:" + prefix;
        NamedNodeMap attrs = e.getAttributes();
        int i = 0;
        while (i < attrs.getLength()) {
            Node n = attrs.item(i);
            if (n != null && n.getNodeType() == 2 && ns.equals(((Attr)n).getName())) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

