/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.LibrarySuperType;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.util.CoreUtility;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.ClassPathDetector;
import org.eclipse.wst.jsdt.internal.ui.wizards.JavaProjectWizardFirstPage;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.ui.PreferenceConstants;
import org.eclipse.wst.jsdt.ui.wizards.JavaCapabilityConfigurationPage;

public class JavaProjectWizardSecondPage
extends JavaCapabilityConfigurationPage {
    private static final String FILENAME_PROJECT = ".project";
    private final JavaProjectWizardFirstPage fFirstPage;
    private URI fCurrProjectLocation;
    private IProject fCurrProject;
    private boolean fKeepContent;
    private File fDotProjectBackup;
    private File fDotClasspathBackup;
    private Boolean fIsAutobuild;
    private static final String SUPER_TYPE_NAME = "Window";

    public JavaProjectWizardSecondPage(JavaProjectWizardFirstPage mainPage) {
        this.fFirstPage = mainPage;
        this.fCurrProjectLocation = null;
        this.fCurrProject = null;
        this.fKeepContent = false;
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        this.fIsAutobuild = null;
    }

    @Override
    protected boolean useNewSourcePage() {
        return true;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            IStatus status = this.changeToNewProject();
            if (status != null && !status.isOK()) {
                ErrorDialog.openError((Shell)this.getShell(), (String)NewWizardMessages.JavaProjectWizardSecondPage_error_title, null, (IStatus)status);
            }
        } else {
            this.removeProject();
        }
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    private IStatus changeToNewProject() {
        this.fKeepContent = this.fFirstPage.getDetect();
        class UpdateRunnable
        implements IRunnableWithProgress {
            public IStatus infoStatus = Status.OK_STATUS;

            UpdateRunnable() {
            }

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    try {
                        if (JavaProjectWizardSecondPage.this.fIsAutobuild == null) {
                            JavaProjectWizardSecondPage.this.fIsAutobuild = CoreUtility.enableAutoBuild(false);
                        }
                        this.infoStatus = JavaProjectWizardSecondPage.this.updateProject(monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        throw new InterruptedException();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        }
        UpdateRunnable op = new UpdateRunnable();
        try {
            this.getContainer().run(true, false, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation((IRunnableWithProgress)op));
            return op.infoStatus;
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.JavaProjectWizardSecondPage_error_title;
            String message = NewWizardMessages.JavaProjectWizardSecondPage_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
        return null;
    }

    final IStatus updateProject(IProgressMonitor monitor) throws CoreException, InterruptedException {
        IStatus result = StatusInfo.OK_STATUS;
        this.fCurrProject = this.fFirstPage.getProjectHandle();
        this.fCurrProjectLocation = this.getProjectLocationURI();
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            monitor.beginTask(NewWizardMessages.JavaProjectWizardSecondPage_operation_initialize, 7);
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            URI realLocation = this.fCurrProjectLocation;
            if (this.fCurrProjectLocation == null) {
                try {
                    URI rootLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                    realLocation = new URI(rootLocation.getScheme(), null, Path.fromPortableString((String)rootLocation.getPath()).append(this.fCurrProject.getName()).toString(), null);
                }
                catch (URISyntaxException uRISyntaxException) {
                    Assert.isTrue((boolean)false, (String)"Can't happen");
                }
            }
            this.rememberExistingFiles(realLocation);
            try {
                JavaProjectWizardSecondPage.createProject(this.fCurrProject, this.fCurrProjectLocation, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
            }
            catch (CoreException e) {
                if (e.getStatus().getCode() == 567) {
                    result = new StatusInfo(1, Messages.format(NewWizardMessages.JavaProjectWizardSecondPage_DeleteCorruptProjectFile_message, e.getLocalizedMessage()));
                    this.deleteProjectFile(realLocation);
                    if (this.fCurrProject.exists()) {
                        this.fCurrProject.delete(true, null);
                    }
                    JavaProjectWizardSecondPage.createProject(this.fCurrProject, this.fCurrProjectLocation, null);
                }
                throw e;
            }
            IIncludePathEntry[] entries = null;
            if (this.fFirstPage.getDetect()) {
                if (!this.fCurrProject.getFolder(".settings").getFile(".jsdtscope").exists()) {
                    ClassPathDetector detector = new ClassPathDetector(this.fCurrProject, (IProgressMonitor)new SubProgressMonitor(monitor, 2), JavaScriptCore.getJavaScriptCore().getDefaultClasspathExclusionPatterns());
                    entries = detector.getClasspath();
                } else {
                    monitor.worked(2);
                }
            } else if (this.fFirstPage.isSrcBin()) {
                IPreferenceStore store = PreferenceConstants.getPreferenceStore();
                Path srcPath = new Path(store.getString("org.eclipse.wst.jsdt.ui.wizards.srcBinFoldersSrcName"));
                if (srcPath.segmentCount() > 0) {
                    IFolder folder = this.fCurrProject.getFolder((IPath)srcPath);
                    CoreUtility.createFolder(folder, true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    monitor.worked(1);
                }
                monitor.worked(1);
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IIncludePathEntry> cpEntries = new ArrayList<IIncludePathEntry>();
                cpEntries.add(JavaScriptCore.newSourceEntry(projectPath.append((IPath)srcPath), JavaScriptCore.getJavaScriptCore().getDefaultClasspathExclusionPatterns()));
                cpEntries.addAll(Arrays.asList(this.getDefaultClasspathEntry()));
                entries = cpEntries.toArray(new IIncludePathEntry[cpEntries.size()]);
            } else {
                IPath projectPath = this.fCurrProject.getFullPath();
                ArrayList<IIncludePathEntry> cpEntries = new ArrayList<IIncludePathEntry>();
                cpEntries.add(JavaScriptCore.newSourceEntry(projectPath, JavaScriptCore.getJavaScriptCore().getDefaultClasspathExclusionPatterns()));
                cpEntries.addAll(Arrays.asList(this.getDefaultClasspathEntry()));
                entries = cpEntries.toArray(new IIncludePathEntry[cpEntries.size()]);
                monitor.worked(2);
            }
            if (monitor.isCanceled()) {
                throw new OperationCanceledException();
            }
            IJavaScriptProject javaProject = JavaScriptCore.create(this.fCurrProject);
            this.init(javaProject, entries, false);
            if (this.fFirstPage.isWebDefault()) {
                LibrarySuperType superType = new LibrarySuperType((IPath)new Path("org.eclipse.wst.jsdt.launching.baseBrowserLibrary"), this.getJavaProject(), SUPER_TYPE_NAME);
                this.getBuildPathsBlock().setSuperType(superType);
                this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 3));
            } else {
                this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 3));
            }
        }
        finally {
            monitor.done();
        }
        return result;
    }

    private URI getProjectLocationURI() throws CoreException {
        if (this.fFirstPage.isInWorkspace()) {
            return null;
        }
        return URIUtil.toURI((IPath)this.fFirstPage.getLocationPath());
    }

    private IIncludePathEntry[] getDefaultClasspathEntry() {
        Path jreContainerPath = new Path("org.eclipse.wst.jsdt.launching.JRE_CONTAINER");
        Path BROWSER_LIB = new Path("org.eclipse.wst.jsdt.launching.baseBrowserLibrary");
        if (this.fFirstPage.isWebEnabled()) {
            return new IIncludePathEntry[]{JavaScriptCore.newContainerEntry((IPath)jreContainerPath), JavaScriptCore.newContainerEntry((IPath)BROWSER_LIB)};
        }
        return new IIncludePathEntry[]{JavaScriptCore.newContainerEntry((IPath)jreContainerPath)};
    }

    private void deleteProjectFile(URI projectLocation) throws CoreException {
        IFileStore projectFile;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists() && (projectFile = file.getChild(FILENAME_PROJECT)).fetchInfo().exists()) {
            projectFile.delete(0, null);
        }
    }

    private void rememberExistingFiles(URI projectLocation) throws CoreException {
        this.fDotProjectBackup = null;
        this.fDotClasspathBackup = null;
        IFileStore file = EFS.getStore((URI)projectLocation);
        if (file.fetchInfo().exists()) {
            IFileStore classpathFile;
            IFileStore projectFile = file.getChild(FILENAME_PROJECT);
            if (projectFile.fetchInfo().exists()) {
                this.fDotProjectBackup = this.createBackup(projectFile, "project-desc");
            }
            if ((classpathFile = file.getChild(".settings").getChild(".jsdtscope")).fetchInfo().exists()) {
                this.fDotClasspathBackup = this.createBackup(classpathFile, "classpath-desc");
            }
        }
    }

    private void restoreExistingFiles(URI projectLocation, IProgressMonitor monitor) throws CoreException {
        int ticks = ((this.fDotProjectBackup != null ? 1 : 0) + (this.fDotClasspathBackup != null ? 1 : 0)) * 2;
        monitor.beginTask("", ticks);
        try {
            IFileStore projectFile = EFS.getStore((URI)projectLocation).getChild(FILENAME_PROJECT);
            projectFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.fDotProjectBackup != null) {
                this.copyFile(this.fDotProjectBackup, projectFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 4, NewWizardMessages.JavaProjectWizardSecondPage_problem_restore_project, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
        try {
            IFileStore classpathFile = EFS.getStore((URI)projectLocation).getChild(".settings").getChild(".jsdtscope");
            classpathFile.delete(0, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (this.fDotClasspathBackup != null) {
                this.copyFile(this.fDotClasspathBackup, classpathFile, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 4, NewWizardMessages.JavaProjectWizardSecondPage_problem_restore_classpath, (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private File createBackup(IFileStore source, String name) throws CoreException {
        try {
            File bak = File.createTempFile("eclipse-" + name, ".bak");
            this.copyFile(source, bak);
            return bak;
        }
        catch (IOException e) {
            Status status = new Status(4, "org.eclipse.wst.jsdt.ui", 4, Messages.format(NewWizardMessages.JavaProjectWizardSecondPage_problem_backup, name), (Throwable)e);
            throw new CoreException((IStatus)status);
        }
    }

    private void copyFile(IFileStore source, File target) throws IOException, CoreException {
        InputStream is = source.openInputStream(0, null);
        FileOutputStream os = new FileOutputStream(target);
        this.copyFile(is, os);
    }

    private void copyFile(File source, IFileStore target, IProgressMonitor monitor) throws IOException, CoreException {
        FileInputStream is = new FileInputStream(source);
        OutputStream os = target.openOutputStream(0, monitor);
        this.copyFile(is, os);
    }

    private void copyFile(InputStream is, OutputStream os) throws IOException {
        try {
            int bytesRead;
            byte[] buffer = new byte[8192];
            while ((bytesRead = is.read(buffer)) != -1) {
                os.write(buffer, 0, bytesRead);
            }
        }
        finally {
            try {
                is.close();
            }
            finally {
                os.close();
            }
        }
    }

    public void performFinish(IProgressMonitor monitor) throws CoreException, InterruptedException {
        try {
            monitor.beginTask(NewWizardMessages.JavaProjectWizardSecondPage_operation_create, 3);
            if (this.fCurrProject == null) {
                this.updateProject((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            this.configureJavaProject((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            if (this.fIsAutobuild != null) {
                CoreUtility.enableAutoBuild(this.fIsAutobuild);
                this.fIsAutobuild = null;
            }
        }
    }

    private void removeProject() {
        if (this.fCurrProject == null || !this.fCurrProject.exists()) {
            return;
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                JavaProjectWizardSecondPage.this.doRemoveProject(monitor);
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)new WorkspaceModifyDelegatingOperation(op));
        }
        catch (InvocationTargetException e) {
            String title = NewWizardMessages.JavaProjectWizardSecondPage_error_remove_title;
            String message = NewWizardMessages.JavaProjectWizardSecondPage_error_remove_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        catch (InterruptedException interruptedException) {}
    }

    final void doRemoveProject(IProgressMonitor monitor) throws InvocationTargetException {
        boolean noProgressMonitor;
        boolean bl = noProgressMonitor = this.fCurrProjectLocation == null;
        if (monitor == null || noProgressMonitor) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask(NewWizardMessages.JavaProjectWizardSecondPage_operation_remove, 3);
        try {
            try {
                try {
                    URI projLoc = this.fCurrProject.getLocationURI();
                    boolean removeContent = !this.fKeepContent && this.fCurrProject.isSynchronized(2);
                    this.fCurrProject.delete(removeContent, false, (IProgressMonitor)new SubProgressMonitor(monitor, 2));
                    this.restoreExistingFiles(projLoc, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                finally {
                    CoreUtility.enableAutoBuild(this.fIsAutobuild);
                    this.fIsAutobuild = null;
                }
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
        finally {
            monitor.done();
            this.fCurrProject = null;
            this.fKeepContent = false;
        }
    }

    public void performCancel() {
        this.removeProject();
    }
}

