/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.validation;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.Locale;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.contenttype.ContentTypeIdForJSON;
import org.eclipse.wst.json.core.internal.Logger;
import org.eclipse.wst.json.core.internal.parser.JSONLineTokenizer;
import org.eclipse.wst.json.core.validation.ISeverityProvider;
import org.eclipse.wst.json.core.validation.JSONSyntaxValidatorHelper;
import org.eclipse.wst.sse.core.StructuredModelManager;
import org.eclipse.wst.sse.core.internal.document.DocumentReader;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.validation.AbstractValidator;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.ValidationState;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class JSONSyntaxValidator
extends AbstractValidator
implements IValidator,
ISeverityProvider {
    private IReporter fReporter;
    private IContentType jsonContentType;

    public void cleanup(IReporter reporter) {
        this.jsonContentType = null;
    }

    public void validate(IValidationContext helper, IReporter reporter) throws ValidationException {
        String[] uris = helper.getURIs();
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (uris.length > 0) {
            IFile currentFile = null;
            int i = 0;
            while (i < uris.length && !reporter.isCancelled()) {
                Path path = new Path(uris[i]);
                if (path.segmentCount() > 1) {
                    currentFile = root.getFile((IPath)path);
                    if (this.shouldValidate((IResource)currentFile, true)) {
                        this.validateFile(currentFile, reporter);
                    }
                } else if (uris.length == 1) {
                    this.validateProject(helper, reporter);
                }
                ++i;
            }
        } else {
            this.validateProject(helper, reporter);
        }
    }

    public ValidationResult validate(IResource resource, int kind, ValidationState state, IProgressMonitor monitor) {
        if (resource.getType() != 1) {
            return null;
        }
        ValidationResult result = new ValidationResult();
        this.fReporter = result.getReporter(monitor);
        this.validateFile((IFile)resource, this.fReporter);
        return result;
    }

    public IReporter validate(IResource resource, int kind, ValidationState state) {
        this.validate(resource, kind, state, (IProgressMonitor)new NullProgressMonitor());
        return this.fReporter;
    }

    private void validateFile(IFile file, IReporter reporter) {
        LocalizedMessage message = new LocalizedMessage(4, file.getFullPath().toString().substring(1));
        reporter.displaySubtask((IValidator)this, (IMessage)message);
        JSONLineTokenizer tokenizer = null;
        try {
            IStructuredModel model = StructuredModelManager.getModelManager().getExistingModelForRead(file);
            try {
                tokenizer = model == null ? new JSONLineTokenizer(new BufferedReader(new InputStreamReader(file.getContents(true), this.getCharset(file)))) : new JSONLineTokenizer(new BufferedReader(new DocumentReader(model.getStructuredDocument())));
                JSONSyntaxValidatorHelper.validate(tokenizer, reporter, this, this);
            }
            finally {
                if (model != null) {
                    model.releaseFromRead();
                    model = null;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
    }

    private void validateProject(IValidationContext helper, final IReporter reporter) {
        if (helper instanceof IWorkbenchContext) {
            IProject project = ((IWorkbenchContext)helper).getProject();
            IResourceProxyVisitor visitor = new IResourceProxyVisitor(){

                public boolean visit(IResourceProxy proxy) throws CoreException {
                    if (JSONSyntaxValidator.this.shouldValidate(proxy)) {
                        JSONSyntaxValidator.this.validateFile((IFile)proxy.requestResource(), reporter);
                    }
                    return true;
                }
            };
            try {
                project.accept(visitor, 2);
            }
            catch (CoreException e) {
                Logger.logException(e);
            }
        }
    }

    private boolean shouldValidate(IResourceProxy proxy) {
        String name;
        if (proxy.getType() == 1 && (name = proxy.getName()).toLowerCase(Locale.US).endsWith(".json")) {
            return true;
        }
        return this.shouldValidate(proxy.requestResource(), false);
    }

    private boolean shouldValidate(IResource file, boolean checkExtension) {
        String extension;
        if (file == null || !file.exists() || file.getType() != 1) {
            return false;
        }
        if (checkExtension && (extension = file.getFileExtension()) != null && "json".endsWith(extension.toLowerCase(Locale.US))) {
            return true;
        }
        IContentDescription contentDescription = null;
        try {
            contentDescription = ((IFile)file).getContentDescription();
            if (contentDescription != null) {
                IContentType contentType = contentDescription.getContentType();
                return contentDescription != null && contentType.isKindOf(this.getJSONContentType());
            }
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
        return false;
    }

    private IContentType getJSONContentType() {
        if (this.jsonContentType == null) {
            this.jsonContentType = Platform.getContentTypeManager().getContentType(ContentTypeIdForJSON.ContentTypeID_JSON);
        }
        return this.jsonContentType;
    }

    private String getCharset(IFile file) {
        if (file != null && file.isAccessible()) {
            try {
                return file.getCharset(true);
            }
            catch (CoreException coreException) {}
        }
        return ResourcesPlugin.getEncoding();
    }

    @Override
    public int getSeverity(String preferenceName) {
        return this.getPluginPreference().getInt(preferenceName);
    }

    private Preferences getPluginPreference() {
        return JSONCorePlugin.getDefault().getPluginPreferences();
    }
}

