/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.parser.regions;

import org.eclipse.wst.sse.core.internal.provisional.events.RegionChangedEvent;
import org.eclipse.wst.sse.core.internal.provisional.events.StructuredDocumentEvent;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.util.Utilities;
import org.eclipse.wst.xml.core.internal.parser.regions.RegionToStringUtil;
import org.eclipse.wst.xml.core.internal.parser.regions.RegionUpdateRule;

public class XMLCDataTextRegion
implements ITextRegion {
    private static final String fType = "XML_CDATA_TEXT";
    private int fLength;
    private int fStart;
    private int fTextLength;

    public XMLCDataTextRegion() {
    }

    public XMLCDataTextRegion(int start, int textLength, int length) {
        this();
        this.fStart = start;
        this.fTextLength = textLength;
        this.fLength = length;
    }

    public void adjustLength(int i) {
        this.fLength += i;
    }

    public void adjustStart(int i) {
        this.fStart += i;
    }

    public void adjustTextLength(int i) {
        this.fTextLength += i;
    }

    public void equatePositions(ITextRegion region) {
        this.fStart = region.getStart();
        this.fLength = region.getLength();
        this.fTextLength = region.getTextLength();
    }

    public int getEnd() {
        return this.fStart + this.fLength;
    }

    public int getLength() {
        return this.fLength;
    }

    public int getStart() {
        return this.fStart;
    }

    public int getTextEnd() {
        return this.fStart + this.fTextLength;
    }

    public int getTextLength() {
        return this.fTextLength;
    }

    public String getType() {
        return fType;
    }

    public String toString() {
        return RegionToStringUtil.toString(this);
    }

    public StructuredDocumentEvent updateRegion(Object requester, IStructuredDocumentRegion parent, String changes, int requestStart, int lengthToReplace) {
        RegionChangedEvent result = null;
        boolean canHandle = false;
        canHandle = changes == null || changes.length() == 0 ? this.fStart < this.getTextEnd() && Math.abs(lengthToReplace) < this.getTextEnd() - this.getStart() : RegionUpdateRule.canHandleAsWhiteSpace(this, parent, changes, requestStart, lengthToReplace) || RegionUpdateRule.canHandleAsLetterOrDigit(this, parent, changes, requestStart, lengthToReplace);
        if (canHandle) {
            int lengthDifference = Utilities.calculateLengthDifference(changes, lengthToReplace);
            if (!RegionUpdateRule.canHandleAsWhiteSpace(this, parent, changes, requestStart, lengthToReplace)) {
                this.fTextLength += lengthDifference;
            }
            this.fLength += lengthDifference;
            result = new RegionChangedEvent(parent.getParentDocument(), requester, parent, this, changes, requestStart, lengthToReplace);
        }
        return result;
    }
}

