/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.msg.XMLMessageFormatter;
import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.parsers.XIncludeAwareParserConfiguration;
import org.apache.xerces.util.MessageFormatter;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLResourceIdentifier;
import org.apache.xerces.xni.XNIException;
import org.apache.xerces.xni.parser.XMLEntityResolver;
import org.apache.xerces.xni.parser.XMLInputSource;
import org.apache.xerces.xni.parser.XMLParserConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.validation.ValidationResult;
import org.eclipse.wst.validation.internal.ValOperation;
import org.eclipse.wst.validation.internal.operations.LocalizedMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.xml.core.internal.Logger;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.contentmodel.modelquery.IExternalSchemaLocationProvider;
import org.eclipse.wst.xml.core.internal.contentmodel.modelqueryimpl.ExternalSchemaLocationProviderRegistry;
import org.eclipse.wst.xml.core.internal.validation.StreamingMarkupValidator;
import org.eclipse.wst.xml.core.internal.validation.ValidatorHelper;
import org.eclipse.wst.xml.core.internal.validation.XMLNestedValidatorContext;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationConfiguration;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationInfo;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationMessages;
import org.eclipse.wst.xml.core.internal.validation.XMLValidationReport;
import org.eclipse.wst.xml.core.internal.validation.core.LazyURLInputStream;
import org.eclipse.wst.xml.core.internal.validation.core.NestedValidatorContext;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.helpers.DefaultHandler;

public class XMLValidator {
    protected URIResolver uriResolver = null;
    protected Hashtable ingoredErrorKeyTable = new Hashtable();
    protected Set adjustLocationErrorKeySet = new TreeSet();
    protected static final String IGNORE_ALWAYS = "IGNORE_ALWAYS";
    protected static final String IGNORE_IF_DTD_WITHOUT_ELEMENT_DECL = "IGNORE_IF_DTD_WITHOUT_ELEMENT_DECL";
    protected static final String PREMATURE_EOF = "PrematureEOF";
    protected static final String ROOT_ELEMENT_TYPE_MUST_MATCH_DOCTYPEDECL = "RootElementTypeMustMatchDoctypedecl";
    protected static final String MSG_ELEMENT_NOT_DECLARED = "MSG_ELEMENT_NOT_DECLARED";
    protected static final String NO_GRAMMAR_FOUND = "NO_GRAMMAR_FOUND";
    protected static final String NO_DOCUMENT_ELEMENT_FOUND = "NO_DOCUMENT_ELEMENT_FOUND";
    private static final String FILE_NOT_FOUND_KEY = "FILE_NOT_FOUND";
    private StreamingMarkupValidator val = new StreamingMarkupValidator();
    private final String ANNOTATIONMSG;
    private static final boolean _trace = Boolean.valueOf(Platform.getDebugOption((String)"org.eclipse.wst.xml.core/externalSchemaLocation"));
    static /* synthetic */ Class class$0;

    public XMLValidator() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.wst.xml.core.internal.validation.AnnotationMsg");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.ANNOTATIONMSG = clazz.getName();
        this.ingoredErrorKeyTable.put(PREMATURE_EOF, IGNORE_ALWAYS);
        this.ingoredErrorKeyTable.put(ROOT_ELEMENT_TYPE_MUST_MATCH_DOCTYPEDECL, IGNORE_IF_DTD_WITHOUT_ELEMENT_DECL);
        this.ingoredErrorKeyTable.put(MSG_ELEMENT_NOT_DECLARED, IGNORE_IF_DTD_WITHOUT_ELEMENT_DECL);
        this.adjustLocationErrorKeySet.add("MSG_CONTENT_INVALID");
        this.adjustLocationErrorKeySet.add("MSG_CONTENT_INCOMPLETE");
        this.adjustLocationErrorKeySet.add("cvc-complex-type.2.4.b");
        this.adjustLocationErrorKeySet.add("cvc-complex-type.2.3");
    }

    public void setURIResolver(URIResolver uriResolver) {
        this.uriResolver = uriResolver;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected XMLReader createXMLReader(final XMLValidationInfo valinfo, XMLEntityResolver entityResolver) throws Exception {
        SAXParser reader = null;
        ClassLoader prevClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            try {
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                MyStandardParserConfiguration configuration = new MyStandardParserConfiguration(valinfo);
                reader = new SAXParser((XMLParserConfiguration)configuration){
                    private XMLLocator locator = null;

                    public void startDocument(XMLLocator theLocator, String encoding, NamespaceContext nscontext, Augmentations augs) {
                        this.locator = theLocator;
                        valinfo.setXMLLocator(theLocator);
                        super.startDocument(theLocator, encoding, nscontext, augs);
                    }

                    public void startElement(QName element, XMLAttributes attributes, Augmentations augs) throws XNIException {
                        valinfo.getStartElementLocations().push(new LocationCoordinate(this.locator.getLineNumber(), this.locator.getColumnNumber()));
                        super.startElement(element, attributes, augs);
                    }

                    public void endElement(QName element, Augmentations augs) throws XNIException {
                        super.endElement(element, augs);
                        valinfo.getStartElementLocations().pop();
                    }
                };
                reader.setFeature("http://apache.org/xml/features/continue-after-fatal-error", false);
                reader.setFeature("http://xml.org/sax/features/namespace-prefixes", valinfo.isNamespaceEncountered());
                reader.setFeature("http://xml.org/sax/features/namespaces", valinfo.isNamespaceEncountered());
                reader.setContentHandler(new DefaultHandler(){

                    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                        valinfo.getErrorCustomizationManager().startElement(uri, localName);
                    }

                    public void endElement(String uri, String localName, String qName) throws SAXException {
                        valinfo.getErrorCustomizationManager().endElement(uri, localName);
                    }
                });
                if (entityResolver != null) {
                    reader.setProperty("http://apache.org/xml/properties/internal/entity-resolver", entityResolver);
                }
                reader.setProperty("http://xml.org/sax/properties/declaration-handler", new MyDeclHandler());
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            Thread.currentThread().setContextClassLoader(prevClassLoader);
            throw throwable;
        }
        {
            Object var6_9 = null;
            Thread.currentThread().setContextClassLoader(prevClassLoader);
            return reader;
        }
    }

    public XMLValidationReport validate(String uri) {
        return this.validate(uri, null, new XMLValidationConfiguration());
    }

    final String createStringForInputStream(InputStream inputStream) {
        StringBuffer fileString = new StringBuffer();
        try {
            InputStreamReader inputReader = new InputStreamReader(inputStream, "UTF-8");
            BufferedReader reader = new BufferedReader(inputReader);
            char[] chars = new char[1024];
            int numberRead = reader.read(chars);
            while (numberRead != -1) {
                fileString.append(chars, 0, numberRead);
                numberRead = reader.read(chars);
            }
        }
        catch (Exception exception) {}
        return fileString.toString();
    }

    public XMLValidationReport validate(String uri, InputStream inputStream) {
        return this.validate(uri, inputStream, new XMLValidationConfiguration());
    }

    public XMLValidationReport validate(String uri, InputStream inputStream, XMLValidationConfiguration configuration) {
        return this.validate(uri, inputStream, configuration, null);
    }

    public XMLValidationReport validate(String uri, InputStream inputStream, XMLValidationConfiguration configuration, ValidationResult result) {
        return this.validate(uri, inputStream, configuration, null, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLValidationReport validate(String uri, InputStream inputStream, XMLValidationConfiguration configuration, ValidationResult result, NestedValidatorContext context) {
        IReporter reporter;
        String grammarFile = "";
        StringReader reader1 = null;
        StringReader reader2 = null;
        if (inputStream != null) {
            String string = this.createStringForInputStream(inputStream);
            reader1 = new StringReader(string);
            reader2 = new StringReader(string);
        }
        XMLValidationInfo valinfo = new XMLValidationInfo(uri);
        MyEntityResolver entityResolver = new MyEntityResolver(this.uriResolver, context);
        ValidatorHelper helper = new ValidatorHelper();
        try {
            boolean isGrammarEncountered;
            helper.computeValidationInformation(uri, reader1, this.uriResolver);
            valinfo.setDTDEncountered(helper.isDTDEncountered);
            valinfo.setElementDeclarationCount(helper.numDTDElements);
            valinfo.setNamespaceEncountered(helper.isNamespaceEncountered);
            valinfo.setGrammarEncountered(helper.isGrammarEncountered);
            XMLReader reader = this.createXMLReader(valinfo, entityResolver);
            if (configuration.getFeature("HONOUR_ALL_SCHEMA_LOCATIONS")) {
                reader.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", true);
            }
            if (configuration.getFeature("USE_XINCLUDE")) {
                reader.setFeature("http://apache.org/xml/features/xinclude", true);
            }
            if (!(isGrammarEncountered = helper.isGrammarEncountered)) {
                isGrammarEncountered = this.checkExternalSchemas(reader, valinfo.getFileURI());
            }
            reader.setFeature("http://xml.org/sax/features/validation", isGrammarEncountered);
            reader.setFeature("http://apache.org/xml/features/validation/schema", isGrammarEncountered);
            XMLErrorHandler errorhandler = new XMLErrorHandler(valinfo);
            reader.setErrorHandler(errorhandler);
            InputSource inputSource = new InputSource(uri);
            inputSource.setCharacterStream(reader2);
            ClassLoader originalClzLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                reader.parse(inputSource);
            }
            catch (Throwable throwable) {
                Object var17_24 = null;
                Thread.currentThread().setContextClassLoader(originalClzLoader);
                throw throwable;
            }
            {
                Object var17_25 = null;
                Thread.currentThread().setContextClassLoader(originalClzLoader);
            }
            if (configuration.getIntFeature("INDICATE_NO_GRAMMAR") > 0 && valinfo.isValid() && !isGrammarEncountered) {
                if (configuration.getIntFeature("INDICATE_NO_GRAMMAR") == 1) {
                    valinfo.addWarning(XMLValidationMessages._WARN_NO_GRAMMAR, 1, 0, uri, NO_GRAMMAR_FOUND, null);
                } else {
                    valinfo.addError(XMLValidationMessages._WARN_NO_GRAMMAR, 1, 0, uri, NO_GRAMMAR_FOUND, null);
                }
            }
            if (configuration.getIntFeature("INDICATE_NO_DOCUMENT_ELEMENT") > 0 && valinfo.isValid() && !helper.isDocumentElementEncountered) {
                if (configuration.getIntFeature("INDICATE_NO_DOCUMENT_ELEMENT") == 1) {
                    valinfo.addWarning(XMLValidationMessages._NO_DOCUMENT_ELEMENT, 1, 0, uri, NO_DOCUMENT_ELEMENT_FOUND, null);
                } else {
                    valinfo.addError(XMLValidationMessages._NO_DOCUMENT_ELEMENT, 1, 0, uri, NO_DOCUMENT_ELEMENT_FOUND, null);
                }
            }
            grammarFile = helper.isDTDEncountered ? entityResolver.getLocation() : helper.schemaLocationString;
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (IOException ioException) {
            this.addValidationMessage(valinfo, ioException);
        }
        catch (Exception exception) {
            Logger.logException(exception.getLocalizedMessage(), exception);
        }
        if (result != null) {
            try {
                IResource resource = this.getWorkspaceFileFromLocation(grammarFile);
                ArrayList<IResource> resources = new ArrayList<IResource>();
                if (resource != null) {
                    resources.add(resource);
                }
                result.setDependsOn(resources.toArray(new IResource[0]));
            }
            catch (Exception e) {
                Logger.logException(e.getLocalizedMessage(), e);
            }
        }
        if (XMLCorePlugin.getDefault().getPluginPreferences().getBoolean("markupValidation") && (reporter = this.executeMarkupValidator(uri)) != null) {
            List msgList = reporter.getMessages();
            int i = 0;
            while (i < msgList.size()) {
                LocalizedMessage msg = (LocalizedMessage)msgList.get(i);
                if (msg.getSeverity() == 2) {
                    valinfo.addError(msg.getLocalizedMessage(), msg.getLineNumber(), msg.getOffset(), valinfo.getFileURI(), "null", this.getMsgArguments(msg));
                } else if (msg.getSeverity() == 1) {
                    valinfo.addWarning(msg.getLocalizedMessage(), msg.getLineNumber(), msg.getOffset(), valinfo.getFileURI(), "null", this.getMsgArguments(msg));
                }
                ++i;
            }
        }
        return valinfo;
    }

    private boolean checkExternalSchemas(XMLReader reader, String fileURI) throws Exception {
        boolean isGrammarEncountered = false;
        StringBuffer schemaLocation = new StringBuffer();
        String noNamespaceSchemaLocation = null;
        IExternalSchemaLocationProvider[] providers = ExternalSchemaLocationProviderRegistry.getInstance().getProviders();
        int i = 0;
        while (i < providers.length) {
            URI uri = null;
            try {
                uri = URIUtil.fromString((String)fileURI);
            }
            catch (URISyntaxException e) {
                Logger.logException(e.getLocalizedMessage(), e);
            }
            if (uri != null) {
                long diff;
                long time = _trace ? System.currentTimeMillis() : 0L;
                Map locations = providers[i].getExternalSchemaLocation(uri);
                if (_trace && (diff = System.currentTimeMillis() - time) > 250L) {
                    Logger.log(1, "Schema location provider took [" + diff + "ms] for URI [" + fileURI + "]");
                }
                if (locations != null && !locations.isEmpty()) {
                    Object path = locations.get("http://apache.org/xml/properties/schema/external-schemaLocation");
                    if (path instanceof String) {
                        if (schemaLocation.length() > 0) {
                            schemaLocation.append(' ');
                        }
                        schemaLocation.append(path);
                    }
                    if ((path = locations.get("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation")) instanceof String) {
                        noNamespaceSchemaLocation = (String)path;
                    }
                }
            }
            ++i;
        }
        if (schemaLocation.length() > 0) {
            reader.setProperty("http://apache.org/xml/properties/schema/external-schemaLocation", schemaLocation.toString());
            isGrammarEncountered = true;
        }
        if (noNamespaceSchemaLocation != null) {
            reader.setProperty("http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation", noNamespaceSchemaLocation);
            isGrammarEncountered = true;
        }
        return isGrammarEncountered;
    }

    private Object[] getMsgArguments(LocalizedMessage msg) {
        Object obj = msg.getAttribute(this.ANNOTATIONMSG);
        return new Object[]{obj};
    }

    private IReporter executeMarkupValidator(String uri) {
        Path path = new Path(uri);
        String fileProtocol = "file://";
        int index = uri.indexOf(fileProtocol);
        IFile resource = null;
        if (index == 0) {
            String transformedUri = uri.substring(fileProtocol.length());
            Path transformedPath = new Path(transformedUri);
            resource = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)transformedPath);
        } else {
            resource = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)path);
        }
        IReporter reporter = null;
        if (resource != null) {
            reporter = this.val.validate((IResource)resource, 0, new ValOperation().getState());
        }
        return reporter;
    }

    protected void addValidationMessage(XMLValidationInfo valinfo, IOException exception) {
        String validationMessageStr = exception.getMessage();
        Throwable cause = exception.getCause() != null ? exception.getCause() : exception;
        while (validationMessageStr == null && cause != null) {
            String localizedMessage = cause.getLocalizedMessage();
            if ((cause = cause.getCause()) != null || localizedMessage == null) continue;
            validationMessageStr = localizedMessage;
        }
        if (validationMessageStr != null) {
            if (cause instanceof FileNotFoundException) {
                validationMessageStr = NLS.bind((String)XMLValidationMessages._UI_PROBLEMS_VALIDATING_FILE_NOT_FOUND, (Object[])new Object[]{validationMessageStr});
            } else if (cause instanceof UnknownHostException) {
                validationMessageStr = NLS.bind((String)XMLValidationMessages._UI_PROBLEMS_VALIDATING_UNKNOWN_HOST, (Object[])new Object[]{validationMessageStr});
            } else if (cause instanceof ConnectException) {
                validationMessageStr = XMLValidationMessages._UI_PROBLEMS_CONNECTION_REFUSED;
            }
        }
        if (validationMessageStr != null) {
            XMLLocator locator = valinfo.getXMLLocator();
            valinfo.addWarning(validationMessageStr, locator != null ? locator.getLineNumber() : 1, locator != null ? locator.getColumnNumber() : 0, valinfo.getFileURI(), FILE_NOT_FOUND_KEY, null);
        }
    }

    protected void addValidationMessage(XMLValidationInfo valinfo, SAXParseException exception) {
        if (exception.getMessage() != null) {
            valinfo.addError(exception.getLocalizedMessage(), exception.getLineNumber(), exception.getColumnNumber(), exception.getSystemId());
        }
    }

    public static XMLInputSource _internalResolveEntity(URIResolver uriResolver, XMLResourceIdentifier rid) throws IOException {
        return XMLValidator._internalResolveEntity(uriResolver, rid, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static XMLInputSource _internalResolveEntity(URIResolver uriResolver, XMLResourceIdentifier rid, NestedValidatorContext context) throws IOException {
        XMLInputSource is;
        block11: {
            String physical;
            block10: {
                XMLNestedValidatorContext xmlContext;
                is = null;
                if (uriResolver == null) break block11;
                String id = rid.getPublicId();
                if (id == null) {
                    id = rid.getNamespace();
                }
                String location = null;
                if (id != null || rid.getLiteralSystemId() != null) {
                    location = uriResolver.resolve(rid.getBaseSystemId(), id, rid.getLiteralSystemId());
                }
                if (location == null) break block11;
                physical = uriResolver.resolvePhysicalLocation(rid.getBaseSystemId(), id, location);
                if (context instanceof XMLNestedValidatorContext && (xmlContext = (XMLNestedValidatorContext)context).isURIMarkedInaccessible(physical)) {
                    throw new FileNotFoundException(physical);
                }
                is = new XMLInputSource(rid.getPublicId(), location, location);
                InputStream isTemp = null;
                try {
                    try {
                        isTemp = new URL(physical).openStream();
                    }
                    catch (IOException e) {
                        if (context instanceof XMLNestedValidatorContext) {
                            XMLNestedValidatorContext xmlContext2 = (XMLNestedValidatorContext)context;
                            xmlContext2.markURIInaccessible(physical);
                        }
                        throw e;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (isTemp != null) {
                        isTemp.close();
                    }
                    throw throwable;
                }
                {
                    Object var10_12 = null;
                    if (isTemp == null) break block10;
                }
                isTemp.close();
            }
            is.setByteStream((InputStream)new LazyURLInputStream(physical));
        }
        return is;
    }

    protected IResource getWorkspaceFileFromLocation(String location) {
        if (location == null) {
            return null;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        Path canonicalForm = new Path(location);
        Path pathLocation = new Path(URIHelper.removeProtocol(canonicalForm.toString()));
        IFile resourceFile = workspace.getRoot().getFileForLocation((IPath)pathLocation);
        return resourceFile;
    }

    protected class LocationCoordinate {
        private int lineNo = -1;
        private int columnNo = -1;

        public LocationCoordinate(int lineNumber, int columnNumber) {
            this.lineNo = lineNumber;
            this.columnNo = columnNumber;
        }

        public int getLineNumber() {
            return this.lineNo;
        }

        public int getColumnNumner() {
            return this.columnNo;
        }
    }

    protected class MyDeclHandler
    implements DeclHandler {
        public void attributeDecl(String eName, String aName, String type, String valueDefault, String value) {
        }

        public void elementDecl(String name, String model) {
        }

        public void externalEntityDecl(String name, String publicId, String systemId) {
        }

        public void internalEntityDecl(String name, String value) {
        }
    }

    protected class MyEntityResolver
    implements XMLEntityResolver {
        private URIResolver uriResolver;
        private String resolvedDTDLocation;
        private NestedValidatorContext context;

        public MyEntityResolver(URIResolver uriResolver, NestedValidatorContext context) {
            this.uriResolver = uriResolver;
            this.context = context;
        }

        public XMLInputSource resolveEntity(XMLResourceIdentifier rid) throws XNIException, IOException {
            XMLInputSource inputSource = XMLValidator._internalResolveEntity(this.uriResolver, rid, this.context);
            if (inputSource != null) {
                this.resolvedDTDLocation = inputSource.getSystemId();
            }
            return inputSource;
        }

        public String getLocation() {
            return this.resolvedDTDLocation;
        }
    }

    protected class MyStandardParserConfiguration
    extends XIncludeAwareParserConfiguration {
        XMLValidationInfo valinfo = null;
        List reportedExceptions = new ArrayList();

        public MyStandardParserConfiguration(XMLValidationInfo valinfo) {
            this.valinfo = valinfo;
            String xmlCoreId = XMLCorePlugin.getDefault().getBundle().getSymbolicName();
            boolean resolveExternalEntities = InstanceScope.INSTANCE.getNode(xmlCoreId).getBoolean("resolveExternalEntities", false);
            this.setFeature("http://xml.org/sax/features/external-general-entities", resolveExternalEntities);
            this.setFeature("http://xml.org/sax/features/external-parameter-entities", resolveExternalEntities);
            this.resetCommon();
            XMLErrorReporter errorReporter = this.createErrorReporter();
            if (errorReporter.getMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210") == null) {
                XMLMessageFormatter xmft = new XMLMessageFormatter();
                errorReporter.putMessageFormatter("http://www.w3.org/TR/1998/REC-xml-19980210", (MessageFormatter)xmft);
                errorReporter.putMessageFormatter("http://www.w3.org/TR/1999/REC-xml-names-19990114", (MessageFormatter)xmft);
            }
            this.fErrorReporter = errorReporter;
            this.setProperty("http://apache.org/xml/properties/internal/error-reporter", errorReporter);
            this.fCommonComponents.remove(this.fErrorReporter);
            this.fCommonComponents.add(this.fErrorReporter);
        }

        protected XMLErrorReporter createErrorReporter() {
            return new XMLErrorReporter(this){
                final /* synthetic */ MyStandardParserConfiguration this$1;
                {
                    this.this$1 = myStandardParserConfiguration;
                }

                public void reportError(String domain, String key, Object[] arguments, short severity) throws XNIException {
                    Object location;
                    boolean reportError = true;
                    this.this$1.valinfo.setCurrentErrorKey(key);
                    this.this$1.valinfo.setMessageArguments(arguments);
                    String ignoreCondition = (String)MyStandardParserConfiguration.access$0((MyStandardParserConfiguration)this.this$1).ingoredErrorKeyTable.get(key);
                    if (ignoreCondition != null) {
                        boolean isDTDWithoutElementDeclarationEncountered;
                        reportError = ignoreCondition.equals("IGNORE_IF_DTD_WITHOUT_ELEMENT_DECL") ? !(isDTDWithoutElementDeclarationEncountered = this.this$1.valinfo.isDTDWithoutElementDeclarationEncountered()) : false;
                    }
                    if ("schema_reference.4".equals(key) && arguments.length > 0 && (location = arguments[0]) != null) {
                        if (this.this$1.reportedExceptions.contains(location)) {
                            reportError = false;
                        } else {
                            this.this$1.reportedExceptions.add(location);
                        }
                    }
                    if (reportError) {
                        super.reportError(domain, key, arguments, severity);
                        this.this$1.valinfo.getErrorCustomizationManager().considerReportedError(this.this$1.valinfo, key, arguments);
                    }
                }
            };
        }

        static /* synthetic */ XMLValidator access$0(MyStandardParserConfiguration myStandardParserConfiguration) {
            return myStandardParserConfiguration.XMLValidator.this;
        }
    }

    protected class XMLErrorHandler
    implements ErrorHandler {
        private final int ERROR = 0;
        private final int WARNING = 1;
        private XMLValidationInfo valinfo;

        public XMLErrorHandler(XMLValidationInfo valinfo) {
            this.valinfo = valinfo;
        }

        protected void addValidationMessage(SAXParseException exception, int severity) {
            if (exception.getSystemId() != null) {
                int lineNumber = exception.getLineNumber();
                int columnNumber = exception.getColumnNumber();
                String currentErrorKey = this.valinfo.currentErrorKey;
                if (currentErrorKey != null && XMLValidator.this.adjustLocationErrorKeySet.contains(currentErrorKey) && this.valinfo.getStartElementLocations().size() > 0) {
                    LocationCoordinate adjustedCoordinates = (LocationCoordinate)this.valinfo.getStartElementLocations().peek();
                    lineNumber = adjustedCoordinates.getLineNumber();
                    columnNumber = adjustedCoordinates.getColumnNumner();
                }
                if (severity == 1) {
                    this.valinfo.addWarning(exception.getLocalizedMessage(), lineNumber, columnNumber, exception.getSystemId());
                } else {
                    this.valinfo.addError(exception.getLocalizedMessage(), lineNumber, columnNumber, exception.getSystemId(), this.valinfo.getCurrentErrorKey(), this.valinfo.getMessageArguments());
                }
            }
        }

        public void error(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 0);
        }

        public void fatalError(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 0);
        }

        public void warning(SAXParseException exception) throws SAXException {
            this.addValidationMessage(exception, 1);
        }
    }
}

