/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra;

import com.diffplug.common.base.Errors;
import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.LazyForwardingEquality;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.extra.LibExtraPreconditions;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharSequenceNodeFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.attributes.AttributesRule;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

public final class GitAttributesLineEndings {
    private GitAttributesLineEndings() {
    }

    public static LineEnding.Policy create(File projectDir, Supplier<Iterable<File>> toFormat) {
        return new RelocatablePolicy(projectDir, toFormat);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<AttributesRule> parseRules(@Nullable File file) {
        if (file == null) return Collections.emptyList();
        if (!file.exists()) return Collections.emptyList();
        if (!file.isFile()) return Collections.emptyList();
        try (FileInputStream stream = new FileInputStream(file);){
            AttributesNode parsed = new AttributesNode();
            parsed.parse((InputStream)stream);
            List list = parsed.getRules();
            return list;
        }
        catch (IOException e) {
            System.err.println("Problem parsing " + file.getAbsolutePath());
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    @Nullable
    private static String findAttributeInRules(String subpath, boolean isFolder, String key, List<AttributesRule> rules) {
        String value = null;
        for (AttributesRule rule : rules) {
            if (!rule.isMatch(subpath, isFolder)) continue;
            for (Attribute attribute : rule.getAttributes()) {
                if (!attribute.getKey().equals(key)) continue;
                value = attribute.getValue();
            }
        }
        return value;
    }

    static class AttributesCache {
        final Map<File, List<AttributesRule>> rulesAtPath = new HashMap<File, List<AttributesRule>>();

        AttributesCache() {
        }

        @Nullable
        public String valueFor(File file, String key) {
            StringBuilder pathBuilder = new StringBuilder(file.getAbsolutePath().length());
            boolean isDirectory = file.isDirectory();
            pathBuilder.append(file.getName());
            for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
                String path = pathBuilder.toString();
                String value = GitAttributesLineEndings.findAttributeInRules(path, isDirectory, key, this.getRulesForFolder(parent));
                if (value != null) {
                    return value;
                }
                pathBuilder.insert(0, parent.getName() + "/");
            }
            return null;
        }

        private List<AttributesRule> getRulesForFolder(File folder) {
            return this.rulesAtPath.computeIfAbsent(folder, f -> GitAttributesLineEndings.parseRules(new File((File)f, ".gitattributes")));
        }
    }

    static class Runtime {
        final List<AttributesRule> infoRules;
        @Nullable
        final File workTree;
        final AttributesCache cache = new AttributesCache();
        final List<AttributesRule> globalRules;
        final String defaultEnding;
        private static final String KEY_EOL = "eol";
        private static final boolean IS_FOLDER = false;

        private Runtime(List<AttributesRule> infoRules, @Nullable File workTree, Config config, List<AttributesRule> globalRules) {
            this.infoRules = Objects.requireNonNull(infoRules);
            this.workTree = workTree;
            this.defaultEnding = Runtime.fromEol((CoreConfig.EOL)config.getEnum("core", null, KEY_EOL, (Enum)CoreConfig.EOL.NATIVE)).str();
            this.globalRules = Objects.requireNonNull(globalRules);
        }

        public String getEndingFor(File file) {
            String localResult;
            if (this.workTree != null && !this.infoRules.isEmpty()) {
                String subpath;
                String infoResult;
                String rootPath = this.workTree.getAbsolutePath();
                String path = file.getAbsolutePath();
                if (path.startsWith(rootPath) && (infoResult = GitAttributesLineEndings.findAttributeInRules(subpath = path.substring(rootPath.length() + 1), false, KEY_EOL, this.infoRules)) != null) {
                    return Runtime.convertEolToLineEnding(infoResult, file);
                }
            }
            if ((localResult = this.cache.valueFor(file, KEY_EOL)) != null) {
                return Runtime.convertEolToLineEnding(localResult, file);
            }
            String globalResult = GitAttributesLineEndings.findAttributeInRules(file.getAbsolutePath(), false, KEY_EOL, this.globalRules);
            if (globalResult != null) {
                return Runtime.convertEolToLineEnding(globalResult, file);
            }
            return this.defaultEnding;
        }

        private static String convertEolToLineEnding(String eol, File file) {
            switch (eol.toLowerCase(Locale.ROOT)) {
                case "lf": {
                    return LineEnding.UNIX.str();
                }
                case "crlf": {
                    return LineEnding.WINDOWS.str();
                }
            }
            System.err.println(".gitattributes file has unspecified eol value: " + eol + " for " + file + ", defaulting to platform native");
            return LineEnding.PLATFORM_NATIVE.str();
        }

        private static LineEnding fromEol(CoreConfig.EOL eol) {
            switch (eol) {
                case CRLF: {
                    return LineEnding.WINDOWS;
                }
                case LF: {
                    return LineEnding.UNIX;
                }
                case NATIVE: {
                    return LineEnding.PLATFORM_NATIVE;
                }
            }
            throw new IllegalArgumentException("Unknown eol " + eol);
        }
    }

    static class RuntimeInit {
        final FileBasedConfig systemConfig;
        final FileBasedConfig userConfig;
        final FileBasedConfig repoConfig;
        @Nullable
        final File globalAttributesFile;
        @Nullable
        final File repoAttributesFile;
        @Nullable
        final File workTree;

        @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
        RuntimeInit(File projectDir, Iterable<File> toFormat) throws IOException {
            LibExtraPreconditions.requireElementsNonNull(toFormat);
            this.systemConfig = SystemReader.getInstance().openSystemConfig(null, FS.DETECTED);
            Errors.log().run(() -> ((FileBasedConfig)this.systemConfig).load());
            this.userConfig = SystemReader.getInstance().openUserConfig((Config)this.systemConfig, FS.DETECTED);
            Errors.log().run(() -> ((FileBasedConfig)this.userConfig).load());
            String globalAttributesPath = this.userConfig.getString("core", null, "attributesfile");
            if (globalAttributesPath != null) {
                FS fs = FS.detect();
                this.globalAttributesFile = globalAttributesPath.startsWith("~/") ? fs.resolve(fs.userHome(), globalAttributesPath.substring(2)) : fs.resolve(null, globalAttributesPath);
            } else {
                this.globalAttributesFile = null;
            }
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            builder.findGitDir(projectDir);
            if (builder.getGitDir() != null) {
                this.workTree = builder.getWorkTree();
                this.repoConfig = new FileBasedConfig((Config)this.userConfig, new File(builder.getGitDir(), "config"), FS.DETECTED);
                this.repoAttributesFile = new File(builder.getGitDir(), "info/attributes");
            } else {
                this.workTree = null;
                this.repoConfig = new FileBasedConfig((Config)this.userConfig, null, FS.DETECTED){

                    public void load() {
                    }

                    public boolean isOutdated() {
                        return false;
                    }
                };
                this.repoAttributesFile = null;
            }
            Errors.log().run(() -> ((FileBasedConfig)this.repoConfig).load());
        }

        private Runtime atRuntime() {
            return new Runtime(GitAttributesLineEndings.parseRules(this.repoAttributesFile), this.workTree, (Config)this.repoConfig, GitAttributesLineEndings.parseRules(this.globalAttributesFile));
        }
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class CachedEndings
    implements Serializable {
        private static final long serialVersionUID = -2534772773057900619L;
        final transient String rootDir;
        final String defaultEnding;
        final ConcurrentRadixTree<String> hasNonDefaultEnding = new ConcurrentRadixTree((NodeFactory)new DefaultCharSequenceNodeFactory());

        CachedEndings(File projectDir, Runtime runtime, Iterable<File> toFormat) {
            this.rootDir = FileSignature.pathNativeToUnix((String)projectDir.getAbsolutePath()) + "/";
            this.defaultEnding = runtime.defaultEnding;
            for (File file : toFormat) {
                String ending = runtime.getEndingFor(file);
                if (ending.equals(this.defaultEnding)) continue;
                String path = FileSignature.pathNativeToUnix((String)file.getAbsolutePath());
                this.hasNonDefaultEnding.put((CharSequence)path, (Object)ending);
            }
        }

        public String endingFor(File file) {
            String path = FileSignature.pathNativeToUnix((String)file.getAbsolutePath());
            String subpath = FileSignature.subpath((String)this.rootDir, (String)path);
            String ending = (String)this.hasNonDefaultEnding.getValueForExactKey((CharSequence)subpath);
            return ending == null ? this.defaultEnding : ending;
        }
    }

    static class RelocatablePolicy
    extends LazyForwardingEquality<CachedEndings>
    implements LineEnding.Policy {
        private static final long serialVersionUID = 5868522122123693015L;
        final transient File projectDir;
        final transient Supplier<Iterable<File>> toFormat;

        RelocatablePolicy(File projectDir, Supplier<Iterable<File>> toFormat) {
            this.projectDir = Objects.requireNonNull(projectDir, "projectDir");
            this.toFormat = Objects.requireNonNull(toFormat, "toFormat");
        }

        protected CachedEndings calculateState() throws Exception {
            Runtime runtime = new RuntimeInit(this.projectDir, this.toFormat.get()).atRuntime();
            return new CachedEndings(this.projectDir, runtime, this.toFormat.get());
        }

        public String getEndingFor(File file) {
            return ((CachedEndings)this.state()).endingFor(file);
        }
    }
}

