/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.cpp;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import java.lang.reflect.Method;
import java.util.Properties;

public final class EclipseCdtFormatterStep {
    private static final String NAME = "eclipse cdt formatter";
    private static final String FORMATTER_CLASS = "com.diffplug.spotless.extra.eclipse.cdt.EclipseCdtFormatterStepImpl";
    private static final String FORMATTER_METHOD = "format";
    private static final Jvm.Support<String> JVM_SUPPORT = Jvm.support((String)"eclipse cdt formatter").add(8, (Object)"4.16.0").add(11, (Object)"4.20.0");

    private EclipseCdtFormatterStep() {
    }

    public static String defaultVersion() {
        return (String)JVM_SUPPORT.getRecommendedFormatterVersion();
    }

    public static EclipseBasedStepBuilder createBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)EclipseCdtFormatterStep::apply));
    }

    private static FormatterFunc apply(EclipseBasedStepBuilder.State state) throws Exception {
        JVM_SUPPORT.assertFormatterSupported((Object)state.getSemanticVersion());
        Class<?> formatterClazz = state.loadClass(FORMATTER_CLASS);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class);
        return JVM_SUPPORT.suggestLaterVersionOnError((Object)state.getSemanticVersion(), input -> (String)method.invoke(formatter, input));
    }
}

