/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.groovy;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public final class GrEclipseFormatterStep {
    private static final String NAME = "eclipse groovy formatter";
    private static final String FORMATTER_CLASS = "com.diffplug.spotless.extra.eclipse.groovy.GrEclipseFormatterStepImpl";
    private static final String FORMATTER_CLASS_OLD = "com.diffplug.gradle.spotless.groovy.eclipse.GrEclipseFormatterStepImpl";
    private static final String MAVEN_GROUP_ARTIFACT = "com.diffplug.spotless:spotless-eclipse-groovy";
    private static final Jvm.Support<String> JVM_SUPPORT = Jvm.support((String)"eclipse groovy formatter").add(8, (Object)"4.19.0").add(11, (Object)"4.21.0");
    private static final String FORMATTER_METHOD = "format";

    private GrEclipseFormatterStep() {
    }

    public static String defaultVersion() {
        return (String)JVM_SUPPORT.getRecommendedFormatterVersion();
    }

    public static EclipseBasedStepBuilder createBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)GrEclipseFormatterStep::apply));
    }

    private static FormatterFunc apply(EclipseBasedStepBuilder.State state) throws Exception {
        JVM_SUPPORT.assertFormatterSupported((Object)state.getSemanticVersion());
        Class<?> formatterClazz = GrEclipseFormatterStep.getClass(state);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class);
        return JVM_SUPPORT.suggestLaterVersionOnError((Object)state.getSemanticVersion(), input -> {
            try {
                return (String)method.invoke(formatter, input);
            }
            catch (InvocationTargetException exceptionWrapper) {
                Throwable throwable = exceptionWrapper.getTargetException();
                Exception exception = throwable instanceof Exception ? (Exception)throwable : null;
                throw null == exception ? exceptionWrapper : exception;
            }
        });
    }

    private static Class<?> getClass(EclipseBasedStepBuilder.State state) {
        if (state.getMavenCoordinate(MAVEN_GROUP_ARTIFACT).isPresent()) {
            return state.loadClass(FORMATTER_CLASS);
        }
        return state.loadClass(FORMATTER_CLASS_OLD);
    }
}

