/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.wtp;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public enum EclipseWtpFormatterStep {
    CSS("EclipseCssFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithoutFile)),
    HTML("EclipseHtmlFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithoutFile)),
    JS("EclipseJsFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithoutFile)),
    JSON("EclipseJsonFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithoutFile)),
    XML("EclipseXmlFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithFile));

    private static final String NAME = "eclipse wtp formatters";
    private static final String FORMATTER_PACKAGE = "com.diffplug.spotless.extra.eclipse.wtp.";
    private static final String DEFAULT_VERSION = "4.17.0";
    private static final String FORMATTER_METHOD = "format";
    private final String implementationClassName;
    private final ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc> formatterCall;

    private EclipseWtpFormatterStep(String implementationClassName, ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc> formatterCall) {
        this.implementationClassName = implementationClassName;
        this.formatterCall = formatterCall;
    }

    public EclipseBasedStepBuilder createBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, " - " + this.toString(), provisioner, (ThrowingEx.Function<EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.Function)state -> (FormatterFunc)this.formatterCall.apply((Object)this.implementationClassName, state)));
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private static FormatterFunc applyWithoutFile(String className, EclipseBasedStepBuilder.State state) throws Exception {
        Class<?> formatterClazz = state.loadClass(FORMATTER_PACKAGE + className);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class);
        return input -> {
            try {
                return (String)method.invoke(formatter, input);
            }
            catch (InvocationTargetException exceptionWrapper) {
                Throwable throwable = exceptionWrapper.getTargetException();
                Exception exception = throwable instanceof Exception ? (Exception)throwable : null;
                throw null == exception ? exceptionWrapper : exception;
            }
        };
    }

    private static FormatterFunc.NeedsFile applyWithFile(String className, EclipseBasedStepBuilder.State state) throws Exception {
        Class<?> formatterClazz = state.loadClass(FORMATTER_PACKAGE + className);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class, String.class);
        return (unixString, file) -> {
            try {
                return (String)method.invoke(formatter, unixString, file.getAbsolutePath());
            }
            catch (InvocationTargetException exceptionWrapper) {
                Throwable throwable = exceptionWrapper.getTargetException();
                Exception exception = throwable instanceof Exception ? (Exception)throwable : null;
                throw null == exception ? exceptionWrapper : exception;
            }
        };
    }
}

