/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra;

import com.diffplug.common.base.Errors;
import com.diffplug.common.tree.TreeStream;
import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.LazyForwardingEquality;
import com.diffplug.spotless.LineEnding;
import com.googlecode.concurrenttrees.radix.ConcurrentRadixTree;
import com.googlecode.concurrenttrees.radix.node.Node;
import com.googlecode.concurrenttrees.radix.node.NodeFactory;
import com.googlecode.concurrenttrees.radix.node.concrete.DefaultCharSequenceNodeFactory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.AttributesNode;
import org.eclipse.jgit.attributes.AttributesRule;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.storage.file.FileBasedConfig;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.SystemReader;

public final class GitAttributesLineEndings {
    private GitAttributesLineEndings() {
    }

    public static Policy create(File projectDir, Supplier<Iterable<File>> toFormat) {
        return new Policy(projectDir, toFormat);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<AttributesRule> parseRules(@Nullable File file) {
        if (file == null) return Collections.emptyList();
        if (!file.exists()) return Collections.emptyList();
        if (!file.isFile()) return Collections.emptyList();
        try (FileInputStream stream = new FileInputStream(file);){
            AttributesNode parsed = new AttributesNode();
            parsed.parse((InputStream)stream);
            List list = parsed.getRules();
            return list;
        }
        catch (IOException e) {
            System.err.println("Problem parsing " + file.getAbsolutePath());
            e.printStackTrace();
        }
        return Collections.emptyList();
    }

    @Nullable
    private static String findAttributeInRules(String subpath, boolean isFolder, String key, List<AttributesRule> rules) {
        String value = null;
        for (AttributesRule rule : rules) {
            if (!rule.isMatch(subpath, isFolder)) continue;
            for (Attribute attribute : rule.getAttributes()) {
                if (!attribute.getKey().equals(key)) continue;
                value = attribute.getValue();
            }
        }
        return value;
    }

    static class AttributesCache {
        final Map<File, List<AttributesRule>> rulesAtPath = new HashMap<File, List<AttributesRule>>();

        AttributesCache() {
        }

        @Nullable
        public String valueFor(File file, String key) {
            StringBuilder pathBuilder = new StringBuilder(file.getAbsolutePath().length());
            boolean isDirectory = file.isDirectory();
            pathBuilder.append(file.getName());
            for (File parent = file.getParentFile(); parent != null; parent = parent.getParentFile()) {
                String path = pathBuilder.toString();
                String value = GitAttributesLineEndings.findAttributeInRules(path, isDirectory, key, this.getRulesForFolder(parent));
                if (value != null) {
                    return value;
                }
                pathBuilder.insert(0, parent.getName() + "/");
            }
            return null;
        }

        private List<AttributesRule> getRulesForFolder(File folder) {
            return this.rulesAtPath.computeIfAbsent(folder, f -> GitAttributesLineEndings.parseRules(new File((File)f, ".gitattributes")));
        }
    }

    static class Runtime {
        final List<AttributesRule> infoRules;
        @Nullable
        final File workTree;
        final AttributesCache cache = new AttributesCache();
        final List<AttributesRule> globalRules;
        final String defaultEnding;
        private static final String KEY_EOL = "eol";
        private static final boolean IS_FOLDER = false;

        private Runtime(List<AttributesRule> infoRules, @Nullable File workTree, Config config, List<AttributesRule> globalRules) {
            this.infoRules = Objects.requireNonNull(infoRules);
            this.workTree = workTree;
            this.defaultEnding = Runtime.fromEol((CoreConfig.EOL)config.getEnum("core", null, KEY_EOL, (Enum)CoreConfig.EOL.NATIVE)).str();
            this.globalRules = Objects.requireNonNull(globalRules);
        }

        public String getEndingFor(File file) {
            String localResult;
            if (this.workTree != null && !this.infoRules.isEmpty()) {
                String subpath;
                String infoResult;
                String rootPath = this.workTree.getAbsolutePath();
                String path = file.getAbsolutePath();
                if (path.startsWith(rootPath) && (infoResult = GitAttributesLineEndings.findAttributeInRules(subpath = path.substring(rootPath.length() + 1), false, KEY_EOL, this.infoRules)) != null) {
                    return Runtime.convertEolToLineEnding(infoResult, file);
                }
            }
            if ((localResult = this.cache.valueFor(file, KEY_EOL)) != null) {
                return Runtime.convertEolToLineEnding(localResult, file);
            }
            String globalResult = GitAttributesLineEndings.findAttributeInRules(file.getAbsolutePath(), false, KEY_EOL, this.globalRules);
            if (globalResult != null) {
                return Runtime.convertEolToLineEnding(globalResult, file);
            }
            return this.defaultEnding;
        }

        private static String convertEolToLineEnding(String eol, File file) {
            switch (eol.toLowerCase(Locale.ROOT)) {
                case "lf": {
                    return LineEnding.UNIX.str();
                }
                case "crlf": {
                    return LineEnding.WINDOWS.str();
                }
            }
            System.err.println(".gitattributes file has unspecified eol value: " + eol + " for " + file + ", defaulting to platform native");
            return LineEnding.PLATFORM_NATIVE.str();
        }

        private static LineEnding fromEol(CoreConfig.EOL eol) {
            switch (eol) {
                case CRLF: {
                    return LineEnding.WINDOWS;
                }
                case LF: {
                    return LineEnding.UNIX;
                }
                case NATIVE: {
                    return LineEnding.PLATFORM_NATIVE;
                }
            }
            throw new IllegalArgumentException("Unknown eol " + eol);
        }
    }

    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"})
    static class FileState
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final transient FileBasedConfig systemConfig;
        final transient FileBasedConfig userConfig;
        final transient FileBasedConfig repoConfig;
        @Nullable
        final transient File globalAttributesFile;
        @Nullable
        final transient File repoAttributesFile;
        @Nullable
        final transient File workTree;
        final transient List<File> gitattributes;
        final FileSignature signature;

        @SuppressFBWarnings(value={"SIC_INNER_SHOULD_BE_STATIC_ANON"})
        FileState(File projectDir, Iterable<File> toFormat) throws IOException {
            Objects.requireNonNull(projectDir);
            Objects.requireNonNull(toFormat);
            this.systemConfig = SystemReader.getInstance().openSystemConfig(null, FS.DETECTED);
            Errors.log().run(() -> ((FileBasedConfig)this.systemConfig).load());
            this.userConfig = SystemReader.getInstance().openUserConfig((Config)this.systemConfig, FS.DETECTED);
            Errors.log().run(() -> ((FileBasedConfig)this.userConfig).load());
            String globalAttributesPath = this.userConfig.getString("core", null, "attributesfile");
            if (globalAttributesPath != null) {
                FS fs = FS.detect();
                this.globalAttributesFile = globalAttributesPath.startsWith("~/") ? fs.resolve(fs.userHome(), globalAttributesPath.substring(2)) : fs.resolve(null, globalAttributesPath);
            } else {
                this.globalAttributesFile = null;
            }
            FileRepositoryBuilder builder = new FileRepositoryBuilder();
            builder.findGitDir(projectDir);
            if (builder.getGitDir() != null) {
                this.workTree = builder.getWorkTree();
                this.repoConfig = new FileBasedConfig((Config)this.userConfig, new File(builder.getGitDir(), "config"), FS.DETECTED);
                this.repoAttributesFile = new File(builder.getGitDir(), "info/attributes");
            } else {
                this.workTree = null;
                this.repoConfig = new FileBasedConfig((Config)this.userConfig, null, FS.DETECTED){

                    public void load() {
                    }

                    public boolean isOutdated() {
                        return false;
                    }
                };
                this.repoAttributesFile = null;
            }
            Errors.log().run(() -> ((FileBasedConfig)this.repoConfig).load());
            this.gitattributes = FileState.gitAttributes(toFormat);
            Stream<File> misc = Stream.of(this.systemConfig.getFile(), this.userConfig.getFile(), this.repoConfig.getFile(), this.globalAttributesFile, this.repoAttributesFile);
            List toSign = Stream.concat(this.gitattributes.stream(), misc).filter(file -> file != null && file.exists() && file.isFile()).collect(Collectors.toList());
            this.signature = FileSignature.from(toSign);
        }

        static List<File> gitAttributes(Iterable<File> files) {
            ConcurrentRadixTree tree = new ConcurrentRadixTree((NodeFactory)new DefaultCharSequenceNodeFactory());
            for (File file : files) {
                String parentPath = file.getParent() + File.separator;
                tree.putIfAbsent((CharSequence)parentPath, (Object)parentPath);
            }
            List edgeFolders = TreeStream.depthFirst(Node::getOutgoingEdges, (Object)tree.getNode()).filter(node -> node.getOutgoingEdges().isEmpty() && node.getValue() != null).map(node -> new File((String)node.getValue())).collect(Collectors.toList());
            ArrayList<File> gitAttrFiles = new ArrayList<File>();
            HashSet<File> visitedFolders = new HashSet<File>();
            for (File edgeFolder : edgeFolders) {
                FileState.gitAttrAddWithParents(edgeFolder, visitedFolders, gitAttrFiles);
            }
            return gitAttrFiles;
        }

        private static void gitAttrAddWithParents(File folder, Set<File> visitedFolders, Collection<File> gitAttrFiles) {
            File parentFile;
            if (!visitedFolders.add(folder)) {
                return;
            }
            File gitAttr = new File(folder, ".gitattributes");
            if (gitAttr.exists() && gitAttr.isFile()) {
                gitAttrFiles.add(gitAttr);
            }
            if ((parentFile = folder.getParentFile()) != null) {
                FileState.gitAttrAddWithParents(folder.getParentFile(), visitedFolders, gitAttrFiles);
            }
        }

        private Runtime atRuntime() {
            return new Runtime(GitAttributesLineEndings.parseRules(this.repoAttributesFile), this.workTree, (Config)this.repoConfig, GitAttributesLineEndings.parseRules(this.globalAttributesFile));
        }
    }

    static class Policy
    extends LazyForwardingEquality<FileState>
    implements LineEnding.Policy {
        private static final long serialVersionUID = 1L;
        final transient File projectDir;
        final transient Supplier<Iterable<File>> toFormat;
        transient Runtime runtime;

        Policy(File projectDir, Supplier<Iterable<File>> toFormat) {
            this.projectDir = Objects.requireNonNull(projectDir);
            this.toFormat = Objects.requireNonNull(toFormat);
        }

        protected FileState calculateState() throws Exception {
            return new FileState(this.projectDir, this.toFormat.get());
        }

        public String getEndingFor(File file) {
            if (this.runtime == null) {
                this.runtime = ((FileState)this.state()).atRuntime();
            }
            return this.runtime.getEndingFor(file);
        }
    }
}

