/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.java;

import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import groovy.util.Node;
import groovy.util.NodeList;
import groovy.util.XmlParser;
import groovy.xml.QName;
import java.io.File;
import java.io.FileInputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Properties;
import java.util.logging.Logger;

public final class EclipseFormatterStep {
    private static final String DEFAULT_VERSION = "4.6.1";
    private static final String NAME = "eclipse formatter";
    private static final String MAVEN_COORDINATE = "com.diffplug.spotless:spotless-ext-eclipse-jdt:";
    private static final String FORMATTER_CLASS = "com.diffplug.gradle.spotless.java.eclipse.EclipseFormatterStepImpl";
    private static final String FORMATTER_METHOD = "format";
    private static final Logger logger = Logger.getLogger(EclipseFormatterStep.class.getName());

    private EclipseFormatterStep() {
    }

    public static FormatterStep create(File settingsFile, Provisioner provisioner) {
        return EclipseFormatterStep.create(EclipseFormatterStep.defaultVersion(), settingsFile, provisioner);
    }

    public static FormatterStep create(String version, File settingsFile, Provisioner provisioner) {
        return FormatterStep.createLazy((String)NAME, () -> new State(JarState.from((String)(MAVEN_COORDINATE + version), (Provisioner)provisioner), settingsFile), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    private static Properties parseProperties(File file) throws Exception {
        Properties settings = new Properties();
        if (!file.exists()) {
            throw new IllegalArgumentException("Eclipse formatter file '" + file + "' does not exist.");
        }
        if (file.getName().endsWith(".properties")) {
            try (FileInputStream input = new FileInputStream(file);){
                settings.load(input);
            }
            return settings;
        }
        if (file.getName().endsWith(".xml")) {
            Node xmlSettings = new XmlParser().parse(file);
            NodeList profiles = xmlSettings.getAt(new QName("profile"));
            if (profiles.size() > 1) {
                logger.warning("Eclipse formatter file contains multiple profiles: " + file.getAbsolutePath());
                for (Object profile : profiles) {
                    Node node = (Node)profile;
                    logger.warning("    " + node.attribute((Object)"name"));
                }
                logger.warning("Using first profile, recommend deleting others.");
            }
            NodeList xmlSettingsElements = xmlSettings.getAt(new QName("profile")).getAt("setting");
            for (Object xmlSettingsElement : xmlSettingsElements) {
                Node setting = (Node)xmlSettingsElement;
                settings.put(setting.attributes().get("id"), setting.attributes().get("value"));
            }
            return settings;
        }
        throw new IllegalArgumentException("Eclipse formatter file must be .properties or .xml");
    }

    private static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;
        final FileSignature settings;

        State(JarState jar, File settingsFile) throws Exception {
            this.jarState = Objects.requireNonNull(jar);
            this.settings = FileSignature.from((File[])new File[]{settingsFile});
        }

        FormatterFunc createFormat() throws Exception {
            Properties parsedSettings = EclipseFormatterStep.parseProperties(this.settings.getOnlyFile());
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> formatterClazz = classLoader.loadClass(EclipseFormatterStep.FORMATTER_CLASS);
            Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(parsedSettings);
            Method method = formatterClazz.getMethod(EclipseFormatterStep.FORMATTER_METHOD, String.class);
            return input -> (String)method.invoke(formatter, input);
        }
    }
}

