/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra;

import com.diffplug.common.collect.ImmutableMap;
import com.diffplug.spotless.FileSignature;
import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterProperties;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.SerializedFunction;
import com.diffplug.spotless.extra.P2Mirror;
import dev.equo.solstice.NestedJars;
import dev.equo.solstice.p2.CacheLocations;
import dev.equo.solstice.p2.P2ClientCache;
import dev.equo.solstice.p2.P2Model;
import dev.equo.solstice.p2.P2QueryCache;
import dev.equo.solstice.p2.P2QueryResult;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public abstract class EquoBasedStepBuilder {
    private final String formatterName;
    private final Provisioner mavenProvisioner;
    private final SerializedFunction<State, FormatterFunc> stateToFormatter;
    private final ImmutableMap.Builder<String, String> stepProperties;
    private String formatterVersion;
    private Iterable<File> settingsFiles = new ArrayList<File>();
    private List<String> settingProperties = new ArrayList<String>();
    private Map<String, String> p2Mirrors = Map.of();
    private File cacheDirectory;

    public EquoBasedStepBuilder(String formatterName, Provisioner mavenProvisioner, @Nullable String defaultVersion, SerializedFunction<State, FormatterFunc> stateToFormatter, ImmutableMap.Builder<String, String> stepProperties) {
        this.formatterName = formatterName;
        this.mavenProvisioner = mavenProvisioner;
        this.formatterVersion = defaultVersion;
        this.stateToFormatter = stateToFormatter;
        this.stepProperties = stepProperties;
    }

    public void setVersion(String version) {
        this.formatterVersion = version;
    }

    public void setPreferences(Iterable<File> settingsFiles) {
        this.settingsFiles = settingsFiles;
    }

    public void setPropertyPreferences(List<String> propertyPreferences) {
        this.settingProperties = propertyPreferences;
    }

    public void setP2Mirrors(Map<String, String> p2Mirrors) {
        this.p2Mirrors = Map.copyOf(p2Mirrors);
    }

    public void setP2Mirrors(Collection<P2Mirror> p2Mirrors) {
        this.p2Mirrors = p2Mirrors.stream().collect(Collectors.toMap(P2Mirror::getPrefix, P2Mirror::getUrl));
    }

    public void setCacheDirectory(File cacheDirectory) {
        this.cacheDirectory = cacheDirectory;
    }

    protected abstract P2Model model(String var1);

    protected void addPlatformRepo(P2Model model, String version) {
        if (!version.startsWith("4.")) {
            throw new IllegalArgumentException("Expected 4.x");
        }
        int minorVersion = Integer.parseInt(version.substring("4.".length()));
        model.addP2Repo("https://download.eclipse.org/eclipse/updates/" + version + "/");
        model.getInstall().addAll(List.of("org.apache.felix.scr", "org.eclipse.equinox.event"));
        if (minorVersion >= 25) {
            model.getInstall().addAll(List.of("org.osgi.service.cm", "org.osgi.service.metatype"));
        }
    }

    public FormatterStep build() {
        EquoStep roundtrippableState = new EquoStep(this.formatterVersion, this.settingProperties, FileSignature.promise(this.settingsFiles), JarState.promise(() -> {
            P2QueryResult query;
            try {
                if (null != this.cacheDirectory) {
                    CacheLocations.override_p2data = this.cacheDirectory.toPath().resolve("dev/equo/p2-data").toFile();
                }
                query = this.createModelWithMirrors().query(P2ClientCache.PREFER_OFFLINE, P2QueryCache.ALLOW);
            }
            catch (Exception x) {
                throw new IOException("Failed to load " + this.formatterName + ": " + x, x);
            }
            ArrayList<File> classpath = new ArrayList<File>();
            ArrayList<String> mavenDeps = new ArrayList<String>();
            mavenDeps.add("dev.equo.ide:solstice:1.8.0");
            mavenDeps.add("com.diffplug.durian:durian-swt.os:4.2.0");
            mavenDeps.addAll(query.getJarsOnMavenCentral());
            classpath.addAll(this.mavenProvisioner.provisionWithTransitives(false, mavenDeps));
            classpath.addAll(query.getJarsNotOnMavenCentral());
            for (Map.Entry nested : NestedJars.inFiles((Iterable)query.getJarsNotOnMavenCentral()).extractAllNestedJars()) {
                classpath.add((File)nested.getValue());
            }
            return JarState.preserveOrder(classpath);
        }), (ImmutableMap<String, String>)this.stepProperties.build());
        return FormatterStep.create((String)this.formatterName, (Serializable)roundtrippableState, (SerializedFunction & Serializable)rec$ -> ((EquoStep)rec$).state(), this.stateToFormatter);
    }

    private P2Model createModelWithMirrors() {
        P2Model model = this.model(this.formatterVersion);
        if (this.p2Mirrors.isEmpty()) {
            return model;
        }
        ArrayList p2Repos = new ArrayList(model.getP2repo());
        p2Repos.replaceAll(url -> {
            for (Map.Entry<String, String> mirror : this.p2Mirrors.entrySet()) {
                String prefix = mirror.getKey();
                if (!url.startsWith(prefix)) continue;
                return mirror.getValue() + url.substring(prefix.length());
            }
            throw new IllegalStateException("no mirror configured for P2 repository: " + url);
        });
        model.getP2repo().clear();
        model.getP2repo().addAll(p2Repos);
        return model;
    }

    public static class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final String semanticVersion;
        final JarState jarState;
        final FileSignature settingsFiles;
        final ImmutableMap<String, String> stepProperties;
        private List<String> settingProperties;

        public State(String semanticVersion, JarState jarState, List<String> settingProperties, FileSignature settingsFiles, ImmutableMap<String, String> stepProperties) {
            this.semanticVersion = semanticVersion;
            this.jarState = jarState;
            this.settingProperties = Optional.ofNullable(settingProperties).orElse(new ArrayList());
            this.settingsFiles = settingsFiles;
            this.stepProperties = stepProperties;
        }

        public JarState getJarState() {
            return this.jarState;
        }

        public String getSemanticVersion() {
            return this.semanticVersion;
        }

        public Properties getPreferences() {
            FormatterProperties fromFiles = FormatterProperties.from((Iterable)this.settingsFiles.files());
            FormatterProperties fromPropertiesContent = FormatterProperties.fromPropertiesContent(this.settingProperties);
            return FormatterProperties.merge((Properties[])new Properties[]{fromFiles.getProperties(), fromPropertiesContent.getProperties()}).getProperties();
        }

        public ImmutableMap<String, String> getStepProperties() {
            return this.stepProperties;
        }
    }

    static class EquoStep
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String semanticVersion;
        private final FileSignature.Promised settingsPromise;
        private final JarState.Promised jarPromise;
        private final ImmutableMap<String, String> stepProperties;
        private List<String> settingProperties;

        EquoStep(String semanticVersion, List<String> settingProperties, FileSignature.Promised settingsPromise, JarState.Promised jarPromise, ImmutableMap<String, String> stepProperties) {
            this.semanticVersion = semanticVersion;
            this.settingProperties = Optional.ofNullable(settingProperties).orElse(new ArrayList());
            this.settingsPromise = settingsPromise;
            this.jarPromise = jarPromise;
            this.stepProperties = stepProperties;
        }

        private State state() {
            return new State(this.semanticVersion, this.jarPromise.get(), this.settingProperties, this.settingsPromise.get(), this.stepProperties);
        }
    }
}

