/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.extra.wtp;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.Jvm;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.SerializedFunction;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.extra.EclipseBasedStepBuilder;
import java.io.File;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Properties;

public enum EclipseWtpFormatterStep {
    CSS("EclipseCssFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithoutFile)),
    HTML("EclipseHtmlFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithoutFile)),
    JS("EclipseJsFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithoutFile)),
    JSON("EclipseJsonFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithoutFile)),
    XML("EclipseXmlFormatterStepImpl", (ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc>)((ThrowingEx.BiFunction)EclipseWtpFormatterStep::applyWithFile));

    private static final String NAME = "eclipse wtp formatter";
    private static final String FORMATTER_PACKAGE = "com.diffplug.spotless.extra.eclipse.wtp.";
    private static final Jvm.Support<String> JVM_SUPPORT;
    private static final String FORMATTER_METHOD = "format";
    private final String implementationClassName;
    private final ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc> formatterCall;

    private EclipseWtpFormatterStep(String implementationClassName, ThrowingEx.BiFunction<String, EclipseBasedStepBuilder.State, FormatterFunc> formatterCall) {
        this.implementationClassName = implementationClassName;
        this.formatterCall = formatterCall;
    }

    public EclipseBasedStepBuilder createBuilder(Provisioner provisioner) {
        return new EclipseBasedStepBuilder(NAME, " - " + this.toString(), provisioner, (SerializedFunction<EclipseBasedStepBuilder.State, FormatterFunc>)(SerializedFunction & Serializable)state -> (FormatterFunc)this.formatterCall.apply((Object)this.implementationClassName, state));
    }

    public static String defaultVersion() {
        return (String)JVM_SUPPORT.getRecommendedFormatterVersion();
    }

    private static FormatterFunc applyWithoutFile(String className, EclipseBasedStepBuilder.State state) throws Exception {
        JVM_SUPPORT.assertFormatterSupported((Object)state.getSemanticVersion());
        Class<?> formatterClazz = state.loadClass(FORMATTER_PACKAGE + className);
        Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class);
        return input -> {
            try {
                return (String)method.invoke(formatter, input);
            }
            catch (InvocationTargetException exceptionWrapper) {
                Exception e;
                Throwable throwable = exceptionWrapper.getTargetException();
                Exception exception = throwable instanceof Exception ? (e = (Exception)throwable) : null;
                throw null == exception ? exceptionWrapper : exception;
            }
        };
    }

    private static FormatterFunc applyWithFile(String className, EclipseBasedStepBuilder.State state) throws Exception {
        JVM_SUPPORT.assertFormatterSupported((Object)state.getSemanticVersion());
        Class<?> formatterClazz = state.loadClass(FORMATTER_PACKAGE + className);
        final Object formatter = formatterClazz.getConstructor(Properties.class).newInstance(state.getPreferences());
        final Method method = formatterClazz.getMethod(FORMATTER_METHOD, String.class, String.class);
        return JVM_SUPPORT.suggestLaterVersionOnError((Object)state.getSemanticVersion(), (FormatterFunc)new FormatterFunc.NeedsFile(){

            public String applyWithFile(String unix, File file) throws Exception {
                try {
                    return (String)method.invoke(formatter, unix, file.getAbsolutePath());
                }
                catch (InvocationTargetException exceptionWrapper) {
                    Exception e;
                    Throwable throwable = exceptionWrapper.getTargetException();
                    Exception exception = throwable instanceof Exception ? (e = (Exception)throwable) : null;
                    throw null == exception ? exceptionWrapper : exception;
                }
            }
        });
    }

    static {
        JVM_SUPPORT = Jvm.support((String)NAME).add(8, (Object)"4.18.0").add(11, (Object)"4.21.0");
    }
}

