/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

class FeatureClassLoader
extends URLClassLoader {
    static final List<String> BUILD_TOOLS_PACKAGES;
    private final ClassLoader buildToolClassLoader;

    FeatureClassLoader(URL[] urls, ClassLoader buildToolClassLoader) {
        super(urls, (ClassLoader)null);
        Objects.requireNonNull(buildToolClassLoader);
        this.buildToolClassLoader = buildToolClassLoader;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        for (String buildToolPackage : BUILD_TOOLS_PACKAGES) {
            if (!name.startsWith(buildToolPackage)) continue;
            return this.buildToolClassLoader.loadClass(name);
        }
        return super.findClass(name);
    }

    static {
        ClassLoader.registerAsParallelCapable();
        BUILD_TOOLS_PACKAGES = Collections.unmodifiableList(Arrays.asList("org.slf4j."));
    }
}

