/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.java.ImportSorterImpl;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

final class ImportSorter {
    private static final int START_INDEX_OF_IMPORTS_PACKAGE_DECLARATION = 7;
    static final String N = "\n";
    private final List<String> importsOrder;

    ImportSorter(List<String> importsOrder) {
        this.importsOrder = new ArrayList<String>(importsOrder);
    }

    String format(String raw, String lineFormat) {
        Scanner scanner = new Scanner(raw);
        int firstImportLine = 0;
        int lastImportLine = 0;
        int line = 0;
        boolean isMultiLineComment = false;
        ArrayList<String> imports = new ArrayList<String>();
        while (scanner.hasNext()) {
            ++line;
            String next = scanner.nextLine();
            if (next == null) break;
            if ((isMultiLineComment |= next.contains("/*")) && next.contains("*/")) {
                isMultiLineComment = false;
                if (!next.contains("/*")) continue;
            }
            if (next.startsWith("import ")) {
                int i = next.indexOf(".");
                if (ImportSorter.isNotValidImport(i)) continue;
                if (firstImportLine == 0) {
                    firstImportLine = line;
                }
                lastImportLine = line;
                int endIndex = next.indexOf(";");
                String imprt = next.substring(7, endIndex != -1 ? endIndex : next.length());
                if (!isMultiLineComment && !imports.contains(imprt)) {
                    imports.add(imprt);
                }
            }
            if (isMultiLineComment || !ImportSorter.isBeginningOfScope(next)) continue;
            break;
        }
        scanner.close();
        List<String> sortedImports = ImportSorterImpl.sort(imports, this.importsOrder, lineFormat);
        return ImportSorter.applyImportsToDocument(raw, firstImportLine, lastImportLine, sortedImports);
    }

    private static boolean isBeginningOfScope(String line) {
        int scope = line.indexOf("{");
        if (0 <= scope) {
            return !line.substring(0, scope).contains("//");
        }
        return false;
    }

    private static String applyImportsToDocument(String document, int firstImportLine, int lastImportLine, List<String> strings) {
        boolean importsAlreadyAppended = false;
        Scanner scanner = new Scanner(document);
        int curentLine = 0;
        StringBuilder sb = new StringBuilder();
        while (scanner.hasNext()) {
            ++curentLine;
            String next = scanner.nextLine();
            if (next == null) break;
            if (curentLine >= firstImportLine && curentLine <= lastImportLine) {
                if (!importsAlreadyAppended) {
                    for (String string : strings) {
                        sb.append(string);
                    }
                }
                importsAlreadyAppended = true;
                continue;
            }
            ImportSorter.append(sb, next);
        }
        scanner.close();
        if (!document.endsWith(N)) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private static void append(StringBuilder sb, String next) {
        sb.append(next);
        sb.append(N);
    }

    private static boolean isNotValidImport(int i) {
        return i <= 7;
    }
}

