/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.JarState;
import com.diffplug.spotless.LineEnding;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Objects;

public class GoogleJavaFormatStep {
    private static final String DEFAULT_VERSION = "1.7";
    private static final String DEFAULT_STYLE = "GOOGLE";
    static final String NAME = "google-java-format";
    static final String MAVEN_COORDINATE = "com.google.googlejavaformat:google-java-format:";
    static final String FORMATTER_CLASS = "com.google.googlejavaformat.java.Formatter";
    static final String FORMATTER_METHOD = "formatSource";
    private static final String OPTIONS_CLASS = "com.google.googlejavaformat.java.JavaFormatterOptions";
    private static final String OPTIONS_BUILDER_METHOD = "builder";
    private static final String OPTIONS_BUILDER_CLASS = "com.google.googlejavaformat.java.JavaFormatterOptions$Builder";
    private static final String OPTIONS_BUILDER_STYLE_METHOD = "style";
    private static final String OPTIONS_BUILDER_BUILD_METHOD = "build";
    private static final String OPTIONS_Style = "com.google.googlejavaformat.java.JavaFormatterOptions$Style";
    private static final String REMOVE_UNUSED_CLASS = "com.google.googlejavaformat.java.RemoveUnusedImports";
    private static final String REMOVE_UNUSED_METHOD = "removeUnusedImports";
    private static final String REMOVE_UNUSED_IMPORT_JavadocOnlyImports = "com.google.googlejavaformat.java.RemoveUnusedImports$JavadocOnlyImports";
    private static final String REMOVE_UNUSED_IMPORT_JavadocOnlyImports_Keep = "KEEP";
    private static final String IMPORT_ORDERER_CLASS = "com.google.googlejavaformat.java.ImportOrderer";
    private static final String IMPORT_ORDERER_METHOD = "reorderImports";
    private static final boolean IS_WINDOWS = LineEnding.PLATFORM_NATIVE.str().equals("\r\n");

    private GoogleJavaFormatStep() {
    }

    public static FormatterStep create(Provisioner provisioner) {
        return GoogleJavaFormatStep.create(GoogleJavaFormatStep.defaultVersion(), provisioner);
    }

    public static FormatterStep create(String version, Provisioner provisioner) {
        return GoogleJavaFormatStep.create(version, DEFAULT_STYLE, provisioner);
    }

    public static FormatterStep create(String version, String style, Provisioner provisioner) {
        Objects.requireNonNull(version, "version");
        Objects.requireNonNull(style, OPTIONS_BUILDER_STYLE_METHOD);
        Objects.requireNonNull(provisioner, "provisioner");
        return FormatterStep.createLazy(NAME, () -> new State(NAME, version, style, provisioner), State::createFormat);
    }

    public static String defaultVersion() {
        return DEFAULT_VERSION;
    }

    public static String defaultStyle() {
        return DEFAULT_STYLE;
    }

    static String fixWindowsBug(String input, String version) {
        if (IS_WINDOWS && version.equals("1.1")) {
            int firstImport = input.indexOf("\nimport ");
            if (firstImport == 0) {
                return input;
            }
            if (firstImport > 0) {
                char prevChar;
                int numToTrim = 0;
                while (Character.isWhitespace(prevChar = input.charAt(firstImport - ++numToTrim)) && firstImport - numToTrim > 0) {
                }
                if (firstImport - numToTrim == 0) {
                    ++numToTrim;
                } else if (prevChar == ';' || prevChar == '/') {
                    --numToTrim;
                }
                if (numToTrim > 0) {
                    return input.substring(0, firstImport - numToTrim + 2) + input.substring(firstImport + 1);
                }
            }
        }
        return input;
    }

    static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        final JarState jarState;
        final String stepName;
        final String version;
        final String style;

        State(String stepName, String version, Provisioner provisioner) throws IOException {
            this(stepName, version, GoogleJavaFormatStep.DEFAULT_STYLE, provisioner);
        }

        State(String stepName, String version, String style, Provisioner provisioner) throws IOException {
            this.jarState = JarState.from(GoogleJavaFormatStep.MAVEN_COORDINATE + version, provisioner);
            this.stepName = stepName;
            this.version = version;
            this.style = style;
        }

        FormatterFunc createFormat() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            Class<?> optionsClass = classLoader.loadClass(GoogleJavaFormatStep.OPTIONS_CLASS);
            Class<?> optionsBuilderClass = classLoader.loadClass(GoogleJavaFormatStep.OPTIONS_BUILDER_CLASS);
            Method optionsBuilderMethod = optionsClass.getMethod(GoogleJavaFormatStep.OPTIONS_BUILDER_METHOD, new Class[0]);
            Object optionsBuilder = optionsBuilderMethod.invoke(null, new Object[0]);
            Class<?> optionsStyleClass = classLoader.loadClass(GoogleJavaFormatStep.OPTIONS_Style);
            Object styleConstant = Enum.valueOf(optionsStyleClass, this.style);
            Method optionsBuilderStyleMethod = optionsBuilderClass.getMethod(GoogleJavaFormatStep.OPTIONS_BUILDER_STYLE_METHOD, optionsStyleClass);
            optionsBuilderStyleMethod.invoke(optionsBuilder, styleConstant);
            Method optionsBuilderBuildMethod = optionsBuilderClass.getMethod(GoogleJavaFormatStep.OPTIONS_BUILDER_BUILD_METHOD, new Class[0]);
            Object options = optionsBuilderBuildMethod.invoke(optionsBuilder, new Object[0]);
            Class<?> formatterClazz = classLoader.loadClass(GoogleJavaFormatStep.FORMATTER_CLASS);
            Object formatter = formatterClazz.getConstructor(optionsClass).newInstance(options);
            Method formatterMethod = formatterClazz.getMethod(GoogleJavaFormatStep.FORMATTER_METHOD, String.class);
            ThrowingEx.Function<String, String> removeUnused = State.constructRemoveUnusedFunction(classLoader);
            Class<?> importOrdererClass = classLoader.loadClass(GoogleJavaFormatStep.IMPORT_ORDERER_CLASS);
            Method importOrdererMethod = importOrdererClass.getMethod(GoogleJavaFormatStep.IMPORT_ORDERER_METHOD, String.class);
            return input -> {
                String formatted = (String)formatterMethod.invoke(formatter, input);
                String removedUnused = (String)removeUnused.apply(formatted);
                String sortedImports = (String)importOrdererMethod.invoke(null, removedUnused);
                return GoogleJavaFormatStep.fixWindowsBug(sortedImports, this.version);
            };
        }

        FormatterFunc createRemoveUnusedImportsOnly() throws Exception {
            ClassLoader classLoader = this.jarState.getClassLoader();
            ThrowingEx.Function<String, String> removeUnused = State.constructRemoveUnusedFunction(classLoader);
            return input -> GoogleJavaFormatStep.fixWindowsBug((String)removeUnused.apply((String)input), this.version);
        }

        private static ThrowingEx.Function<String, String> constructRemoveUnusedFunction(ClassLoader classLoader) throws NoSuchMethodException, ClassNotFoundException {
            ThrowingEx.Function<String, String> removeUnused;
            Class<?> removeJavadocOnlyClass;
            Class<?> removeUnusedClass = classLoader.loadClass(GoogleJavaFormatStep.REMOVE_UNUSED_CLASS);
            try {
                removeJavadocOnlyClass = classLoader.loadClass(GoogleJavaFormatStep.REMOVE_UNUSED_IMPORT_JavadocOnlyImports);
            }
            catch (ClassNotFoundException e) {
                removeJavadocOnlyClass = null;
            }
            if (removeJavadocOnlyClass != null) {
                Object removeJavadocConstant = Enum.valueOf(removeJavadocOnlyClass, GoogleJavaFormatStep.REMOVE_UNUSED_IMPORT_JavadocOnlyImports_Keep);
                Method removeUnusedMethod = removeUnusedClass.getMethod(GoogleJavaFormatStep.REMOVE_UNUSED_METHOD, String.class, removeJavadocOnlyClass);
                removeUnused = x -> (String)removeUnusedMethod.invoke(null, x, removeJavadocConstant);
            } else {
                Method removeUnusedMethod = removeUnusedClass.getMethod(GoogleJavaFormatStep.REMOVE_UNUSED_METHOD, String.class);
                removeUnused = x -> (String)removeUnusedMethod.invoke(null, x);
            }
            return removeUnused;
        }
    }
}

